/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.manapool;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.block.ModBlocks;

public class ManaPoolRecipeWrapper
implements IRecipeWrapper {
    private final List input;
    private final ItemStack output;
    private final int mana;

    public ManaPoolRecipeWrapper(RecipeManaInfusion recipe) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (recipe.getInput() instanceof ItemStack) {
            builder.add(recipe.getInput());
        } else if (recipe.getInput() instanceof String) {
            builder.add((Object)OreDictionary.getOres((String)((String)recipe.getInput())));
        }
        if (recipe.isAlchemy()) {
            builder.add((Object)new ItemStack(ModBlocks.alchemyCatalyst));
        } else if (recipe.isConjuration()) {
            builder.add((Object)new ItemStack(ModBlocks.conjurationCatalyst));
        }
        this.input = builder.build();
        this.output = recipe.getOutput();
        this.mana = recipe.getManaToConsume();
    }

    public List getInputs() {
        return this.input;
    }

    public List getOutputs() {
        return ImmutableList.of((Object)this.output);
    }

    public List<FluidStack> getFluidInputs() {
        return ImmutableList.of();
    }

    public List<FluidStack> getFluidOutputs() {
        return ImmutableList.of();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        GlStateManager.func_179141_d();
        HUDHandler.renderManaBar(28, 50, 255, 0.75f, this.mana, 100000);
        GlStateManager.func_179118_c();
    }

    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }
}

