/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.runicaltar;

import java.awt.Point;
import java.util.Collection;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import vazkii.botania.client.integration.jei.runicaltar.RunicAltarRecipeWrapper;
import vazkii.botania.common.block.ModBlocks;

public class RunicAltarRecipeCategory
implements IRecipeCategory {
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;

    public RunicAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 110);
        this.localizedName = StatCollector.func_74838_a((String)"botania.nei.runicAltar");
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/petalOverlay.png"), 0, 0, 150, 110);
    }

    @Nonnull
    public String getUid() {
        return "botania.runicAltar";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.overlay.draw(minecraft);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        if (!(recipeWrapper instanceof RunicAltarRecipeWrapper)) {
            return;
        }
        RunicAltarRecipeWrapper wrapper = (RunicAltarRecipeWrapper)recipeWrapper;
        recipeLayout.getItemStacks().init(0, true, 64, 52);
        recipeLayout.getItemStacks().set(0, new ItemStack(ModBlocks.runeAltar));
        int index = 1;
        double angleBetweenEach = 360.0 / (double)wrapper.getInputs().size();
        Point point = new Point(64, 20);
        Point center = new Point(64, 52);
        for (Object o : wrapper.getInputs()) {
            recipeLayout.getItemStacks().init(index, true, point.x, point.y);
            if (o instanceof Collection) {
                recipeLayout.getItemStacks().set(index, (Collection)o);
            }
            if (o instanceof ItemStack) {
                recipeLayout.getItemStacks().set(index, (ItemStack)o);
            }
            ++index;
            point = this.rotatePointAbout(point, center, angleBetweenEach);
        }
        recipeLayout.getItemStacks().init(index, false, 103, 17);
        recipeLayout.getItemStacks().set(index, wrapper.getOutputs().get(0));
    }

    private Point rotatePointAbout(Point in, Point about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Point((int)newX, (int)newY);
    }
}

