/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.item.block.ItemBlockFloatingSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class FloatingFlowerModel
implements ISmartItemModel,
ISmartBlockModel,
IResourceManagerReloadListener {
    public static final FloatingFlowerModel INSTANCE = new FloatingFlowerModel();
    private static Table<IFloatingFlower.IslandType, String, CompositeBakedModel> CACHE = HashBasedTable.create();
    private static final String MUNDANE_PREFIX = "botania:shimmeringFlower_";

    public void func_110549_a(IResourceManager resourceManager) {
        CACHE.clear();
    }

    public IBakedModel handleItemState(ItemStack stack) {
        IFloatingFlower.IslandType islandType = IFloatingFlower.IslandType.GRASS;
        String identifier = Block.func_149634_a((Item)stack.func_77973_b()) == ModBlocks.floatingSpecialFlower ? ItemBlockFloatingSpecialFlower.getType(stack) : MUNDANE_PREFIX + stack.func_77952_i();
        return this.getModel(islandType, identifier);
    }

    public IBakedModel handleBlockState(IBlockState state) {
        String identifier;
        IFloatingFlower.IslandType islandType = (IFloatingFlower.IslandType)((Object)state.func_177229_b(BlockFloatingFlower.ISLAND_TYPE));
        if (state.func_177230_c() == ModBlocks.floatingSpecialFlower) {
            IExtendedBlockState realState = (IExtendedBlockState)state;
            identifier = (String)realState.getValue((IUnlistedProperty)BotaniaStateProps.SUBTILE_ID);
        } else {
            identifier = MUNDANE_PREFIX + ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
        }
        return this.getModel(islandType, identifier);
    }

    private CompositeBakedModel getModel(IFloatingFlower.IslandType islandType, String identifier) {
        IBakedModel flowerModel;
        ModelManager modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        if (CACHE.contains((Object)islandType, (Object)identifier)) {
            return (CompositeBakedModel)CACHE.get((Object)islandType, (Object)identifier);
        }
        IBakedModel islandModel = modelManager.func_174953_a(new ModelResourceLocation("botania:miniIsland", "variant=" + islandType.func_176610_l()));
        if (identifier.startsWith(MUNDANE_PREFIX)) {
            int meta = Integer.parseInt(identifier.substring(identifier.indexOf(MUNDANE_PREFIX) + MUNDANE_PREFIX.length()));
            flowerModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(ModBlocks.shinyFlower, 1, meta));
        } else {
            flowerModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(ItemBlockSpecialFlower.ofType(identifier));
        }
        CompositeBakedModel model = new CompositeBakedModel(flowerModel, islandModel);
        CACHE.put((Object)islandType, (Object)identifier, (Object)model);
        return model;
    }

    protected static BakedQuad transform(BakedQuad quad, final TRSRTransformation transform) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement formatElement = DefaultVertexFormats.field_176599_b.func_177348_c(element);
                switch (formatElement.func_177375_c()) {
                    case POSITION: {
                        float[] newData = new float[4];
                        Vector4f vec = new Vector4f(data);
                        transform.getMatrix().transform((Tuple4f)vec);
                        vec.get(newData);
                        this.parent.put(element, newData);
                        break;
                    }
                    default: {
                        this.parent.put(element, data);
                    }
                }
            }
        };
        quad.pipe((IVertexConsumer)consumer);
        return builder.build();
    }

    public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
        return ImmutableList.of();
    }

    public List<BakedQuad> func_177550_a() {
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private static class CompositeBakedModel
    implements IBakedModel {
        private final IBakedModel base;
        private final List<BakedQuad> genQuads;

        public CompositeBakedModel(IBakedModel flower, IBakedModel island) {
            this.base = flower;
            ImmutableList.Builder genBuilder = ImmutableList.builder();
            final TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null));
            for (BakedQuad quad : flower.func_177550_a()) {
                genBuilder.add((Object)FloatingFlowerModel.transform(quad, transform));
            }
            for (EnumFacing e : EnumFacing.field_82609_l) {
                genBuilder.addAll(Iterables.transform((Iterable)flower.func_177551_a(e), (Function)new Function<BakedQuad, BakedQuad>(){

                    public BakedQuad apply(BakedQuad input) {
                        return FloatingFlowerModel.transform(input, transform);
                    }
                }));
            }
            genBuilder.addAll((Iterable)island.func_177550_a());
            for (EnumFacing e : EnumFacing.field_82609_l) {
                genBuilder.addAll((Iterable)island.func_177551_a(e));
            }
            this.genQuads = genBuilder.build();
        }

        public List<BakedQuad> func_177550_a() {
            return this.genQuads;
        }

        public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return this.base.func_177555_b();
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_177553_d() {
            return this.base.func_177553_d();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.base.func_177552_f();
        }
    }
}

