/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.model.IPylonModel;

public class ModelPylon
implements IPylonModel {
    private IFlexibleBakedModel manaCrystal;
    private IFlexibleBakedModel manaRingsAndPanes;
    private IFlexibleBakedModel manaGems;
    private IFlexibleBakedModel naturaCrystal;
    private IFlexibleBakedModel naturaRingsAndPanes;
    private IFlexibleBakedModel naturaGems;
    private IFlexibleBakedModel gaiaCrystal;
    private IFlexibleBakedModel gaiaRingsAndPanes;
    private IFlexibleBakedModel gaiaGems;
    private static final Function<ResourceLocation, TextureAtlasSprite> TEXTUREGETTER = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation input) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(input.toString());
        }
    };
    private static final Set<String> GROUP_NAMES = ImmutableSet.of((Object)"Crystal", (Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04", (Object[])new String[]{"Ring_Gem01", "Ring_Gem02", "Ring_Gem03", "Ring_Gem04"});

    public ModelPylon() {
        try {
            OBJModel model = (OBJModel)OBJLoader.instance.loadModel(new ResourceLocation("botania:models/block/pylon.obj"));
            IModel manaModel = ((OBJModel)model.retexture(ImmutableMap.of((Object)"#pylon", (Object)"botania:model/pylon"))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            IModel naturaModel = ((OBJModel)model.retexture(ImmutableMap.of((Object)"#pylon", (Object)"botania:model/pylon1"))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            IModel gaiaModel = ((OBJModel)model.retexture(ImmutableMap.of((Object)"#pylon", (Object)"botania:model/pylon2"))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            this.manaCrystal = manaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04", (Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.naturaCrystal = naturaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04", (Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.gaiaCrystal = gaiaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04", (Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.manaRingsAndPanes = manaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal", (Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.naturaRingsAndPanes = naturaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal", (Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.gaiaRingsAndPanes = gaiaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal", (Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.manaGems = manaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal", (Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.naturaGems = naturaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal", (Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.gaiaGems = gaiaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal", (Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
        }
        catch (IOException e) {
            throw new ReportedException(new CrashReport("Error making pylon submodels for TESR!", (Throwable)e));
        }
    }

    @Override
    public void renderCrystal(PylonVariant variant) {
        switch (variant) {
            case MANA: {
                this.renderModel(this.manaCrystal);
                break;
            }
            case NATURA: {
                this.renderModel(this.naturaCrystal);
                break;
            }
            case GAIA: {
                this.renderModel(this.gaiaCrystal);
            }
        }
    }

    @Override
    public void renderRing(PylonVariant variant) {
        switch (variant) {
            case MANA: {
                this.renderModel(this.manaRingsAndPanes);
                break;
            }
            case NATURA: {
                this.renderModel(this.naturaRingsAndPanes);
                break;
            }
            case GAIA: {
                this.renderModel(this.gaiaRingsAndPanes);
            }
        }
    }

    @Override
    public void renderGems(PylonVariant variant) {
        switch (variant) {
            case MANA: {
                this.renderModel(this.manaGems);
                break;
            }
            case NATURA: {
                this.renderModel(this.naturaGems);
                break;
            }
            case GAIA: {
                this.renderModel(this.gaiaGems);
            }
        }
    }

    private void renderModel(IFlexibleBakedModel model) {
        this.renderModel(model, -1);
    }

    private void renderModel(IFlexibleBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, model.getFormat());
        this.renderQuads(worldrenderer, model.func_177550_a(), color);
        tessellator.func_78381_a();
    }

    private void renderQuads(WorldRenderer renderer, List<BakedQuad> quads, int color) {
        for (BakedQuad bakedquad : quads) {
            LightUtil.renderQuadColor((WorldRenderer)renderer, (BakedQuad)bakedquad, (int)color);
        }
    }
}

