/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class SpecialFlowerModel
implements IModelCustomData {
    public static final SpecialFlowerModel INSTANCE = new SpecialFlowerModel((ImmutableMap<Optional<String>, ModelResourceLocation>)ImmutableMap.of(), (ImmutableMap<Optional<String>, ModelResourceLocation>)ImmutableMap.of());
    private final ImmutableMap<Optional<String>, ModelResourceLocation> blockModels;
    private final ImmutableMap<Optional<String>, ModelResourceLocation> itemModels;

    public SpecialFlowerModel(ImmutableMap<Optional<String>, ModelResourceLocation> blockModels, ImmutableMap<Optional<String>, ModelResourceLocation> itemModels) {
        this.blockModels = blockModels;
        this.itemModels = itemModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.blockModels.values());
        builder.addAll((Iterable)this.itemModels.values());
        for (IFloatingFlower.IslandType i : IFloatingFlower.IslandType.values()) {
            builder.add((Object)new ModelResourceLocation("botania:miniIsland", "variant=" + i.name().toLowerCase(Locale.ROOT)));
        }
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new SpecialFlowerBakedModel(this.blockModels, this.itemModels, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder blockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (String string : customData.keySet()) {
            if (!"base".equals(string)) continue;
            blockBuilder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)string)));
        }
        for (Map.Entry entry : BotaniaAPIClient.queuedBlockModels.entrySet()) {
            blockBuilder.put((Object)Optional.of(entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : BotaniaAPIClient.queuedItemModels.entrySet()) {
            itemBuilder.put((Object)Optional.of(entry.getKey()), entry.getValue());
        }
        ImmutableMap blockModels = blockBuilder.build();
        ImmutableMap immutableMap = itemBuilder.build();
        if (blockModels.isEmpty() && immutableMap.isEmpty()) {
            return INSTANCE;
        }
        return new SpecialFlowerModel((ImmutableMap<Optional<String>, ModelResourceLocation>)blockModels, (ImmutableMap<Optional<String>, ModelResourceLocation>)immutableMap);
    }

    private ModelResourceLocation getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new ModelResourceLocation(e.getAsString());
        }
        FMLLog.severe((String)"Expect ModelResourceLocation, got: ", (Object[])new Object[]{json});
        return new ModelResourceLocation("builtin/missing", "missing");
    }

    public static class SpecialFlowerBakedModel
    implements IPerspectiveAwareModel,
    ISmartBlockModel,
    ISmartItemModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableMap<Optional<String>, ModelResourceLocation> blockModels;
        private final ImmutableMap<Optional<String>, ModelResourceLocation> itemModels;
        private final VertexFormat vertexFormat;
        private IBakedModel baseModel;
        private ImmutableMap<String, IBakedModel> bakedBlockModels;
        private ImmutableMap<String, IBakedModel> bakedItemModels;
        private ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> quads;

        public SpecialFlowerBakedModel(ImmutableMap<Optional<String>, ModelResourceLocation> blockModels, ImmutableMap<Optional<String>, ModelResourceLocation> itemModels, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.blockModels = blockModels;
            this.itemModels = itemModels;
            this.vertexFormat = format;
            this.transforms = cameraTransforms;
        }

        private void refreshBakedModels() {
            if (this.baseModel == null) {
                ModelManager manager = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b();
                this.baseModel = this.getBlockModel(manager, (Optional<String>)Optional.absent());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry e : this.blockModels.entrySet()) {
                    if (!((Optional)e.getKey()).isPresent()) continue;
                    builder.put(((Optional)e.getKey()).get(), (Object)this.getBlockModel(manager, (Optional<String>)((Optional)e.getKey())));
                }
                this.bakedBlockModels = builder.build();
                ImmutableMap.Builder builder2 = ImmutableMap.builder();
                for (Map.Entry e : this.itemModels.entrySet()) {
                    if (!((Optional)e.getKey()).isPresent()) continue;
                    builder2.put(((Optional)e.getKey()).get(), (Object)this.getItemModel(manager, (Optional<String>)((Optional)e.getKey())));
                }
                this.bakedItemModels = builder2.build();
                ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
                quadBuilder.put((Object)Optional.absent(), this.buildQuads((Optional<EnumFacing>)Optional.absent()));
                for (EnumFacing side : EnumFacing.values()) {
                    quadBuilder.put((Object)Optional.of((Object)side), this.buildQuads((Optional<EnumFacing>)Optional.of((Object)side)));
                }
                this.quads = quadBuilder.build();
            }
        }

        private IBakedModel getBlockModel(ModelManager manager, Optional<String> opt) {
            ModelResourceLocation loc = (ModelResourceLocation)this.blockModels.get(opt);
            if (loc == null) {
                loc = new ModelResourceLocation("builtin/missing", "missing");
            }
            return manager.func_174953_a(loc);
        }

        private IBakedModel getItemModel(ModelManager manager, Optional<String> opt) {
            ModelResourceLocation loc = (ModelResourceLocation)this.itemModels.get(opt);
            if (loc == null) {
                loc = new ModelResourceLocation("builtin/missing", "missing");
            }
            return manager.func_174953_a(loc);
        }

        private ImmutableList<BakedQuad> buildQuads(Optional<EnumFacing> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IBakedModel model : this.bakedBlockModels.values()) {
                if (side.isPresent()) {
                    builder.addAll((Iterable)model.func_177551_a((EnumFacing)side.get()));
                    continue;
                }
                builder.addAll((Iterable)model.func_177550_a());
            }
            for (IBakedModel model : this.bakedItemModels.values()) {
                if (side.isPresent()) {
                    builder.addAll((Iterable)model.func_177551_a((EnumFacing)side.get()));
                    continue;
                }
                builder.addAll((Iterable)model.func_177550_a());
            }
            return builder.build();
        }

        public List<BakedQuad> func_177551_a(EnumFacing side) {
            this.refreshBakedModels();
            return (List)this.quads.get((Object)Optional.of((Object)side));
        }

        public List<BakedQuad> func_177550_a() {
            this.refreshBakedModels();
            return (List)this.quads.get((Object)Optional.absent());
        }

        public boolean func_177555_b() {
            this.refreshBakedModels();
            return this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            this.refreshBakedModels();
            return this.baseModel.func_177556_c();
        }

        public boolean func_177553_d() {
            this.refreshBakedModels();
            return this.baseModel.func_177553_d();
        }

        public TextureAtlasSprite func_177554_e() {
            this.refreshBakedModels();
            return this.baseModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public IBakedModel handleBlockState(IBlockState state) {
            this.refreshBakedModels();
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IBakedModel ret = (IBakedModel)this.bakedBlockModels.get(extendedState.getValue((IUnlistedProperty)BotaniaStateProps.SUBTILE_ID));
            return ret == null ? Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a() : ret;
        }

        public VertexFormat getFormat() {
            return this.vertexFormat;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public IBakedModel handleItemState(ItemStack stack) {
            this.refreshBakedModels();
            IBakedModel item = (IBakedModel)this.bakedItemModels.get((Object)ItemBlockSpecialFlower.getType(stack));
            if (item == null) {
                item = (IBakedModel)this.bakedBlockModels.get((Object)ItemBlockSpecialFlower.getType(stack));
            }
            return item == null ? Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a() : item;
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE{

            public void func_110549_a(IResourceManager resourceManager) {
            }

            public boolean accepts(ResourceLocation modelLocation) {
                return modelLocation.func_110624_b().equals("botania_special") && (modelLocation.func_110623_a().equals("specialFlower") || modelLocation.func_110623_a().equals("models/block/specialFlower") || modelLocation.func_110623_a().equals("models/item/specialFlower"));
            }

            public IModel loadModel(ResourceLocation modelLocation) throws IOException {
                return SpecialFlowerModel.INSTANCE;
            }
        };

    }
}

