/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAltGrass
extends BlockMod
implements ILexiconable {
    public BlockAltGrass() {
        super(Material.field_151577_b);
        this.func_149711_c(0.6f);
        this.func_149672_a(field_149779_h);
        this.func_149663_c("altGrass");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.DRY)));
        this.func_149675_a(true);
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.ALTGRASS_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((AltGrassVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTGRASS_VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.values()[meta]));
    }

    @Override
    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    @Override
    protected boolean shouldRegisterInNameSet() {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 6; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && world.func_175699_k(pos.func_177984_a()) >= 9) {
            AltGrassVariant variant = (AltGrassVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTGRASS_VARIANT));
            for (int l = 0; l < 4; ++l) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                world.func_180495_p(pos1.func_177984_a()).func_177230_c();
                if (world.func_180495_p(pos1).func_177230_c() != Blocks.field_150346_d || world.func_180495_p(pos1).func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || world.func_175699_k(pos1.func_177984_a()) < 4 || world.getBlockLightOpacity(pos1.func_177984_a()) > 2) continue;
                world.func_180501_a(pos1, this.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)variant)), 3);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random p_149650_2_, int p_149650_3_) {
        return Blocks.field_150346_d.func_180660_a(state, p_149650_2_, p_149650_3_);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos.func_177977_b()) == EnumPlantType.Plains;
    }

    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random r) {
        AltGrassVariant variant = (AltGrassVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTGRASS_VARIANT));
        switch (variant) {
            case DRY: {
                break;
            }
            case GOLDEN: {
                break;
            }
            case VIVID: {
                break;
            }
            case SCORCHED: {
                if (r.nextInt(80) != 0) break;
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + r.nextFloat()), (double)pos.func_177956_o() + 1.1, (double)((float)pos.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case INFUSED: {
                if (r.nextInt(100) != 0) break;
                Botania.proxy.sparkleFX(world, (float)pos.func_177958_n() + r.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + r.nextFloat(), 0.0f, 1.0f, 1.0f, r.nextFloat() * 0.2f + 1.0f, 5);
                break;
            }
            case MUTATED: {
                if (r.nextInt(100) != 0) break;
                if (r.nextInt(100) > 25) {
                    Botania.proxy.sparkleFX(world, (float)pos.func_177958_n() + r.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + r.nextFloat(), 1.0f, 0.0f, 1.0f, r.nextFloat() * 0.2f + 1.0f, 5);
                    break;
                }
                Botania.proxy.sparkleFX(world, (float)pos.func_177958_n() + r.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + r.nextFloat(), 1.0f, 1.0f, 0.0f, r.nextFloat() * 0.2f + 1.0f, 5);
            }
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.grassSeeds;
    }
}

