/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAltar
extends BlockModContainer
implements ILexiconable {
    Random random;

    protected BlockAltar() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("altar");
        float f = 0.125f;
        this.func_149676_a(f, f, f, 1.0f - f, 1.25f, 1.0f - f);
        this.random = new Random();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.ALTAR_VARIANT, (Comparable)((Object)AltarVariant.DEFAULT)));
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        if (collidingEntity instanceof EntityItem) {
            float f = 0.125f;
            this.func_149676_a(f, f, f, 1.0f - f, 0.65f, 1.0f - f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            this.func_149676_a(f, f, f, 1.0f - f, 1.25f, 1.0f - f);
            return;
        }
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.ALTAR_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((AltarVariant)((Object)state.func_177229_b(BotaniaStateProps.ALTAR_VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= AltarVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.ALTAR_VARIANT, (Comparable)((Object)AltarVariant.values()[meta]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileAltar) {
            TileAltar altar = (TileAltar)te;
            if (altar.isMossy) {
                state = state.func_177226_a(BotaniaStateProps.ALTAR_VARIANT, (Comparable)((Object)AltarVariant.MOSSY));
            }
        }
        return state;
    }

    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    protected boolean shouldRegisterInNameSet() {
        return false;
    }

    @Override
    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 9; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_180634_a(World par1World, BlockPos pos, IBlockState state, Entity par5Entity) {
        TileAltar tile;
        if (par5Entity instanceof EntityItem && (tile = (TileAltar)par1World.func_175625_s(pos)).collideEntityItem((EntityItem)par5Entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
        }
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileAltar tile = (TileAltar)world.func_175625_s(pos);
        return tile != null && tile.hasLava ? 15 : 0;
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumFacing par6, float par7, float par8, float par9) {
        ItemStack stack = par5EntityPlayer.func_71045_bC();
        TileAltar tile = (TileAltar)par1World.func_175625_s(pos);
        if (par5EntityPlayer.func_70093_af()) {
            for (int i = tile.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack stackAt = tile.func_70301_a(i);
                if (stackAt == null) continue;
                ItemStack copy = stackAt.func_77946_l();
                if (!par5EntityPlayer.field_71071_by.func_70441_a(copy)) {
                    par5EntityPlayer.func_71019_a(copy, false);
                }
                tile.func_70299_a(i, null);
                par1World.func_175666_e(pos, (Block)this);
                break;
            }
        } else if (tile.isEmpty() && tile.hasWater && stack == null) {
            tile.trySetLastRecipe(par5EntityPlayer);
        } else {
            if (stack != null && (this.isValidWaterContainer(stack) || stack.func_77973_b() == ModItems.waterRod && ManaItemHandler.requestManaExact(stack, par5EntityPlayer, 75, false))) {
                if (!tile.hasWater) {
                    if (stack.func_77973_b() == ModItems.waterRod) {
                        ManaItemHandler.requestManaExact(stack, par5EntityPlayer, 75, true);
                    } else if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                        par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, this.getContainer(stack));
                    }
                    tile.setWater(true);
                    par1World.func_175666_e(pos, (Block)this);
                    par1World.func_175664_x(pos);
                }
                return true;
            }
            if (stack != null && stack.func_77973_b() == Items.field_151129_at) {
                if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                    par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, this.getContainer(stack));
                }
                tile.setLava(true);
                tile.setWater(false);
                par1World.func_175666_e(pos, (Block)this);
                par1World.func_175664_x(pos);
                return true;
            }
            if (stack != null && stack.func_77973_b() == Items.field_151133_ar && (tile.hasWater || tile.hasLava) && !Botania.gardenOfGlassLoaded) {
                ItemStack bucket;
                ItemStack itemStack = bucket = tile.hasLava ? new ItemStack(Items.field_151129_at) : new ItemStack(Items.field_151131_as);
                if (stack.field_77994_a == 1) {
                    par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, bucket);
                } else {
                    if (!par5EntityPlayer.field_71071_by.func_70441_a(bucket)) {
                        par5EntityPlayer.func_71019_a(bucket, false);
                    }
                    --stack.field_77994_a;
                }
                if (tile.hasLava) {
                    tile.setLava(false);
                } else {
                    tile.setWater(false);
                }
                par1World.func_175666_e(pos, (Block)this);
                par1World.func_175664_x(pos);
                return true;
            }
        }
        return false;
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity tile;
        if (world.field_73012_v.nextInt(20) == 1 && (tile = world.func_175625_s(pos)) instanceof TileAltar) {
            TileAltar altar = (TileAltar)tile;
            if (!altar.hasLava && !altar.hasWater) {
                altar.setWater(true);
            }
            world.func_175666_e(pos, (Block)this);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    private boolean isValidWaterContainer(ItemStack stack) {
        if (stack == null || stack.field_77994_a != 1) {
            return false;
        }
        if (stack.func_77973_b() == ModItems.waterBowl) {
            return true;
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            return fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER && fluidStack.amount >= 1000;
        }
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        return fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER && fluidStack.amount >= 1000;
    }

    private ItemStack getContainer(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.waterBowl) {
            return new ItemStack(Items.field_151054_z);
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            ((IFluidContainerItem)stack.func_77973_b()).drain(stack, 1000, true);
            return stack;
        }
        return FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileAltar();
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)par1World.func_175625_s(pos);
        if (inv != null) {
            for (int j1 = 0; j1 < inv.func_70302_i_(); ++j1) {
                ItemStack itemstack = inv.func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77952_i()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(par1World, pos, state);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World par1World, BlockPos pos) {
        TileAltar altar = (TileAltar)par1World.func_175625_s(pos);
        return altar.hasWater ? 15 : 0;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.apothecary;
    }
}

