/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.lib.LibRenderIDs;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.TileAvatar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAvatar
extends BlockModContainer
implements ILexiconable {
    Random random;

    protected BlockAvatar() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("avatar");
        this.setBlockBounds(EnumFacing.Axis.Z);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.NORTH));
        this.random = new Random();
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 2 || meta > 5) {
            meta = 2;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing s, float xs, float ys, float zs) {
        TileAvatar avatar = (TileAvatar)world.func_175625_s(pos);
        ItemStack stackOnAvatar = avatar.func_70301_a(0);
        ItemStack stackOnPlayer = player.func_71045_bC();
        if (stackOnAvatar != null) {
            ItemStack copyStack = stackOnAvatar.func_77946_l();
            avatar.func_70299_a(0, null);
            if (!player.field_71071_by.func_70441_a(copyStack)) {
                player.func_71019_a(copyStack, true);
            }
            return true;
        }
        if (stackOnPlayer != null && stackOnPlayer.func_77973_b() instanceof IAvatarWieldable) {
            ItemStack copyStack = stackOnPlayer.func_77946_l();
            avatar.func_70299_a(0, copyStack);
            --stackOnPlayer.field_77994_a;
            return true;
        }
        return false;
    }

    public void func_180654_a(IBlockAccess w, BlockPos pos) {
        this.setBlockBounds(((EnumFacing)w.func_180495_p(pos).func_177229_b(BotaniaStateProps.CARDINALS)).func_176740_k());
    }

    public void setBlockBounds(EnumFacing.Axis horiz) {
        float f = 0.0625f;
        float w = f * 9.0f;
        float l = f * 6.0f;
        float ws = (1.0f - w) / 2.0f;
        float ls = (1.0f - l) / 2.0f;
        if (horiz == EnumFacing.Axis.Z) {
            this.func_149676_a(ws, 0.0f, ls, 1.0f - ws, 1.0f + f, 1.0f - ls);
        } else {
            this.func_149676_a(ls, 0.0f, ws, 1.0f - ls, 1.0f + f, 1.0f - ws);
        }
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)par1World.func_175625_s(pos);
        if (inv != null) {
            for (int j1 = 0; j1 < inv.func_70302_i_(); ++j1) {
                ItemStack itemstack = inv.func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77952_i()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(par1World, pos, state);
    }

    public void func_180633_a(World p_149689_1_, BlockPos pos, IBlockState state, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        p_149689_1_.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)p_149689_5_.func_174811_aO().func_176734_d()));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return LibRenderIDs.idAvatar;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileAvatar();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.avatar;
    }
}

