/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.TileCamo;

public abstract class BlockCamo
extends BlockModContainer<TileCamo> {
    static List<Integer> validRenderTypes = Arrays.asList(0, 31, 39);

    protected BlockCamo(Material par2Material) {
        super(par2Material);
    }

    public static boolean isValidBlock(Block block) {
        return block.func_149662_c() || BlockCamo.isValidRenderType(block.func_149645_b());
    }

    public static boolean isValidRenderType(int type) {
        return validRenderTypes.contains(type);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumFacing par6, float par7, float par8, float par9) {
        TileEntity tile = par1World.func_175625_s(pos);
        if (tile instanceof TileCamo) {
            TileCamo camo = (TileCamo)tile;
            ItemStack currentStack = par5EntityPlayer.func_71045_bC();
            if (currentStack == null) {
                currentStack = new ItemStack(Block.func_149684_b((String)"air"), 1, 0);
            }
            boolean doChange = true;
            Block block = null;
            if (currentStack.func_77973_b() != Item.func_150898_a((Block)Block.func_149684_b((String)"air"))) {
                if (Item.func_150891_b((Item)currentStack.func_77973_b()) == 0) {
                    doChange = false;
                } else {
                    block = Block.func_149634_a((Item)currentStack.func_77973_b());
                    if (block == null || !BlockCamo.isValidBlock(block) || block instanceof BlockCamo || block.func_149688_o() == Material.field_151579_a) {
                        doChange = false;
                    }
                }
            }
            if (doChange && currentStack.func_77973_b() != null) {
                int metadata = currentStack.func_77952_i();
                if (block instanceof BlockDirectional) {
                    switch (par6) {
                        case DOWN: 
                        case UP: {
                            break;
                        }
                        case NORTH: {
                            metadata = metadata & 0xC | 2;
                            break;
                        }
                        case SOUTH: {
                            metadata &= 0xC;
                            break;
                        }
                        case WEST: {
                            metadata = metadata & 0xC | 1;
                            break;
                        }
                        case EAST: {
                            metadata = metadata & 0xC | 3;
                        }
                    }
                }
                camo.camo = Block.func_149634_a((Item)currentStack.func_77973_b());
                camo.camoMeta = metadata;
                par1World.func_175689_h(pos);
                return true;
            }
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess par1World, BlockPos pos, int pass) {
        TileEntity tile = par1World.func_175625_s(pos);
        if (tile instanceof TileCamo) {
            TileCamo camo = (TileCamo)tile;
            Block block = camo.camo;
            if (block != null) {
                return block instanceof BlockCamo ? 0xFFFFFF : block.func_180662_a(par1World, pos, pass);
            }
        }
        return 0xFFFFFF;
    }
}

