/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.crafting.recipe.SpecialFloatingFlowerRecipe;
import vazkii.botania.common.integration.coloredlights.LightHelper;
import vazkii.botania.common.item.block.ItemBlockFloatingSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockFloatingSpecialFlower
extends BlockFloatingFlower
implements ISpecialFlower,
IWandable,
ILexiconable,
IWandHUD {
    public BlockFloatingSpecialFlower() {
        super("floatingSpecialFlower");
        GameRegistry.addRecipe((IRecipe)new SpecialFloatingFlowerRecipe());
        RecipeSorter.register((String)"botania:floatingSpecialFlower", SpecialFloatingFlowerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        this.func_180632_j(((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty((IUnlistedProperty)BotaniaStateProps.SUBTILE_ID, (Object)"daybloom").func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)ISLAND_TYPE, (Comparable)((Object)IFloatingFlower.IslandType.GRASS)));
    }

    @Override
    public BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{ISLAND_TYPE, BotaniaStateProps.COLOR}, new IUnlistedProperty[]{BotaniaStateProps.SUBTILE_ID});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = this.func_176221_a(state, world, pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileFloatingSpecialFlower) {
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BotaniaStateProps.SUBTILE_ID, (Object)((TileFloatingSpecialFlower)te).subTileName);
        }
        return state;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        int currentLight = ((TileSpecialFlower)world.func_175625_s(pos)).getLightValue();
        if (currentLight == -1) {
            currentLight = this.originalLight;
        }
        return LightHelper.getPackedColor((EnumDyeColor)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.COLOR), currentLight);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getComparatorInputOverride();
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getPowerLevel(side);
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.func_180656_a(world, pos, state, side);
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public void func_180655_c(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
    }

    @Override
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (String s : BotaniaAPI.subtilesForCreativeMenu) {
            par3List.add(ItemBlockSpecialFlower.ofType(new ItemStack(par1), s));
            if (!BotaniaAPI.miniFlowers.containsKey((Object)s)) continue;
            par3List.add(ItemBlockSpecialFlower.ofType(new ItemStack(par1), (String)BotaniaAPI.miniFlowers.get((Object)s)));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        String name = ((TileSpecialFlower)world.func_175625_s((BlockPos)pos)).subTileName;
        IBlockState state = world.func_180495_p(pos);
        return ItemBlockSpecialFlower.ofType(new ItemStack(state.func_177230_c()), name);
    }

    public void func_176208_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par6EntityPlayer) {
        if (!par6EntityPlayer.field_71075_bZ.field_75098_d) {
            this.func_176226_b(par1World, pos, state, 0);
            ((TileSpecialFlower)par1World.func_175625_s(pos)).onBlockHarvested(par1World, pos, state, par6EntityPlayer);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            String name = ((TileSpecialFlower)tile).subTileName;
            list.add(ItemBlockSpecialFlower.ofType(new ItemStack(state.func_177230_c()), name));
            ((TileSpecialFlower)tile).getDrops(list);
        }
        return list;
    }

    public boolean func_180648_a(World par1World, BlockPos pos, IBlockState state, int eventID, int value) {
        super.func_180648_a(par1World, pos, state, eventID, value);
        TileEntity tileentity = par1World.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(eventID, value) : false;
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onWanded(stack, player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, side, hitX, hitY, hitZ) || super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockAdded(world, pos, state);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpecialFlower)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    protected void register(String name) {
        GameRegistry.registerBlock((Block)this, ItemBlockFloatingSpecialFlower.class, (String)name);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileFloatingSpecialFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getEntry();
    }
}

