/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.item.block.ItemBlockMod;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockGhostRail
extends BlockRailBase
implements ILexiconable {
    private static final String TAG_FLOAT_TICKS = "Botania_FloatTicks";

    public BlockGhostRail() {
        super(true);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_149663_c("ghostRail");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.RAIL_DIRECTION, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH));
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.RAIL_DIRECTION});
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockRailBase.EnumRailDirection)state.func_177229_b(BotaniaStateProps.RAIL_DIRECTION)).func_177015_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BotaniaStateProps.RAIL_DIRECTION, (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)meta));
    }

    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockMod.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)event.entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
        BlockPos entPos = new BlockPos(event.entity);
        Block block = event.entity.field_70170_p.func_180495_p(entPos).func_177230_c();
        boolean air = block.isAir((IBlockAccess)event.entity.field_70170_p, entPos);
        int floatTicks = event.entity.getEntityData().func_74762_e(TAG_FLOAT_TICKS);
        if (block == this) {
            event.entity.getEntityData().func_74768_a(TAG_FLOAT_TICKS, 20);
        } else if (block instanceof BlockRailBase || block == ModBlocks.dreamwood) {
            event.entity.getEntityData().func_74768_a(TAG_FLOAT_TICKS, 0);
            if (floatTicks > 0) {
                event.entity.field_70170_p.func_175718_b(2003, entPos, 0);
            }
        }
        floatTicks = event.entity.getEntityData().func_74762_e(TAG_FLOAT_TICKS);
        if (floatTicks > 0) {
            Block blockBelow = event.entity.field_70170_p.func_180495_p(entPos.func_177977_b()).func_177230_c();
            boolean airBelow = blockBelow.isAir((IBlockAccess)event.entity.field_70170_p, entPos.func_177977_b());
            if (air && airBelow || !air && !airBelow) {
                event.entity.field_70145_X = true;
            }
            event.entity.field_70181_x = 0.2;
            event.entity.field_70159_w *= 1.4;
            event.entity.field_70179_y *= 1.4;
            event.entity.getEntityData().func_74768_a(TAG_FLOAT_TICKS, floatTicks - 1);
            event.entity.field_70170_p.func_175718_b(2000, entPos, 0);
        } else {
            event.entity.field_70145_X = false;
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.ghostRail;
    }

    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return BlockRailPowered.field_176568_b;
    }
}

