/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.TileIncensePlate;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockIncensePlate
extends BlockModContainer
implements ILexiconable {
    protected BlockIncensePlate() {
        super(Material.field_151575_d);
        this.func_149663_c("incensePlate");
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        this.setBlockBounds(EnumFacing.Axis.Z);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.SOUTH));
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 2 || meta > 5) {
            meta = 2;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing s, float xs, float ys, float zs) {
        TileIncensePlate plate = (TileIncensePlate)world.func_175625_s(pos);
        ItemStack stack = player.func_71045_bC();
        ItemStack plateStack = plate.func_70301_a(0);
        boolean did = false;
        if (world.field_72995_K) {
            return true;
        }
        if (plateStack == null && plate.func_94041_b(0, stack)) {
            plate.func_70299_a(0, stack.func_77946_l());
            --stack.field_77994_a;
            did = true;
        } else if (plateStack != null && !plate.burning) {
            if (stack != null && stack.func_77973_b() == Items.field_151033_d) {
                plate.ignite();
                stack.func_77972_a(1, (EntityLivingBase)player);
                did = true;
            } else {
                ItemStack addStack = plateStack.func_77946_l();
                if (!player.field_71071_by.func_70441_a(addStack)) {
                    player.func_71019_a(addStack, false);
                }
                plate.func_70299_a(0, null);
                did = true;
            }
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
        return did;
    }

    public void func_180633_a(World p_149689_1_, BlockPos pos, IBlockState state, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        p_149689_1_.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)p_149689_5_.func_174811_aO().func_176734_d()));
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        return ((TileIncensePlate)world.func_175625_s((BlockPos)pos)).comparatorOutput;
    }

    public void func_180654_a(IBlockAccess w, BlockPos pos) {
        this.setBlockBounds(((EnumFacing)w.func_180495_p(pos).func_177229_b(BotaniaStateProps.CARDINALS)).func_176740_k());
    }

    public void setBlockBounds(EnumFacing.Axis axis) {
        float f = 0.0625f;
        float w = 12.0f * f;
        float l = 4.0f * f;
        float xs = (1.0f - w) / 2.0f;
        float zs = (1.0f - l) / 2.0f;
        if (axis == EnumFacing.Axis.Z) {
            this.func_149676_a(xs, 0.0f, zs, 1.0f - xs, f, 1.0f - zs);
        } else {
            this.func_149676_a(zs, 0.0f, xs, 1.0f - zs, f, 1.0f - xs);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return 2;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileIncensePlate();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.incense;
    }
}

