/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lib.LibMisc;

public class BlockLightLauncher
extends BlockMod
implements ILexiconable {
    public BlockLightLauncher() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("lightLauncher");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.POWERED});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 8 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(meta == 8));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176205_b(IBlockAccess p_149655_1_, BlockPos pos) {
        return false;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED);
        if (power && !powered) {
            this.pickUpEntities(world, pos);
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void pickUpEntities(World world, BlockPos pos) {
        ArrayList<TileLightRelay> relays = new ArrayList<TileLightRelay>();
        for (EnumFacing dir : LibMisc.CARDINAL_DIRECTIONS) {
            TileLightRelay relay;
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (!(tile instanceof TileLightRelay) || (relay = (TileLightRelay)tile).getBinding() == null) continue;
            relays.add(relay);
        }
        if (!relays.isEmpty()) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
            List entities = world.func_72872_a(EntityLivingBase.class, aabb);
            entities.addAll(world.func_72872_a(EntityItem.class, aabb));
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    TileLightRelay relay = (TileLightRelay)relays.get(world.field_73012_v.nextInt(relays.size()));
                    relay.mountEntity(entity);
                }
            }
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.luminizerTransport;
    }
}

