/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public abstract class BlockModDoubleFlower
extends BlockDoublePlant
implements ILexiconable {
    private static final int COUNT = 8;
    final int offset;
    final boolean second;

    public BlockModDoubleFlower(boolean second) {
        this.second = second;
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.offset = second ? 8 : 0;
        this.func_149663_c("doubleFlower" + (second ? 2 : 1));
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
    }

    public abstract BlockState func_180661_e();

    public abstract int func_176201_c(IBlockState var1);

    public abstract IBlockState func_176203_a(int var1);

    public Block func_149663_c(String par1Str) {
        if (!par1Str.equals("doublePlant")) {
            GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)par1Str);
        }
        return super.func_149663_c(par1Str);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean fuckifiknow) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_180657_a(World p_149636_1_, EntityPlayer p_149636_2_, BlockPos pos, IBlockState state, TileEntity te) {
        if (p_149636_1_.field_72995_K || p_149636_2_.func_71045_bC() == null || p_149636_2_.func_71045_bC().func_77973_b() != Items.field_151097_aZ || state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER) {
            this.harvestBlockCopy(p_149636_1_, p_149636_2_, pos, state);
        }
    }

    public void harvestBlockCopy(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state) {
        player.func_71029_a(StatList.field_75934_C[BlockModDoubleFlower.func_149682_b((Block)this)]);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, worldIn.func_180495_p(pos), player) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack stack : items) {
                BlockModDoubleFlower.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (!player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    world.func_175698_g(pos.func_177977_b());
                }
            }
        } else if (player.field_71075_bZ.field_75098_d && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this && world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER) {
            ret.add(new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos.func_177977_b()))));
        }
        return ret;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public int func_180662_a(IBlockAccess blockAccess, BlockPos pos, int pass) {
        return 0xFFFFFF;
    }

    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
        for (int i = 0; i < 8; ++i) {
            p_149666_3_.add(new ItemStack(p_149666_1_, 1, i));
        }
    }

    public void func_180655_c(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        int hex = ((EnumDyeColor)state.func_177229_b(this.second ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1)).func_176768_e().field_76291_p;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (par5Random.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX(par1World, (double)pos.func_177958_n() + 0.3 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)par5Random.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, par5Random.nextFloat(), 5);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.flowers;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b((IProperty)field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER && (iblockstate = worldIn.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            PropertyEnum<EnumDyeColor> prop = this.second ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1;
            state = state.func_177226_a(prop, iblockstate.func_177229_b(prop));
        }
        return state.func_177226_a((IProperty)field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.SUNFLOWER).func_177226_a((IProperty)field_181084_N, (Comparable)EnumFacing.SOUTH);
    }
}

