/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.IPickupAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockModFlower
extends BlockFlower
implements ILexiconable,
IPickupAchievement,
IGrowable {
    public int originalLight;
    public static final String ALT_DIR = "alt";

    protected BlockModFlower() {
        this("flower");
    }

    protected BlockModFlower(String name) {
        this.func_149663_c(name);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.8f, 1.0f, 0.8f);
        this.func_149675_a(false);
        this.func_149647_a(this.registerInCreative() ? BotaniaCreativeTab.INSTANCE : null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY));
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{this.func_176494_l(), BotaniaStateProps.COLOR});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumDyeColor.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta)).func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY);
    }

    public BlockFlower.EnumFlowerColor func_176495_j() {
        return BlockFlower.EnumFlowerColor.RED;
    }

    public boolean registerInCreative() {
        return true;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 16; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    public Block func_149715_a(float p_149715_1_) {
        this.originalLight = (int)(p_149715_1_ * 15.0f);
        return super.func_149715_a(p_149715_1_);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_180655_c(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        int hex = ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176768_e().field_76291_p;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (par5Random.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX(par1World, (double)pos.func_177958_n() + 0.3 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)par5Random.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, par5Random.nextFloat(), 5);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.flowers;
    }

    @Override
    public Achievement getAchievementOnPickup(ItemStack stack, EntityPlayer player, EntityItem item) {
        return ModAchievements.flowerPickup;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean fuckifiknow) {
        return world.func_175623_d(pos.func_177984_a());
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(world, pos, state, false);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockModFlower.placeDoubleFlower(world, pos, (EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR), 3);
    }

    public static void placeDoubleFlower(World world, BlockPos pos, EnumDyeColor color, int flags) {
        Block flower = color.func_176765_a() >= 8 ? ModBlocks.doubleFlower2 : ModBlocks.doubleFlower1;
        world.func_180501_a(pos, flower.func_176223_P().func_177226_a(color.func_176765_a() >= 8 ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1, (Comparable)color).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), flags);
        world.func_180501_a(pos.func_177984_a(), flower.func_176223_P().func_177226_a(color.func_176765_a() >= 8 ? BotaniaStateProps.DOUBLEFLOWER_VARIANT_2 : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1, (Comparable)color).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), flags);
    }
}

