/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockPistonRelay
extends BlockMod
implements IWandable,
ILexiconable {
    public static Map<String, String> playerPositions = new HashMap<String, String>();
    public static Map<String, String> mappedPositions = new HashMap<String, String>();
    static List<String> removeThese = new ArrayList<String>();
    static List<String> checkedCoords = new ArrayList<String>();
    static Map<String, Integer> coordsToCheck = new HashMap<String, Integer>();

    public BlockPistonRelay() {
        super(Material.field_151572_C);
        this.func_149663_c("pistonRelay");
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        BlockPistonRelay.mapCoords(par1World.field_73011_w.func_177502_q(), pos, 2);
    }

    public static String getCoordsAsString(int world, BlockPos pos) {
        return world + ":" + pos.func_177958_n() + ":" + pos.func_177956_o() + ":" + pos.func_177952_p();
    }

    static void mapCoords(int world, BlockPos pos, int time) {
        String coords = BlockPistonRelay.getCoordsAsString(world, pos);
        coordsToCheck.put(coords, time);
    }

    static void decrCoords(String key) {
        int time = BlockPistonRelay.getTimeInCoords(key);
        if (time <= 0) {
            removeThese.add(key);
        } else {
            coordsToCheck.put(key, time - 1);
        }
    }

    static int getTimeInCoords(String key) {
        return coordsToCheck.get(key);
    }

    static Block getBlockAt(String key) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return Blocks.field_150350_a;
        }
        String[] tokens = key.split(":");
        int worldId = Integer.parseInt(tokens[0]);
        int x = Integer.parseInt(tokens[1]);
        int y = Integer.parseInt(tokens[2]);
        int z = Integer.parseInt(tokens[3]);
        WorldServer world = server.func_71218_a(worldId);
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    static IBlockState getStateAt(String key) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        String[] tokens = key.split(":");
        int worldId = Integer.parseInt(tokens[0]);
        int x = Integer.parseInt(tokens[1]);
        int y = Integer.parseInt(tokens[2]);
        int z = Integer.parseInt(tokens[3]);
        WorldServer world = server.func_71218_a(worldId);
        return world.func_180495_p(new BlockPos(x, y, z));
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        if (player == null) {
            return false;
        }
        if (!player.func_70093_af()) {
            playerPositions.put(player.func_70005_c_(), BlockPistonRelay.getCoordsAsString(world.field_73011_w.func_177502_q(), pos));
            world.func_72908_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "botania:ding", 0.5f, 1.0f);
        } else {
            BlockPistonRelay.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
            world.func_175698_g(pos);
            if (!world.field_72995_K) {
                world.func_175718_b(2001, pos, Block.func_149682_b((Block)this));
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        WorldData.get(event.world);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        WorldData.get(event.world).func_76185_a();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent event) {
        if (event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.END) {
            ArrayList<String> coordsToCheckCopy = new ArrayList<String>(coordsToCheck.keySet());
            for (String s : coordsToCheckCopy) {
                Block block;
                BlockPistonRelay.decrCoords(s);
                if (checkedCoords.contains(s) || (block = BlockPistonRelay.getBlockAt(s)) != Blocks.field_180384_M) continue;
                IBlockState state = BlockPistonRelay.getStateAt(s);
                boolean sticky = BlockPistonExtension.EnumPistonType.STICKY == state.func_177229_b((IProperty)BlockPistonMoving.field_176425_b);
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockPistonMoving.field_176426_a);
                MinecraftServer server = MinecraftServer.func_71276_C();
                if (server == null || BlockPistonRelay.getTimeInCoords(s) != 0) continue;
                String[] tokens = s.split(":");
                int worldId = Integer.parseInt(tokens[0]);
                int x = Integer.parseInt(tokens[1]);
                int y = Integer.parseInt(tokens[2]);
                int z = Integer.parseInt(tokens[3]);
                BlockPos pos = new BlockPos(x, y, z);
                WorldServer world = server.func_71218_a(worldId);
                if (world.func_175623_d(pos.func_177972_a(dir))) {
                    world.func_175656_a(pos.func_177972_a(dir), ModBlocks.pistonRelay.func_176223_P());
                } else if (!world.field_72995_K) {
                    ItemStack stack = new ItemStack(ModBlocks.pistonRelay);
                    world.func_72838_d((Entity)new EntityItem((World)world, (double)(x + dir.func_82601_c()), (double)(y + dir.func_96559_d()), (double)(z + dir.func_82599_e()), stack));
                }
                checkedCoords.add(s);
                String newPos = BlockPistonRelay.getCoordsAsString(world.field_73011_w.func_177502_q(), pos.func_177972_a(dir));
                if (!mappedPositions.containsKey(s)) continue;
                String pos2 = mappedPositions.get(s);
                String[] tokens2 = pos2.split(":");
                int worldId2 = Integer.parseInt(tokens2[0]);
                int x2 = Integer.parseInt(tokens2[1]);
                int y2 = Integer.parseInt(tokens2[2]);
                int z2 = Integer.parseInt(tokens2[3]);
                BlockPos pos22 = new BlockPos(x2, y2, z2);
                WorldServer world2 = server.func_71218_a(worldId2);
                IBlockState srcState = world2.func_180495_p(pos22);
                TileEntity tile = world2.func_175625_s(pos22);
                Material mat = srcState.func_177230_c().func_149688_o();
                if (!sticky && tile == null && mat.func_76227_m() == 0 && srcState.func_177230_c().func_176195_g((World)world2, pos22) != -1.0f && !srcState.func_177230_c().isAir((IBlockAccess)world2, pos22)) {
                    Material destMat = world2.func_180495_p(pos22.func_177972_a(dir)).func_177230_c().func_149688_o();
                    if (world2.func_175623_d(pos22.func_177972_a(dir)) || destMat.func_76222_j()) {
                        world2.func_175656_a(pos22, Blocks.field_150350_a.func_176223_P());
                        world2.func_180501_a(pos22.func_177972_a(dir), srcState, 3);
                        mappedPositions.put(s, BlockPistonRelay.getCoordsAsString(world2.field_73011_w.func_177502_q(), pos22.func_177972_a(dir)));
                    }
                }
                pos2 = mappedPositions.get(s);
                mappedPositions.remove(s);
                mappedPositions.put(newPos, pos2);
                this.save((World)world2);
            }
        }
        ArrayList<String> remove = new ArrayList<String>(removeThese);
        for (String s : remove) {
            coordsToCheck.remove(s);
            if (!checkedCoords.contains(s)) continue;
            checkedCoords.remove(s);
        }
        removeThese.clear();
    }

    public void save(World world) {
        WorldData data = WorldData.get(world);
        if (data != null) {
            data.func_76185_a();
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.pistonRelay;
    }

    public static class WorldData
    extends WorldSavedData {
        private static final String ID = "PistonRelayPairs";

        public WorldData(String id) {
            super(id);
        }

        public void func_76184_a(NBTTagCompound nbttagcompound) {
            mappedPositions.clear();
            Set tags = nbttagcompound.func_150296_c();
            for (String key : tags) {
                NBTBase tag = nbttagcompound.func_74781_a(key);
                if (!(tag instanceof NBTTagString)) continue;
                String value = ((NBTTagString)tag).func_150285_a_();
                mappedPositions.put(key, value);
            }
        }

        public void func_76187_b(NBTTagCompound nbttagcompound) {
            for (String s : mappedPositions.keySet()) {
                nbttagcompound.func_74778_a(s, mappedPositions.get(s));
            }
        }

        public static WorldData get(World world) {
            if (world.func_175693_T() == null) {
                return null;
            }
            WorldData data = (WorldData)world.func_175693_T().func_75742_a(WorldData.class, ID);
            if (data == null) {
                data = new WorldData(ID);
                data.func_76185_a();
                world.func_175693_T().func_75745_a(ID, (WorldSavedData)data);
            }
            return data;
        }
    }
}

