/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.integration.coloredlights.LightHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockSpecialFlower
extends BlockFlower
implements ITileEntityProvider,
ISpecialFlower,
IWandable,
ILexiconable,
IWandHUD {
    protected BlockSpecialFlower() {
        this.func_149663_c("specialFlower");
        this.func_149711_c(0.1f);
        this.func_149672_a(field_149779_h);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.8f, 1.0f, 0.8f);
        this.func_180632_j(((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty((IUnlistedProperty)BotaniaStateProps.SUBTILE_ID, (Object)"daybloom").func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY));
    }

    public BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.func_176494_l(), BotaniaStateProps.COLOR}, new IUnlistedProperty[]{BotaniaStateProps.SUBTILE_ID});
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSpecialFlower && ((TileSpecialFlower)te).getSubTile() != null) {
            Class<?> clazz = ((TileSpecialFlower)te).getSubTile().getClass();
            String id = BotaniaAPI.getSubTileStringMapping(clazz);
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BotaniaStateProps.SUBTILE_ID, (Object)id);
        }
        return (IExtendedBlockState)state;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 15) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta)).func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        int currentLight = ((TileSpecialFlower)world.func_175625_s(pos)).getLightValue();
        if (currentLight == -1) {
            currentLight = 0;
        }
        return LightHelper.getPackedColor((EnumDyeColor)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.COLOR), currentLight);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getComparatorInputOverride();
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getPowerLevel(side);
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.func_180656_a(world, pos, state, side);
    }

    public boolean func_149744_f() {
        return true;
    }

    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockSpecialFlower.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (String s : BotaniaAPI.subtilesForCreativeMenu) {
            par3List.add(ItemBlockSpecialFlower.ofType(s));
            if (!BotaniaAPI.miniFlowers.containsKey((Object)s)) continue;
            par3List.add(ItemBlockSpecialFlower.ofType((String)BotaniaAPI.miniFlowers.get((Object)s)));
        }
    }

    public BlockFlower.EnumFlowerColor func_176495_j() {
        return BlockFlower.EnumFlowerColor.RED;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        String name = ((TileSpecialFlower)world.func_175625_s((BlockPos)pos)).subTileName;
        return ItemBlockSpecialFlower.ofType(name);
    }

    protected boolean func_149854_a(Block block) {
        return super.func_149854_a(block) || block == ModBlocks.redStringRelay || block == Blocks.field_150391_bh;
    }

    public void func_176208_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par6EntityPlayer) {
        if (!par6EntityPlayer.field_71075_bZ.field_75098_d) {
            this.func_176226_b(par1World, pos, state, 0);
            ((TileSpecialFlower)par1World.func_175625_s(pos)).onBlockHarvested(par1World, pos, state, par6EntityPlayer);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            String name = ((TileSpecialFlower)tile).subTileName;
            list.add(ItemBlockSpecialFlower.ofType(name));
            ((TileSpecialFlower)tile).getDrops(list);
        }
        return list;
    }

    public boolean func_180648_a(World par1World, BlockPos pos, IBlockState state, int par5, int par6) {
        super.func_180648_a(par1World, pos, state, par5, par6);
        TileEntity tileentity = par1World.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileSpecialFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getEntry();
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onWanded(stack, player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockAdded(world, pos, state);
    }

    public int func_180644_h(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176768_e().field_76291_p;
    }

    public int func_180662_a(IBlockAccess world, BlockPos pos, int pass) {
        return this.func_180644_h(world.func_180495_p(pos));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumDyeColor oldColor;
        EnumDyeColor newColor;
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() == ModItems.dye && (newColor = EnumDyeColor.func_176764_b((int)stack.func_77952_i())) != (oldColor = (EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR))) {
            world.func_180501_a(pos, state.func_177226_a(BotaniaStateProps.COLOR, (Comparable)newColor), 3);
        }
        return ((TileSpecialFlower)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpecialFlower)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    public boolean addLandingEffects(WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
        double d0 = Math.min(0.2f + f / 15.0f, 10.0f);
        if (d0 > 2.5) {
            d0 = 2.5;
        }
        int i = (int)(150.0 * d0);
        worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150392_bi.func_176223_P())});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            int i = 4;
            EntityDiggingFX.Factory factory = new EntityDiggingFX.Factory();
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < i; ++k) {
                    for (int l = 0; l < i; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                        effectRenderer.func_78873_a(factory.func_178902_a(-1, world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150392_bi.func_176223_P())}));
                    }
                }
            }
            return true;
        }
        return false;
    }

    static {
        BotaniaAPI.subtilesForCreativeMenu.addAll(Arrays.asList("puredaisy", "manastar", "daybloom", "nightshade", "endoflame", "hydroangeas", "thermalily", "arcanerose", "munchdew", "entropinnyum", "kekimurus", "gourmaryllis", "narslimmus", "spectrolus", "rafflowsia", "dandelifeon", "jadedAmaranthus", "bellethorn", "dreadthorn", "heiseiDream", "tigerseye", "marimorphosis", "orechid", "orechidIgnem", "fallenKanade", "exoflame", "agricarnation", "hopperhock", "rannuncarpus", "tangleberrie", "jiyuulia", "hyacidus", "medumone", "pollidisiac", "clayconia", "loonium", "daffomill", "vinculotus", "spectranthemum", "bubbell", "solegnolia"));
    }
}

