/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.crafting.IInfusionStabiliser;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.integration.coloredlights.ColoredLightHelper;
import vazkii.botania.common.item.ItemGrassSeeds;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.crafting.IInfusionStabiliser", striprefs=true)
public class BlockFloatingFlower
extends BlockModContainer
implements ILexiconable,
IInfusionStabiliser {
    public static final PropertyEnum<IFloatingFlower.IslandType> ISLAND_TYPE = PropertyEnum.func_177709_a((String)"islandtype", IFloatingFlower.IslandType.class);

    public BlockFloatingFlower() {
        this("miniIsland");
    }

    public BlockFloatingFlower(String name) {
        super(Material.field_151578_c);
        this.func_149663_c(name);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149767_g);
        this.func_149715_a(1.0f);
        float f = 0.1f;
        this.func_149676_a(f, f, f, 1.0f - f, 1.0f - f, 1.0f - f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a(ISLAND_TYPE, (Comparable)((Object)IFloatingFlower.IslandType.GRASS)));
    }

    @Override
    public int func_149645_b() {
        return 2;
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.COLOR, ISLAND_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumDyeColor.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileFloatingFlower) {
            state = state.func_177226_a(ISLAND_TYPE, (Comparable)((Object)((TileFloatingFlower)te).getIslandType()));
        } else if (te instanceof TileFloatingSpecialFlower) {
            state = state.func_177226_a(ISLAND_TYPE, (Comparable)((Object)((TileFloatingSpecialFlower)te).getIslandType()));
        }
        return state;
    }

    public boolean addLandingEffects(WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
        double d0 = Math.min(0.2f + f / 15.0f, 10.0f);
        if (d0 > 2.5) {
            d0 = 2.5;
        }
        int i = (int)(150.0 * d0);
        worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            int i = 4;
            EntityDiggingFX.Factory factory = new EntityDiggingFX.Factory();
            for (int j = 0; j < i; ++j) {
                for (int k = 0; k < i; ++k) {
                    for (int l = 0; l < i; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                        effectRenderer.func_78873_a(factory.func_178902_a(-1, world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())}));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="easycoloredlights")
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return ColoredLightHelper.getPackedColor((EnumDyeColor)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.COLOR), this.originalLight);
    }

    @Override
    protected boolean shouldRegisterInNameSet() {
        return false;
    }

    @Override
    public Block func_149663_c(String par1Str) {
        this.register(par1Str);
        return super.func_149663_c(par1Str);
    }

    protected void register(String name) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)name);
    }

    public void func_180655_c(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        int hex = ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176768_e().field_76291_p;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (par5Random.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX(par1World, (double)pos.func_177958_n() + 0.3 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)par5Random.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, par5Random.nextFloat(), 5);
        }
    }

    public void func_149666_a(Item par1, CreativeTabs par2, List par3) {
        for (int i = 0; i < 16; ++i) {
            par3.add(new ItemStack(par1, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null) {
            IFloatingFlower.IslandType newType;
            IFloatingFlower flower = (IFloatingFlower)world.func_175625_s(pos);
            IFloatingFlower.IslandType type = null;
            if (stack.func_77973_b() == Items.field_151126_ay) {
                type = IFloatingFlower.IslandType.SNOW;
            } else if (stack.func_77973_b() == ModItems.grassSeeds && (newType = ItemGrassSeeds.getIslandType(stack)) != null) {
                type = newType;
            }
            if (type != null && type != flower.getIslandType()) {
                if (!world.field_72995_K) {
                    flower.setIslandType(type);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(world, pos);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileFloatingFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.shinyFlowers;
    }

    public boolean canStabaliseInfusion(World world, BlockPos pos) {
        return ConfigHandler.enableThaumcraftStablizers;
    }
}

