/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.crafting.IInfusionStabiliser;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.integration.coloredlights.ColoredLightHelper;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.crafting.IInfusionStabiliser", striprefs=true)
public class BlockModMushroom
extends BlockMushroom
implements IInfusionStabiliser,
IHornHarvestable,
ILexiconable {
    public int originalLight;

    public BlockModMushroom() {
        this.func_149663_c("mushroom");
        this.func_149715_a(0.2f);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.8f, 1.0f, 0.8f);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE));
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.COLOR});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumDyeColor.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public void func_180650_b(World p_149674_1_, BlockPos pos, IBlockState state, Random p_149674_5_) {
    }

    public boolean func_176196_c(World p_149718_1_, BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Block block = p_149718_1_.func_180495_p(pos.func_177977_b()).func_177230_c();
            return block == Blocks.field_150391_bh || block == Blocks.field_150346_d && p_149718_1_.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL || block.canSustainPlant((IBlockAccess)p_149718_1_, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 16; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    public Block func_149715_a(float p_149715_1_) {
        this.originalLight = (int)(p_149715_1_ * 15.0f);
        return super.func_149715_a(p_149715_1_);
    }

    @Optional.Method(modid="easycoloredlights")
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return ColoredLightHelper.getPackedColor((EnumDyeColor)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.COLOR), this.originalLight);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_180655_c(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        int hex = ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176768_e().field_76291_p;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (par5Random.nextDouble() < ConfigHandler.flowerParticleFrequency * 0.25) {
            Botania.proxy.sparkleFX(par1World, (double)pos.func_177958_n() + 0.3 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)par5Random.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)par5Random.nextFloat() * 0.5, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, par5Random.nextFloat(), 5);
        }
    }

    public boolean canStabaliseInfusion(World world, BlockPos pos) {
        return ConfigHandler.enableThaumcraftStablizers;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.mushrooms;
    }

    @Override
    public boolean canHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Override
    public boolean hasSpecialHornHarvest(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return false;
    }

    @Override
    public void harvestByHorn(World world, BlockPos pos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
    }
}

