/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PotatoVariant;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.item.block.ItemBlockTinyPotato;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockTinyPotato
extends BlockModContainer
implements ILexiconable {
    public BlockTinyPotato() {
        super(Material.field_151580_n);
        this.func_149711_c(0.25f);
        this.func_149663_c("tinyPotato");
        float f = 0.375f;
        this.func_149676_a(f, 0.0f, f, 1.0f - f, f, 1.0f - f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.SOUTH).func_177226_a(BotaniaStateProps.POTATO_VARIANT, (Comparable)((Object)PotatoVariant.DEFAULT)));
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS, BotaniaStateProps.POTATO_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)) {
            case NORTH: {
                return 0;
            }
            case WEST: {
                return 3;
            }
            case EAST: {
                return 1;
            }
        }
        return 2;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing side = null;
        switch (meta) {
            case 3: {
                side = EnumFacing.WEST;
                break;
            }
            case 0: {
                side = EnumFacing.NORTH;
                break;
            }
            case 1: {
                side = EnumFacing.EAST;
                break;
            }
            default: {
                side = EnumFacing.SOUTH;
            }
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)side);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (ClientProxy.dootDoot) {
            return state.func_177226_a(BotaniaStateProps.POTATO_VARIANT, (Comparable)((Object)PotatoVariant.HALLOWEEN));
        }
        if (world.func_175625_s(pos) instanceof TileTinyPotato && ((TileTinyPotato)world.func_175625_s((BlockPos)pos)).name.toLowerCase().equals("kyle hyde")) {
            return state.func_177226_a(BotaniaStateProps.POTATO_VARIANT, (Comparable)((Object)PotatoVariant.GRAYSCALE));
        }
        return state.func_177226_a(BotaniaStateProps.POTATO_VARIANT, (Comparable)((Object)PotatoVariant.DEFAULT));
    }

    @Override
    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockTinyPotato.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    @Override
    protected boolean shouldRegisterInNameSet() {
        return false;
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumFacing par6, float par7, float par8, float par9) {
        TileEntity tile = par1World.func_175625_s(pos);
        if (tile instanceof TileTinyPotato) {
            ((TileTinyPotato)tile).interact();
            par5EntityPlayer.func_71064_a((StatBase)ModAchievements.tinyPotatoPet, 1);
            par1World.func_175688_a(EnumParticleTypes.HEART, (double)pos.func_177958_n() + this.field_149759_B + Math.random() * (this.field_149755_E - this.field_149759_B), (double)pos.func_177956_o() + this.field_149756_F, (double)pos.func_177952_p() + this.field_149754_D + Math.random() * (this.field_149757_G - this.field_149754_D), 0.0, 0.0, 0.0, new int[0]);
        }
        return true;
    }

    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        par1World.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)par5EntityLiving.func_174811_aO().func_176734_d()));
        if (par6ItemStack.func_82837_s()) {
            ((TileTinyPotato)par1World.func_175625_s((BlockPos)pos)).name = par6ItemStack.func_82833_r();
        }
    }

    public void func_176208_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par6EntityPlayer) {
        if (!par6EntityPlayer.field_71075_bZ.field_75098_d) {
            this.func_176226_b(par1World, pos, state, 0);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this);
            String name = ((TileTinyPotato)tile).name;
            if (!name.isEmpty()) {
                stack.func_151001_c(name);
            }
            list.add(stack);
        }
        return list;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return 2;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileTinyPotato();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.tinyPotato;
    }
}

