/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.achievement.ICraftAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.item.block.ItemBlockPool;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockPool
extends BlockModContainer
implements IWandHUD,
IWandable,
ILexiconable,
ICraftAchievement {
    boolean lastFragile = false;

    public BlockPool() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("pool");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.POOL_VARIANT, (Comparable)((Object)PoolVariant.DEFAULT)));
        BotaniaAPI.blacklistBlockFromMagnet((Block)this, Short.MAX_VALUE);
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.POOL_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((PoolVariant)((Object)state.func_177229_b(BotaniaStateProps.POOL_VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > PoolVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.POOL_VARIANT, (Comparable)((Object)PoolVariant.values()[meta]));
    }

    @Override
    protected boolean shouldRegisterInNameSet() {
        return false;
    }

    @Override
    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockPool.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TilePool pool = (TilePool)par1World.func_175625_s(pos);
        this.lastFragile = pool.fragile;
        super.func_180663_b(par1World, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!this.lastFragile) {
            drops.add(new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state)));
        }
        return drops;
    }

    public void func_149666_a(Item par1, CreativeTabs par2, List par3) {
        par3.add(new ItemStack(par1, 1, 0));
        par3.add(new ItemStack(par1, 1, 2));
        par3.add(new ItemStack(par1, 1, 3));
        par3.add(new ItemStack(par1, 1, 1));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePool();
    }

    public void func_180634_a(World par1World, BlockPos pos, IBlockState state, Entity par5Entity) {
        TilePool tile;
        if (par5Entity instanceof EntityItem && (tile = (TilePool)par1World.func_175625_s(pos)).collideEntityItem((EntityItem)par5Entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(par1World, pos);
        }
    }

    public void func_180638_a(World p_149743_1_, BlockPos pos, IBlockState state, AxisAlignedBB p_149743_5_, List<AxisAlignedBB> p_149743_6_, Entity p_149743_7_) {
        float f = 0.0625f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
        super.func_180638_a(p_149743_1_, pos, state, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 0.5f, 1.0f);
        super.func_180638_a(p_149743_1_, pos, state, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, f);
        super.func_180638_a(p_149743_1_, pos, state, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        super.func_180638_a(p_149743_1_, pos, state, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 0.5f, 1.0f);
        super.func_180638_a(p_149743_1_, pos, state, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return 2;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World par1World, BlockPos pos) {
        TilePool pool = (TilePool)par1World.func_175625_s(pos);
        int val = (int)((double)pool.getCurrentMana() / (double)pool.manaCap * 15.0);
        if (pool.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TilePool)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TilePool)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return world.func_180495_p(pos).func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.FABULOUS ? LexiconData.rainbowRod : LexiconData.pool;
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        return ModAchievements.manaPoolPickup;
    }
}

