/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.SpreaderVariant;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.common.block.BlockModContainer;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockSpreader
extends BlockModContainer
implements IWandable,
IWandHUD,
ILexiconable,
IWireframeAABBProvider {
    Random random;

    public BlockSpreader() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("spreader");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.SPREADER_VARIANT, (Comparable)((Object)SpreaderVariant.MANA)));
        this.random = new Random();
    }

    public BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BotaniaStateProps.SPREADER_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((SpreaderVariant)((Object)state.func_177229_b(BotaniaStateProps.SPREADER_VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > SpreaderVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.SPREADER_VARIANT, (Comparable)((Object)SpreaderVariant.values()[meta]));
    }

    @Override
    protected boolean shouldRegisterInNameSet() {
        return false;
    }

    @Override
    public Block func_149663_c(String par1Str) {
        GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)par1Str);
        return super.func_149663_c(par1Str);
    }

    public void func_149666_a(Item par1, CreativeTabs par2, List par3) {
        for (int i = 0; i < 4; ++i) {
            par3.add(new ItemStack(par1, 1, i));
        }
    }

    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        EnumFacing orientation = BlockPistonBase.func_180695_a((World)par1World, (BlockPos)pos, (EntityLivingBase)par5EntityLivingBase);
        TileSpreader spreader = (TileSpreader)par1World.func_175625_s(pos);
        par1World.func_180501_a(pos, this.func_176203_a(par6ItemStack.func_77952_i()), 3);
        switch (orientation) {
            case DOWN: {
                spreader.rotationY = -90.0f;
                break;
            }
            case UP: {
                spreader.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                spreader.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                spreader.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            default: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    public int func_180651_a(IBlockState par1) {
        return this.func_176201_c(par1);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return 2;
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumFacing par6, float par7, float par8, float par9) {
        boolean wool;
        TileEntity tile = par1World.func_175625_s(pos);
        if (!(tile instanceof TileSpreader)) {
            return false;
        }
        TileSpreader spreader = (TileSpreader)tile;
        ItemStack lens = spreader.func_70301_a(0);
        ItemStack heldItem = par5EntityPlayer.func_71045_bC();
        boolean isHeldItemLens = heldItem != null && heldItem.func_77973_b() instanceof ILens;
        boolean bl = wool = heldItem != null && heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L);
        if (heldItem != null && heldItem.func_77973_b() == ModItems.twigWand) {
            return false;
        }
        if (lens == null && isHeldItemLens) {
            if (!par5EntityPlayer.field_71075_bZ.field_75098_d) {
                par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, null);
            }
            spreader.func_70299_a(0, heldItem.func_77946_l());
            spreader.func_70296_d();
        } else if (lens != null && !wool) {
            ItemStack add = lens.func_77946_l();
            if (!par5EntityPlayer.field_71071_by.func_70441_a(add)) {
                par5EntityPlayer.func_71019_a(add, false);
            }
            spreader.func_70299_a(0, null);
            spreader.func_70296_d();
        }
        if (wool && spreader.paddingColor == -1) {
            spreader.paddingColor = heldItem.func_77952_i();
            --heldItem.field_77994_a;
            if (heldItem.field_77994_a == 0) {
                par5EntityPlayer.field_71071_by.func_70299_a(par5EntityPlayer.field_71071_by.field_70461_c, null);
            }
        } else if (heldItem == null && spreader.paddingColor != -1 && lens == null) {
            ItemStack pad = new ItemStack(Blocks.field_150325_L, 1, spreader.paddingColor);
            if (!par5EntityPlayer.field_71071_by.func_70441_a(pad)) {
                par5EntityPlayer.func_71019_a(pad, false);
            }
            spreader.paddingColor = -1;
            spreader.func_70296_d();
        }
        return true;
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileEntity tile = par1World.func_175625_s(pos);
        if (!(tile instanceof TileSpreader)) {
            return;
        }
        TileSpreader inv = (TileSpreader)tile;
        if (inv != null) {
            for (int j1 = 0; j1 < inv.func_70302_i_() + 1; ++j1) {
                ItemStack itemstack;
                Object object = j1 >= inv.func_70302_i_() ? (inv.paddingColor == -1 ? null : new ItemStack(Blocks.field_150325_L, 1, inv.paddingColor)) : (itemstack = inv.func_70301_a(j1));
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77952_i()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(par1World, pos, state);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TileSpreader)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileSpreader();
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpreader)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        SpreaderVariant variant = (SpreaderVariant)((Object)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.SPREADER_VARIANT));
        return variant == SpreaderVariant.MANA ? LexiconData.spreader : (variant == SpreaderVariant.REDSTONE ? LexiconData.redstoneSpreader : LexiconData.dreamwoodSpreader);
    }

    @Override
    public AxisAlignedBB getWireframeAABB(World world, BlockPos pos) {
        float f = 0.0625f;
        return new AxisAlignedBB((double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f), (double)((float)pos.func_177952_p() + f), (double)((float)(pos.func_177958_n() + 1) - f), (double)((float)(pos.func_177956_o() + 1) - f), (double)((float)(pos.func_177952_p() + 1) - f));
    }
}

