/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileOrechid
extends SubTileFunctional {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    @Override
    public void onUpdate() {
        ItemStack stack;
        BlockPos coords;
        super.onUpdate();
        if (this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        int cost = this.getCost();
        if (!this.supertile.func_145831_w().field_72995_K && this.mana >= cost && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null && (stack = this.getOreToPut()) != null) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            int meta = stack.func_77952_i();
            this.supertile.func_145831_w().func_180501_a(coords, block.func_176203_a(meta), 3);
            if (ConfigHandler.blockBreakParticles) {
                this.supertile.func_145831_w().func_175718_b(2001, coords, Block.func_149682_b((Block)block) + (meta << 12));
            }
            this.supertile.func_145831_w().func_72908_a((double)this.supertile.func_174877_v().func_177958_n(), (double)this.supertile.func_174877_v().func_177956_o(), (double)this.supertile.func_174877_v().func_177952_p(), "botania:orechid", 2.0f, 1.0f);
            this.mana -= cost;
            this.sync();
        }
    }

    public ItemStack getOreToPut() {
        ArrayList<StringRandomItem> values = new ArrayList<StringRandomItem>();
        Map<String, Integer> map = this.getOreMap();
        for (String s : map.keySet()) {
            values.add(new StringRandomItem(map.get(s), s));
        }
        String ore = ((StringRandomItem)WeightedRandom.func_76271_a((Random)this.supertile.func_145831_w().field_73012_v, values)).s;
        List ores = OreDictionary.getOres((String)ore);
        for (ItemStack stack : ores) {
            Item item = stack.func_77973_b();
            String clname = item.getClass().getName();
            if (clname.startsWith("gregtech") || clname.startsWith("gregapi")) continue;
            return stack;
        }
        return this.getOreToPut();
    }

    public BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        Block source = this.getSourceBlock();
        for (int i = -5; i < 6; ++i) {
            for (int j = -3; j < 3; ++j) {
                for (int k = -5; k < 6; ++k) {
                    BlockPos pos = this.supertile.func_174877_v().func_177982_a(i, j, k);
                    Block block = this.supertile.func_145831_w().func_180495_p(pos).func_177230_c();
                    if (block == null || !block.isReplaceableOreGen(this.supertile.func_145831_w(), pos, (Predicate)BlockHelper.func_177642_a((Block)source))) continue;
                    possibleCoords.add(pos);
                }
            }
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.supertile.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public Map<String, Integer> getOreMap() {
        return BotaniaAPI.oreWeights;
    }

    public Block getSourceBlock() {
        return Blocks.field_150348_b;
    }

    public int getCost() {
        return Botania.gardenOfGlassLoaded ? 700 : 17500;
    }

    public int getDelay() {
        return Botania.gardenOfGlassLoaded ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 5);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.orechid;
    }

    private static class StringRandomItem
    extends WeightedRandom.Item {
        public String s;

        public StringRandomItem(int par1, String s) {
            super(par1);
            this.s = s;
        }
    }
}

