/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCell;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileDandelifeon
extends SubTileGenerating {
    private static final int RANGE = 12;
    private static final int SPEED = 10;
    private static final int MAX_GENERATIONS = 60;
    private static final int MANA_PER_GEN = 150;
    private static final int[][] ADJACENT_BLOCKS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.supertile.func_145831_w().field_72995_K && this.redstoneSignal > 0 && this.ticksExisted % 10 == 0) {
            this.runSimulation();
        }
    }

    void runSimulation() {
        int[][] table = this.getCellTable();
        ArrayList<int[]> changes = new ArrayList<int[]>();
        new ArrayList();
        boolean wipe = false;
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[0].length; ++j) {
                int gen = table[i][j];
                int adj = this.getAdjCells(table, i, j);
                int newVal = gen;
                if (adj < 2 || adj > 3) {
                    newVal = -1;
                } else if (adj == 3 && gen == -1) {
                    newVal = this.getSpawnCellGeneration(table, i, j);
                } else if (gen > -1) {
                    newVal = gen + 1;
                }
                int xdist = Math.abs(i - 12);
                int zdist = Math.abs(j - 12);
                int allowDist = 1;
                if (xdist <= allowDist && zdist <= allowDist && newVal > -1) {
                    gen = newVal;
                    int n = newVal = gen == 1 ? -1 : -2;
                }
                if (newVal == gen) continue;
                changes.add(new int[]{i, j, newVal, gen});
                if (newVal != -2) continue;
                wipe = true;
            }
        }
        BlockPos pos = this.supertile.func_174877_v();
        for (int[] change : changes) {
            BlockPos pos_ = pos.func_177982_a(-12 + change[0], 0, -12 + change[1]);
            int val = change[2];
            if (val != -2 && wipe) {
                val = -1;
            }
            int old = change[3];
            this.setBlockForGeneration(pos_, val, old);
        }
    }

    int[][] getCellTable() {
        int diam = 25;
        int[][] table = new int[diam][diam];
        BlockPos pos = this.supertile.func_174877_v();
        for (int i = 0; i < diam; ++i) {
            for (int j = 0; j < diam; ++j) {
                BlockPos pos_ = pos.func_177982_a(-12 + i, 0, -12 + j);
                table[i][j] = this.getCellGeneration(pos_);
            }
        }
        return table;
    }

    int getCellGeneration(BlockPos pos) {
        TileEntity tile = this.supertile.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileCell) {
            return ((TileCell)tile).isSameFlower(this.supertile) ? ((TileCell)tile).getGeneration() : 0;
        }
        return -1;
    }

    int getAdjCells(int[][] table, int x, int z) {
        int count = 0;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) < 0) continue;
            ++count;
        }
        return count;
    }

    int getSpawnCellGeneration(int[][] table, int x, int z) {
        int max = -1;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) <= max) continue;
            max = gen;
        }
        return max == -1 ? -1 : max + 1;
    }

    boolean isOffBounds(int[][] table, int x, int z) {
        return x < 0 || z < 0 || x >= table.length || z >= table[0].length;
    }

    void setBlockForGeneration(BlockPos pos, int gen, int prevGen) {
        World world = this.supertile.func_145831_w();
        Block blockAt = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (gen == -2) {
            int val = prevGen * 150;
            this.mana = Math.min(this.getMaxMana(), this.mana + val);
        } else if (blockAt == ModBlocks.cellBlock) {
            if (gen < 0 || gen > 60) {
                world.func_175698_g(pos);
            } else {
                ((TileCell)tile).setGeneration(this.supertile, gen);
            }
        } else if (gen >= 0 && blockAt.isAir((IBlockAccess)this.supertile.func_145831_w(), pos)) {
            world.func_175656_a(pos, ModBlocks.cellBlock.func_176223_P());
            tile = world.func_175625_s(pos);
            ((TileCell)tile).setGeneration(this.supertile, gen);
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 12);
    }

    @Override
    public int getMaxMana() {
        return 50000;
    }

    @Override
    public int getColor() {
        return 10226302;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.dandelifeon;
    }
}

