/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.signature.PassiveFlower;
import vazkii.botania.common.block.subtile.generating.SubTilePassiveGenerating;
import vazkii.botania.common.lexicon.LexiconData;

@PassiveFlower
public class SubTileDaybloom
extends SubTilePassiveGenerating {
    private static final String TAG_PRIME_POSITION_X = "primePositionX";
    private static final String TAG_PRIME_POSITION_Y = "primePositionY";
    private static final String TAG_PRIME_POSITION_Z = "primePositionZ";
    private static final String TAG_SAVED_POSITION = "savedPosition";
    BlockPos primePosition;
    boolean savedPosition;

    @Override
    public int getColor() {
        return 0xFFFF00;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!(!this.isPrime() || this.savedPosition && this.supertile.func_174877_v().equals((Object)this.primePosition))) {
            this.supertile.func_145831_w().func_175698_g(this.supertile.func_174877_v());
        }
    }

    public void setPrimusPosition() {
        this.primePosition = this.supertile.func_174877_v();
        this.savedPosition = true;
    }

    @Override
    public List<ItemStack> getDrops(List<ItemStack> list) {
        if (this.isPrime()) {
            list.clear();
        }
        return super.getDrops(list);
    }

    @Override
    public boolean canGeneratePassively() {
        boolean rain = this.supertile.func_145831_w().func_180494_b(this.supertile.func_174877_v()).func_76744_g() > 0 && (this.supertile.func_145831_w().func_72896_J() || this.supertile.func_145831_w().func_72911_I());
        return this.supertile.func_145831_w().func_72935_r() && !rain && this.supertile.func_145831_w().func_175710_j(this.supertile.func_174877_v().func_177984_a());
    }

    @Override
    public int getDelayBetweenPassiveGeneration() {
        return this.isPrime() ? 10 : 12;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        if (this.isPrime()) {
            cmp.func_74768_a(TAG_PRIME_POSITION_X, this.primePosition.func_177958_n());
            cmp.func_74768_a(TAG_PRIME_POSITION_Y, this.primePosition.func_177956_o());
            cmp.func_74768_a(TAG_PRIME_POSITION_Z, this.primePosition.func_177952_p());
            cmp.func_74757_a(TAG_SAVED_POSITION, this.savedPosition);
        }
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        if (this.isPrime()) {
            this.primePosition = new BlockPos(cmp.func_74762_e(TAG_PRIME_POSITION_X), cmp.func_74762_e(TAG_PRIME_POSITION_Y), cmp.func_74762_e(TAG_PRIME_POSITION_Z));
            this.savedPosition = cmp.func_74767_n(TAG_SAVED_POSITION);
        }
    }

    @Override
    public boolean shouldSyncPassiveGeneration() {
        return true;
    }

    @Override
    public boolean isPassiveFlower() {
        return !this.isPrime();
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.daybloom;
    }

    public boolean isPrime() {
        return false;
    }

    public static class Prime
    extends SubTileDaybloom {
        @Override
        public boolean isPrime() {
            return true;
        }

        @Override
        public LexiconEntry getEntry() {
            return LexiconData.primusLoci;
        }
    }
}

