/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.recipe.ElvenPortalUpdateEvent;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.LivingWoodVariant;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.lexicon.LexiconData;

public class TileAlfPortal
extends TileMod
implements ITickable {
    private static final BlockPos[] LIVINGWOOD_POSITIONS = new BlockPos[]{new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-2, 1, 0), new BlockPos(2, 1, 0), new BlockPos(-2, 3, 0), new BlockPos(2, 3, 0), new BlockPos(-1, 4, 0), new BlockPos(1, 4, 0)};
    private static final BlockPos[] GLIMMERING_LIVINGWOOD_POSITIONS = new BlockPos[]{new BlockPos(-2, 2, 0), new BlockPos(2, 2, 0), new BlockPos(0, 4, 0)};
    private static final BlockPos[] PYLON_POSITIONS = new BlockPos[]{new BlockPos(-3, 1, 3), new BlockPos(3, 1, 3)};
    private static final BlockPos[] POOL_POSITIONS = new BlockPos[]{new BlockPos(-3, 0, 3), new BlockPos(3, 0, 3)};
    private static final BlockPos[] AIR_POSITIONS = new BlockPos[]{new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(1, 1, 0), new BlockPos(-1, 2, 0), new BlockPos(0, 2, 0), new BlockPos(1, 2, 0), new BlockPos(-1, 3, 0), new BlockPos(0, 3, 0), new BlockPos(1, 3, 0)};
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    private static final String TAG_PORTAL_FLAG = "_elvenPortal";
    List<ItemStack> stacksIn = new ArrayList<ItemStack>();
    public int ticksOpen = 0;
    int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean hasUnloadedParts = false;
    private static final Function<BlockPos, BlockPos> CONVERTER_X_Z = new Function<BlockPos, BlockPos>(){

        public BlockPos apply(BlockPos input) {
            return new BlockPos(input.func_177952_p(), input.func_177956_o(), input.func_177958_n());
        }
    };
    private static final Function<double[], double[]> CONVERTER_X_Z_FP = new Function<double[], double[]>(){

        public double[] apply(double[] input) {
            return new double[]{input[2], input[1], input[0]};
        }
    };
    private static final Function<BlockPos, BlockPos> CONVERTER_Z_SWAP = new Function<BlockPos, BlockPos>(){

        public BlockPos apply(BlockPos input) {
            return new BlockPos(input.func_177958_n(), input.func_177956_o(), -input.func_177952_p());
        }
    };

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos l : LIVINGWOOD_POSITIONS) {
            mb.addComponent(l.func_177984_a(), ModBlocks.livingwood.func_176223_P());
        }
        for (BlockPos g : GLIMMERING_LIVINGWOOD_POSITIONS) {
            mb.addComponent(g.func_177984_a(), ModBlocks.livingwood.func_176223_P().func_177226_a(BotaniaStateProps.LIVINGWOOD_VARIANT, (Comparable)((Object)LivingWoodVariant.GLIMMERING)));
        }
        for (BlockPos p : PYLON_POSITIONS) {
            mb.addComponent(new BlockPos(-p.func_177958_n(), p.func_177956_o() + 1, -p.func_177952_p()), ModBlocks.pylon.func_176223_P().func_177226_a(BotaniaStateProps.PYLON_VARIANT, (Comparable)((Object)PylonVariant.NATURA)));
        }
        for (BlockPos p : POOL_POSITIONS) {
            mb.addComponent(new BlockPos(-p.func_177958_n(), p.func_177956_o() + 1, -p.func_177952_p()), ModBlocks.pool.func_176223_P());
        }
        mb.addComponent(new BlockPos(0, 1, 0), ModBlocks.alfPortal.func_176223_P());
        mb.setRenderOffset(new BlockPos(0, -1, 0));
        return mb.makeSet();
    }

    public void func_73660_a() {
        IBlockState iBlockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (iBlockState.func_177230_c() != ModBlocks.alfPortal || iBlockState.func_177229_b(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF) {
            this.ticksOpen = 0;
            return;
        }
        AlfPortalState state = (AlfPortalState)((Object)iBlockState.func_177229_b(BotaniaStateProps.ALFPORTAL_STATE));
        AlfPortalState newState = this.getValidState();
        if (!this.hasUnloadedParts) {
            ++this.ticksOpen;
            AxisAlignedBB aabb = this.getPortalAABB();
            boolean open = this.ticksOpen > 60;
            ElvenPortalUpdateEvent event = new ElvenPortalUpdateEvent(this, aabb, open, this.stacksIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (this.ticksOpen > 60) {
                ++this.ticksSinceLastItem;
                if (ConfigHandler.elfPortalParticlesEnabled) {
                    this.blockParticle(state);
                }
                List items = this.field_145850_b.func_72872_a(EntityItem.class, aabb);
                if (!this.field_145850_b.field_72995_K) {
                    for (EntityItem item : items) {
                        ItemStack stack;
                        if (item.field_70128_L || (stack = item.func_92059_d()) == null || stack.func_77973_b() instanceof IElvenItem && ((IElvenItem)stack.func_77973_b()).isElvenItem(stack) || item.getEntityData().func_74764_b(TAG_PORTAL_FLAG)) continue;
                        item.func_70106_y();
                        this.addItem(stack);
                        this.ticksSinceLastItem = 0;
                    }
                }
                if (this.ticksSinceLastItem >= 4 && !this.field_145850_b.field_72995_K) {
                    this.resolveRecipes();
                }
            }
        } else {
            this.closeNow = false;
        }
        if (this.closeNow) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), ModBlocks.alfPortal.func_176223_P(), 3);
            for (int i = 0; i < 36; ++i) {
                this.blockParticle(state);
            }
            this.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    this.blockParticle(state);
                }
            }
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)), 3);
        }
        this.hasUnloadedParts = false;
    }

    private void blockParticle(AlfPortalState state) {
        int i = this.field_145850_b.field_73012_v.nextInt(AIR_POSITIONS.length);
        double[] pos = new double[]{(float)AIR_POSITIONS[i].func_177958_n() + 0.5f, (float)AIR_POSITIONS[i].func_177956_o() + 0.5f, (float)AIR_POSITIONS[i].func_177952_p() + 0.5f};
        if (state == AlfPortalState.ON_X) {
            pos = (double[])CONVERTER_X_Z_FP.apply((Object)pos);
        }
        float motionMul = 0.2f;
        Botania.proxy.wispFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + pos[0], (double)this.func_174877_v().func_177956_o() + pos[1], (double)this.func_174877_v().func_177952_p() + pos[2], (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25), (float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() - 0.5) * motionMul, (float)(Math.random() - 0.5) * motionMul, (float)(Math.random() - 0.5) * motionMul);
    }

    public boolean onWanded() {
        AlfPortalState newState;
        AlfPortalState state = (AlfPortalState)((Object)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.ALFPORTAL_STATE));
        if (state == AlfPortalState.OFF && (newState = this.getValidState()) != AlfPortalState.OFF) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)), 3);
            return true;
        }
        return false;
    }

    AxisAlignedBB getPortalAABB() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 1, 0), this.field_174879_c.func_177982_a(2, 4, 1));
        if (this.func_145832_p() == 2) {
            aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, -1), this.field_174879_c.func_177982_a(1, 4, 2));
        }
        return aabb;
    }

    void addItem(ItemStack stack) {
        int size = stack.field_77994_a;
        stack.field_77994_a = 1;
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.func_77946_l());
        }
    }

    void resolveRecipes() {
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            if (stack != null && stack.func_77973_b() instanceof ILexicon) {
                ((ILexicon)stack.func_77973_b()).unlockKnowledge(stack, BotaniaAPI.elvenKnowledge);
                ItemLexicon.setForcedPage(stack, LexiconData.elvenMessage.getUnlocalizedName());
                this.spawnItem(stack);
                this.stacksIn.remove(i);
                return;
            }
            ++i;
        }
        for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
            if (!recipe.matches(this.stacksIn, false)) continue;
            recipe.matches(this.stacksIn, true);
            this.spawnItem(recipe.getOutput().func_77946_l());
            break;
        }
    }

    void spawnItem(ItemStack stack) {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
        item.getEntityData().func_74757_a(TAG_PORTAL_FLAG, true);
        this.field_145850_b.func_72838_d((Entity)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound cmp) {
        super.func_145841_b(cmp);
        cmp.func_74768_a(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            NBTTagCompound stackcmp = new NBTTagCompound();
            stack.func_77955_b(stackcmp);
            cmp.func_74782_a(TAG_STACK + i, (NBTBase)stackcmp);
            ++i;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound cmp) {
        super.func_145839_a(cmp);
        int count = cmp.func_74762_e(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound stackcmp = cmp.func_74775_l(TAG_STACK + i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.func_74768_a(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.ticksOpen = cmp.func_74762_e(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.func_74762_e(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private AlfPortalState getValidState() {
        if (this.checkConverter(null)) {
            return AlfPortalState.ON_Z;
        }
        if (this.checkConverter(CONVERTER_X_Z)) {
            return AlfPortalState.ON_X;
        }
        return AlfPortalState.OFF;
    }

    private boolean checkConverter(Function<BlockPos, BlockPos> baseConverter) {
        return this.checkMultipleConverters(baseConverter) || this.checkMultipleConverters(CONVERTER_Z_SWAP, baseConverter);
    }

    private boolean checkMultipleConverters(Function<BlockPos, BlockPos> ... converters) {
        if (!this.check2DArray(AIR_POSITIONS, Blocks.field_150350_a.func_176223_P(), true, converters)) {
            return false;
        }
        if (!this.check2DArray(LIVINGWOOD_POSITIONS, ModBlocks.livingwood.func_176223_P().func_177226_a(BotaniaStateProps.LIVINGWOOD_VARIANT, (Comparable)((Object)LivingWoodVariant.DEFAULT)), false, converters)) {
            return false;
        }
        if (!this.check2DArray(GLIMMERING_LIVINGWOOD_POSITIONS, ModBlocks.livingwood.func_176223_P().func_177226_a(BotaniaStateProps.LIVINGWOOD_VARIANT, (Comparable)((Object)LivingWoodVariant.GLIMMERING)), false, converters)) {
            return false;
        }
        if (!this.check2DArray(PYLON_POSITIONS, ModBlocks.pylon.func_176223_P().func_177226_a(BotaniaStateProps.PYLON_VARIANT, (Comparable)((Object)PylonVariant.NATURA)), false, converters)) {
            return false;
        }
        if (!this.check2DArray(POOL_POSITIONS, ModBlocks.pool.func_176223_P(), true, converters)) {
            return false;
        }
        this.lightPylons(converters);
        return true;
    }

    private void lightPylons(Function<BlockPos, BlockPos> ... converters) {
        if (this.ticksOpen < 50) {
            return;
        }
        int cost = this.ticksOpen == 50 ? 75000 : 2;
        for (BlockPos pos : PYLON_POSITIONS) {
            for (Function<BlockPos, BlockPos> f : converters) {
                if (f == null) continue;
                pos = (BlockPos)f.apply((Object)pos);
            }
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos));
            if (tile instanceof TilePylon) {
                TilePylon pylon = (TilePylon)tile;
                pylon.activated = true;
                pylon.centerPos = this.func_174877_v();
            }
            if (!((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos).func_177977_b())) instanceof TilePool)) continue;
            TilePool pool = (TilePool)tile;
            if (pool.getCurrentMana() < cost) {
                this.closeNow = true;
                continue;
            }
            if (this.field_145850_b.field_72995_K) continue;
            pool.recieveMana(-cost);
        }
    }

    private boolean check2DArray(BlockPos[] positions, IBlockState state, boolean onlyCheckBlock, Function<BlockPos, BlockPos> ... converters) {
        for (BlockPos pos : positions) {
            for (Function<BlockPos, BlockPos> f : converters) {
                if (f == null) continue;
                pos = (BlockPos)f.apply((Object)pos);
            }
            if (this.checkPosition(pos, state, onlyCheckBlock)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPosition(BlockPos pos, IBlockState state, boolean onlyCheckBlock) {
        BlockPos pos_ = this.func_174877_v().func_177971_a((Vec3i)pos);
        if (!this.field_145850_b.func_175667_e(pos_)) {
            this.hasUnloadedParts = true;
            return true;
        }
        IBlockState stateat = this.field_145850_b.func_180495_p(pos_);
        Block blockat = stateat.func_177230_c();
        if (state.func_177230_c() == Blocks.field_150350_a ? blockat.isAir((IBlockAccess)this.field_145850_b, pos_) : blockat == state.func_177230_c()) {
            return onlyCheckBlock || stateat == state;
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

