/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ITickable;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.lib.LibObfuscation;

public class TileSpawnerClaw
extends TileMod
implements IManaReceiver,
ITickable {
    private static final String TAG_MANA = "mana";
    int mana = 0;
    private static final Method isActivated = ReflectionHelper.findMethod(MobSpawnerBaseLogic.class, null, (String[])LibObfuscation.IS_ACTIVATED, (Class[])new Class[0]);
    private static final Field spawnDelay = ReflectionHelper.findField(MobSpawnerBaseLogic.class, (String[])LibObfuscation.SPAWN_DELAY);
    private static final Field mobRotation = ReflectionHelper.findField(MobSpawnerBaseLogic.class, (String[])LibObfuscation.MOB_ROTATION);
    private static final Field prevMobRotation = ReflectionHelper.findField(MobSpawnerBaseLogic.class, (String[])LibObfuscation.PREV_MOB_ROTATION);
    private static final Method spawnNewEntity = ReflectionHelper.findMethod(MobSpawnerBaseLogic.class, null, (String[])LibObfuscation.SPAWN_NEW_ENTITY, (Class[])new Class[]{Entity.class, Boolean.TYPE});
    private static final Method getEntityNameToSpawn = ReflectionHelper.findMethod(MobSpawnerBaseLogic.class, null, (String[])LibObfuscation.GET_ENTITY_TO_SPAWN, (Class[])new Class[0]);

    public void func_73660_a() {
        TileEntity tileBelow = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (this.mana >= 5 && tileBelow instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileBelow;
            MobSpawnerBaseLogic logic = spawner.func_145881_a();
            try {
                if (!((Boolean)isActivated.invoke((Object)logic, new Object[0])).booleanValue()) {
                    int delay;
                    if (!this.field_145850_b.field_72995_K) {
                        this.mana -= 6;
                    }
                    if (logic.func_98271_a().field_72995_K) {
                        delay = spawnDelay.getInt(logic);
                        if (delay > 0) {
                            spawnDelay.setInt(logic, delay - 1);
                        }
                        if (Math.random() > 0.5) {
                            Botania.proxy.wispFX(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.func_174877_v().func_177956_o() - 0.3 + Math.random() * 0.25, (double)this.func_174877_v().func_177952_p() + Math.random(), 0.6f - (float)Math.random() * 0.3f, 0.1f, 0.6f - (float)Math.random() * 0.3f, (float)Math.random() / 3.0f, -0.025f - 0.005f * (float)Math.random(), 2.0f);
                        }
                        prevMobRotation.set(logic, logic.func_177222_d());
                        mobRotation.set(logic, (logic.func_177222_d() + (double)(1000.0f / ((float)spawnDelay.getInt(logic) + 200.0f))) % 360.0);
                    } else if (spawnDelay.getInt(logic) == -1) {
                        this.resetTimer(logic);
                    }
                    delay = spawnDelay.getInt(logic);
                    if (delay > 0) {
                        spawnDelay.setInt(logic, delay - 1);
                        return;
                    }
                    boolean flag = false;
                    int spawnCount = (Integer)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)logic, (String[])LibObfuscation.SPAWN_COUNT);
                    int spawnRange = (Integer)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)logic, (String[])LibObfuscation.SPAWN_RANGE);
                    int maxNearbyEntities = (Integer)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)logic, (String[])LibObfuscation.MAX_NEARBY_ENTITIES);
                    for (int i = 0; i < spawnCount; ++i) {
                        Entity entity = EntityList.func_75620_a((String)((String)getEntityNameToSpawn.invoke((Object)logic, new Object[0])), (World)logic.func_98271_a());
                        if (entity == null) {
                            return;
                        }
                        int j = logic.func_98271_a().func_72872_a(entity.getClass(), new AxisAlignedBB(logic.func_177221_b(), logic.func_177221_b().func_177982_a(1, 1, 1)).func_72314_b((double)(spawnRange * 2), 4.0, (double)(spawnRange * 2))).size();
                        if (j >= maxNearbyEntities) {
                            this.resetTimer(logic);
                            return;
                        }
                        double d2 = (double)logic.func_177221_b().func_177958_n() + (logic.func_98271_a().field_73012_v.nextDouble() - logic.func_98271_a().field_73012_v.nextDouble()) * (double)spawnRange;
                        double d3 = logic.func_177221_b().func_177956_o() + logic.func_98271_a().field_73012_v.nextInt(3) - 1;
                        double d4 = (double)logic.func_177221_b().func_177952_p() + (logic.func_98271_a().field_73012_v.nextDouble() - logic.func_98271_a().field_73012_v.nextDouble()) * (double)spawnRange;
                        EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                        entity.func_70012_b(d2, d3, d4, logic.func_98271_a().field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entityliving != null && !entityliving.func_70601_bi()) continue;
                        if (!this.field_145850_b.field_72995_K) {
                            spawnNewEntity.invoke((Object)logic, entity, true);
                        }
                        logic.func_98271_a().func_175718_b(2004, logic.func_177221_b(), 0);
                        if (entityliving != null) {
                            entityliving.func_70656_aK();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.resetTimer(logic);
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void resetTimer(MobSpawnerBaseLogic logic) throws IllegalAccessException {
        int maxSpawnDelay = (Integer)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)logic, (String[])LibObfuscation.MAX_SPAWN_DELAY);
        int minSpawnDelay = (Integer)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)logic, (String[])LibObfuscation.MIN_SPAWN_DELAY);
        List potentialEntitySpawns = (List)ReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)logic, (String[])LibObfuscation.POTENTIAL_ENTITY_SPAWNS);
        if (maxSpawnDelay <= minSpawnDelay) {
            spawnDelay.set(logic, minSpawnDelay);
        } else {
            int i = maxSpawnDelay - minSpawnDelay;
            spawnDelay.set(logic, minSpawnDelay + logic.func_98271_a().field_73012_v.nextInt(i));
        }
        if (potentialEntitySpawns != null && potentialEntitySpawns.size() > 0) {
            logic.func_98277_a((MobSpawnerBaseLogic.WeightedRandomMinecart)WeightedRandom.func_76271_a((Random)logic.func_98271_a().field_73012_v, (Collection)potentialEntitySpawns));
        }
        logic.func_98267_a(1);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 160;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(160, this.mana + mana);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }
}

