/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileMod;

@Optional.Interface(iface="cofh.api.energy.IEnergyConnection", modid="CoFHAPI|energy")
public class TileRFGenerator
extends TileMod
implements IManaReceiver,
IEnergyConnection,
ITickable {
    private static final int CONVERSION_RATE = 10;
    private static final int MAX_MANA = 12800;
    private static final String TAG_MANA = "mana";
    int mana = 0;
    private EnumMap<EnumFacing, IEnergyReceiver> receiverCache;
    private boolean deadCache;

    @Optional.Method(modid="CoFHAPI|energy")
    public void func_145829_t() {
        super.func_145829_t();
        this.deadCache = true;
        this.receiverCache = null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Loader.isModLoaded((String)"CoFHAPI|energy")) {
            if (this.deadCache) {
                this.reCache();
            }
            int transfer = Math.min(this.mana, 1600);
            this.mana -= transfer;
            this.mana += this.transmitEnergy(transfer);
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    protected final int transmitEnergy(int energy) {
        if (this.receiverCache != null) {
            for (Map.Entry<EnumFacing, IEnergyReceiver> e : this.receiverCache.entrySet()) {
                IEnergyReceiver tile = e.getValue();
                if (tile == null) continue;
                if (tile.receiveEnergy(e.getKey(), energy, true) > 0) {
                    energy -= tile.receiveEnergy(e.getKey(), energy, false);
                }
                if (energy > 0) continue;
                return 0;
            }
        }
        return energy;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    private void reCache() {
        if (this.deadCache) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.onNeighborTileChange(this.field_174879_c.func_177972_a(dir));
            }
            this.deadCache = false;
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public void onNeighborTileChange(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (pos.func_177958_n() < this.func_174877_v().func_177958_n()) {
            this.addCache(tile, EnumFacing.EAST);
        } else if (pos.func_177958_n() > this.func_174877_v().func_177958_n()) {
            this.addCache(tile, EnumFacing.WEST);
        } else if (pos.func_177952_p() < this.func_174877_v().func_177952_p()) {
            this.addCache(tile, EnumFacing.SOUTH);
        } else if (pos.func_177952_p() > this.func_174877_v().func_177952_p()) {
            this.addCache(tile, EnumFacing.NORTH);
        } else if (pos.func_177956_o() < this.func_174877_v().func_177956_o()) {
            this.addCache(tile, EnumFacing.UP);
        } else if (pos.func_177956_o() > this.func_174877_v().func_177956_o()) {
            this.addCache(tile, EnumFacing.DOWN);
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    private void addCache(TileEntity tile, EnumFacing side) {
        if (this.receiverCache != null) {
            this.receiverCache.remove(side);
        }
        if (tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canConnectEnergy(side)) {
            if (this.receiverCache == null) {
                this.receiverCache = new EnumMap(EnumFacing.class);
            }
            this.receiverCache.put(side, (IEnergyReceiver)tile);
        }
    }

    @Override
    public int getCurrentMana() {
        return this.mana / 10;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 12800;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(12800, this.mana + mana * 10);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

