/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockPos;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.item.IFlowerlessBiome;
import vazkii.botania.api.item.IFlowerlessWorld;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.subtile.generating.SubTileDaybloom;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;

public class BiomeDecorationHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        if ((event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT) && event.type == DecorateBiomeEvent.Decorate.EventType.FLOWERS) {
            int y;
            int z;
            int x;
            int i;
            boolean flowers = true;
            if (event.world.field_73011_w instanceof IFlowerlessWorld) {
                flowers = ((IFlowerlessWorld)event.world.field_73011_w).generateFlowers(event.world);
            } else if (event.world.func_180494_b(event.pos) instanceof IFlowerlessBiome) {
                flowers = ((IFlowerlessBiome)event.world.func_180494_b(event.pos)).canGenerateFlowers(event.world, event.pos.func_177958_n(), event.pos.func_177952_p());
            }
            if (!flowers) {
                return;
            }
            int dist = Math.min(8, Math.max(1, ConfigHandler.flowerPatchSize));
            for (i = 0; i < ConfigHandler.flowerQuantity; ++i) {
                if (event.rand.nextInt(ConfigHandler.flowerPatchChance) != 0) continue;
                x = event.pos.func_177958_n() + event.rand.nextInt(16) + 8;
                z = event.pos.func_177952_p() + event.rand.nextInt(16) + 8;
                y = event.world.func_175672_r(event.pos).func_177956_o();
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)event.rand.nextInt(16));
                boolean primus = event.rand.nextInt(380) == 0;
                for (int j = 0; j < ConfigHandler.flowerDensity * ConfigHandler.flowerPatchChance; ++j) {
                    int z1;
                    int y1;
                    int x1 = x + event.rand.nextInt(dist * 2) - dist;
                    BlockPos pos2 = new BlockPos(x1, y1 = y + event.rand.nextInt(4) - event.rand.nextInt(4), z1 = z + event.rand.nextInt(dist * 2) - dist);
                    if (!event.world.func_175623_d(pos2) || event.world.field_73011_w.func_177495_o() && y1 >= 127 || !ModBlocks.flower.func_176196_c(event.world, pos2)) continue;
                    if (primus) {
                        event.world.func_180501_a(pos2, ModBlocks.specialFlower.func_176223_P(), 2);
                        TileSpecialFlower flower = (TileSpecialFlower)event.world.func_175625_s(pos2);
                        flower.setSubTile(event.rand.nextBoolean() ? "nightshadePrime" : "daybloomPrime");
                        SubTileDaybloom subtile = (SubTileDaybloom)flower.getSubTile();
                        subtile.setPrimusPosition();
                        continue;
                    }
                    event.world.func_180501_a(pos2, ModBlocks.flower.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)color), 2);
                    if (!(event.rand.nextDouble() < ConfigHandler.flowerTallChance) || !((BlockModFlower)ModBlocks.flower).func_176473_a(event.world, pos2, event.world.func_180495_p(pos2), false)) continue;
                    BlockModFlower.placeDoubleFlower(event.world, pos2, color, 0);
                }
            }
            for (i = 0; i < ConfigHandler.mushroomQuantity; ++i) {
                x = event.pos.func_177958_n() + event.rand.nextInt(16) + 8;
                z = event.pos.func_177952_p() + event.rand.nextInt(16) + 8;
                y = event.rand.nextInt(26) + 4;
                BlockPos pos3 = new BlockPos(x, y, z);
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)event.rand.nextInt(16));
                if (!event.world.func_175623_d(pos3) || !ModBlocks.mushroom.func_176196_c(event.world, pos3)) continue;
                event.world.func_180501_a(pos3, ModBlocks.mushroom.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)color), 2);
            }
        }
    }
}

