/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.item.IGrassHornExcempt;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemMod;

public class ItemGrassHorn
extends ItemMod {
    private static final int SUBTYPES = 3;

    public ItemGrassHorn() {
        this.func_77625_d(1);
        this.func_77655_b("grassHorn");
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 3; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return this.getUnlocalizedNameLazy(par1ItemStack) + par1ItemStack.func_77952_i();
    }

    String getUnlocalizedNameLazy(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack);
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int time) {
        if (time != this.func_77626_a(stack) && time % 5 == 0) {
            ItemGrassHorn.breakGrass(player.field_70170_p, stack, stack.func_77952_i(), new BlockPos((Entity)player));
        }
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, "note.bassattack", 1.0f, 0.001f);
        }
    }

    public static void breakGrass(World world, ItemStack stack, int stackDmg, BlockPos srcPos) {
        IHornHarvestable.EnumHornType type = IHornHarvestable.EnumHornType.getTypeForMeta(stackDmg);
        Random rand = new Random(srcPos.hashCode());
        int range = 12 - stackDmg * 3;
        int rangeY = 3 + stackDmg * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (int i = -range; i < range + 1; ++i) {
            for (int j = -range; j < range + 1; ++j) {
                for (int k = -rangeY; k < rangeY + 1; ++k) {
                    BlockPos pos = srcPos.func_177982_a(i, k, j);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof IHornHarvestable ? ((IHornHarvestable)block).canHornHarvest(world, pos, stack, type) : stackDmg == 0 && block instanceof BlockBush && !(block instanceof ISpecialFlower) && (!(block instanceof IGrassHornExcempt) || ((IGrassHornExcempt)block).canUproot(world, pos)) || stackDmg == 1 && block.isLeaves((IBlockAccess)world, pos) || stackDmg == 2 && block == Blocks.field_150431_aC)) continue;
                    coords.add(pos);
                }
            }
        }
        Collections.shuffle(coords, rand);
        int count = Math.min(coords.size(), 32 + stackDmg * 16);
        for (int i = 0; i < count; ++i) {
            BlockPos currCoords = (BlockPos)coords.get(i);
            ArrayList items = new ArrayList();
            IBlockState state = world.func_180495_p(currCoords);
            Block block = state.func_177230_c();
            items.addAll(block.getDrops((IBlockAccess)world, currCoords, state, 0));
            if (block instanceof IHornHarvestable && ((IHornHarvestable)block).hasSpecialHornHarvest(world, currCoords, stack, type)) {
                ((IHornHarvestable)block).harvestByHorn(world, currCoords, stack, type);
                continue;
            }
            if (world.field_72995_K) continue;
            world.func_175698_g(currCoords);
            if (ConfigHandler.blockBreakParticles) {
                world.func_175718_b(2001, currCoords, Block.func_176210_f((IBlockState)state));
            }
            for (ItemStack stack_ : items) {
                world.func_72838_d((Entity)new EntityItem(world, (double)currCoords.func_177958_n() + 0.5, (double)currCoords.func_177956_o() + 0.5, (double)currCoords.func_177952_p() + 0.5, stack_));
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }
}

