/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.item.ItemMod;

public class ItemGrassSeeds
extends ItemMod {
    private static Map<Integer, List<BlockSwapper>> blockSwappers = new HashMap<Integer, List<BlockSwapper>>();
    private static final IFloatingFlower.IslandType[] ISLAND_TYPES = new IFloatingFlower.IslandType[]{IFloatingFlower.IslandType.GRASS, IFloatingFlower.IslandType.PODZOL, IFloatingFlower.IslandType.MYCEL, IFloatingFlower.IslandType.DRY, IFloatingFlower.IslandType.GOLDEN, IFloatingFlower.IslandType.VIVID, IFloatingFlower.IslandType.SCORCHED, IFloatingFlower.IslandType.INFUSED, IFloatingFlower.IslandType.MUTATED};
    private static final int SUBTYPES = 9;

    public ItemGrassSeeds() {
        this.func_77655_b("grassSeeds");
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_150895_a(Item par1, CreativeTabs par2, List par3) {
        for (int i = 0; i < 9; ++i) {
            par3.add(new ItemStack(par1, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + stack.func_77952_i();
    }

    public boolean func_180614_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, BlockPos pos, EnumFacing side, float par8, float par9, float par10) {
        IBlockState state = par3World.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150346_d && state.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT || state.func_177230_c() == Blocks.field_150349_c && par1ItemStack.func_77952_i() != 0) {
            int meta = par1ItemStack.func_77952_i();
            BlockSwapper swapper = ItemGrassSeeds.addBlockSwapper(par3World, pos, meta);
            par3World.func_180501_a(pos, swapper.stateToSet, 3);
            for (int i = 0; i < 50; ++i) {
                double x = (Math.random() - 0.5) * 3.0;
                double y = Math.random() - 0.5 + 1.0;
                double z = (Math.random() - 0.5) * 3.0;
                float r = 0.0f;
                float g = 0.4f;
                float b = 0.0f;
                switch (meta) {
                    case 1: {
                        r = 0.5f;
                        g = 0.37f;
                        b = 0.0f;
                        break;
                    }
                    case 2: {
                        r = 0.27f;
                        g = 0.0f;
                        b = 0.33f;
                        break;
                    }
                    case 3: {
                        r = 0.4f;
                        g = 0.5f;
                        b = 0.05f;
                        break;
                    }
                    case 4: {
                        r = 0.75f;
                        g = 0.7f;
                        b = 0.0f;
                        break;
                    }
                    case 5: {
                        r = 0.0f;
                        g = 0.5f;
                        b = 0.1f;
                        break;
                    }
                    case 6: {
                        r = 0.75f;
                        g = 0.0f;
                        b = 0.0f;
                        break;
                    }
                    case 7: {
                        r = 0.0f;
                        g = 0.55f;
                        b = 0.55f;
                        break;
                    }
                    case 8: {
                        r = 0.4f;
                        g = 0.1f;
                        b = 0.4f;
                    }
                }
                float velMul = 0.025f;
                Botania.proxy.wispFX(par3World, (double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + 0.5 + y, (double)pos.func_177952_p() + 0.5 + z, r, g, b, (float)Math.random() * 0.15f + 0.15f, (float)(-x) * velMul, (float)(-y) * velMul, (float)(-z) * velMul);
            }
            --par1ItemStack.field_77994_a;
        }
        return true;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.field_73011_w.func_177502_q())) {
            List<BlockSwapper> swappers = blockSwappers.get(dim);
            ArrayList<BlockSwapper> swappersSafe = new ArrayList<BlockSwapper>(swappers);
            for (BlockSwapper s : swappersSafe) {
                s.tick(swappers);
            }
        }
    }

    private static BlockSwapper addBlockSwapper(World world, BlockPos pos, int meta) {
        BlockSwapper swapper = ItemGrassSeeds.swapperFromMeta(world, pos, meta);
        int dim = world.field_73011_w.func_177502_q();
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new ArrayList());
        }
        blockSwappers.get(dim).add(swapper);
        return swapper;
    }

    private static BlockSwapper swapperFromMeta(World world, BlockPos pos, int meta) {
        switch (meta) {
            case 1: {
                return new BlockSwapper(world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
            }
            case 2: {
                return new BlockSwapper(world, pos, Blocks.field_150391_bh.func_176223_P());
            }
            case 3: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.DRY)));
            }
            case 4: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.GOLDEN)));
            }
            case 5: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.VIVID)));
            }
            case 6: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.SCORCHED)));
            }
            case 7: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.INFUSED)));
            }
            case 8: {
                return new BlockSwapper(world, pos, ModBlocks.altGrass.func_176223_P().func_177226_a(BotaniaStateProps.ALTGRASS_VARIANT, (Comparable)((Object)AltGrassVariant.MUTATED)));
            }
        }
        return new BlockSwapper(world, pos, Blocks.field_150349_c.func_176223_P());
    }

    public static IFloatingFlower.IslandType getIslandType(ItemStack stack) {
        return ISLAND_TYPES[Math.min(stack.func_77952_i(), ISLAND_TYPES.length - 1)];
    }

    private static class BlockSwapper {
        final World world;
        final Random rand;
        final IBlockState stateToSet;
        BlockPos startCoords;
        int ticksExisted = 0;

        BlockSwapper(World world, BlockPos coords, IBlockState state) {
            this.world = world;
            this.stateToSet = state;
            this.rand = new Random(coords.hashCode());
            this.startCoords = coords;
        }

        void tick(List<BlockSwapper> list) {
            ++this.ticksExisted;
            int range = 3;
            for (int i = -range; i < range + 1; ++i) {
                for (int j = -range; j < range + 1; ++j) {
                    BlockPos pos = this.startCoords.func_177982_a(i, 0, j);
                    IBlockState state = this.world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (state != this.stateToSet || this.ticksExisted % 20 != 0) continue;
                    ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
                    for (int k = -1; k < 2; ++k) {
                        for (int l = -1; l < 2; ++l) {
                            BlockPos pos1 = pos.func_177982_a(k, 0, l);
                            IBlockState state1 = this.world.func_180495_p(pos1);
                            if ((state1.func_177230_c() != Blocks.field_150346_d || state1.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT) && state1.func_177230_c() != Blocks.field_150349_c) continue;
                            validCoords.add(pos1);
                        }
                    }
                    if (validCoords.isEmpty() || this.world.field_72995_K) continue;
                    BlockPos coords = (BlockPos)validCoords.get(this.rand.nextInt(validCoords.size()));
                    this.world.func_180501_a(coords, this.stateToSet, 3);
                }
            }
            if (this.ticksExisted >= 80) {
                list.remove(this);
            }
        }
    }
}

