/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILaputaImmobile;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ItemMod;

public class ItemLaputaShard
extends ItemMod
implements ILensEffect,
ITinyPlanetExcempt {
    private static final String TAG_BLOCK = "_block";
    private static final String TAG_META = "_meta";
    private static final String TAG_TILE = "_tile";
    private static final String TAG_X = "_x";
    private static final String TAG_Y = "_y";
    private static final String TAG_Y_START = "_yStart";
    private static final String TAG_Z = "_z";
    private static final String TAG_POINTY = "_pointy";
    private static final String TAG_HEIGHTSCALE = "_heightscale";
    private static final String TAG_ITERATION_I = "iterationI";
    private static final String TAG_ITERATION_J = "iterationJ";
    private static final String TAG_ITERATION_K = "iterationK";
    private static final int BASE_RANGE = 14;
    private static final int BASE_OFFSET = 42;

    public ItemLaputaShard() {
        this.func_77655_b("laputaShard");
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        super.func_150895_a(item, tab, list);
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack(item, 1, (i + 1) * 5 - 1));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        list.add(String.format(StatCollector.func_74838_a((String)"botaniamisc.shardLevel"), StatCollector.func_74838_a((String)("botania.roman" + (stack.func_77952_i() + 1)))));
    }

    public boolean func_180614_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, BlockPos pos, EnumFacing side, float par8, float par9, float par10) {
        if (pos.func_177956_o() < 160 && !par3World.field_73011_w.func_177500_n()) {
            par3World.func_72980_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "botania:laputaStart", 1.0f + par3World.field_73012_v.nextFloat(), par3World.field_73012_v.nextFloat() * 0.7f + 1.3f, false);
            this.spawnBurstFirst(par3World, pos, par1ItemStack);
            --par1ItemStack.field_77994_a;
            if (par1ItemStack.func_77952_i() == 19) {
                par2EntityPlayer.func_71064_a((StatBase)ModAchievements.l20ShardUse, 1);
            }
        }
        return true;
    }

    public void spawnBurstFirst(World world, BlockPos pos, ItemStack lens) {
        int range = 14 + lens.func_77952_i();
        boolean pointy = world.field_73012_v.nextDouble() < 0.25;
        double heightscale = (world.field_73012_v.nextDouble() + 0.5) * (14.0 / (double)range);
        this.spawnBurst(world, pos, lens, pointy, heightscale);
    }

    public void spawnBurst(World world, BlockPos pos, ItemStack lens) {
        boolean pointy = ItemNBTHelper.getBoolean(lens, TAG_POINTY, false);
        double heightscale = ItemNBTHelper.getDouble(lens, TAG_HEIGHTSCALE, 1.0);
        this.spawnBurst(world, pos, lens, pointy, heightscale);
    }

    public void spawnBurst(World world, BlockPos pos, ItemStack lens, boolean pointy, double heightscale) {
        int range = 14 + lens.func_77952_i();
        int i = ItemNBTHelper.getInt(lens, TAG_ITERATION_I, 0);
        int j = ItemNBTHelper.getInt(lens, TAG_ITERATION_J, 35);
        int k = ItemNBTHelper.getInt(lens, TAG_ITERATION_K, 0);
        if (j <= -28) {
            j = 35;
        }
        if (k >= range * 2 + 1) {
            k = 0;
        }
        if (!world.field_72995_K) {
            while (i < range * 2 + 1) {
                while (j > -28) {
                    while (k < range * 2 + 1) {
                        Block block;
                        BlockPos pos_ = pos.func_177982_a(-range + i, -14 + j, -range + k);
                        if (!(!this.inRange(pos_, pos, range, heightscale, pointy) || (block = world.func_180495_p(pos_).func_177230_c()).isAir((IBlockAccess)world, pos_) || block.func_176200_f(world, pos_) || block instanceof BlockFalling || block instanceof ILaputaImmobile && !((ILaputaImmobile)block).canMove(world, pos_) || block.func_176195_g(world, pos_) == -1.0f)) {
                            int id = Block.func_149682_b((Block)block);
                            IBlockState state = world.func_180495_p(pos_);
                            TileEntity tile = world.func_175625_s(pos_);
                            if (tile != null) {
                                TileEntity newTile = block.createTileEntity(world, state);
                                world.func_175690_a(pos_, newTile);
                            }
                            world.func_175698_g(pos_);
                            world.func_175718_b(2001, pos_, Block.func_176210_f((IBlockState)state));
                            ItemStack copyLens = new ItemStack((Item)this, 1, lens.func_77952_i());
                            ItemNBTHelper.setInt(copyLens, TAG_BLOCK, id);
                            ItemNBTHelper.setInt(copyLens, TAG_META, block.func_176201_c(state));
                            NBTTagCompound cmp = new NBTTagCompound();
                            if (tile != null) {
                                tile.func_145841_b(cmp);
                            }
                            ItemNBTHelper.setCompound(copyLens, TAG_TILE, cmp);
                            ItemNBTHelper.setInt(copyLens, TAG_X, pos.func_177958_n());
                            ItemNBTHelper.setInt(copyLens, TAG_Y, pos.func_177956_o());
                            ItemNBTHelper.setInt(copyLens, TAG_Y_START, pos_.func_177956_o());
                            ItemNBTHelper.setInt(copyLens, TAG_Z, pos.func_177952_p());
                            ItemNBTHelper.setBoolean(copyLens, TAG_POINTY, pointy);
                            ItemNBTHelper.setDouble(copyLens, TAG_HEIGHTSCALE, heightscale);
                            ItemNBTHelper.setInt(copyLens, TAG_ITERATION_I, i);
                            ItemNBTHelper.setInt(copyLens, TAG_ITERATION_J, j);
                            ItemNBTHelper.setInt(copyLens, TAG_ITERATION_K, k);
                            EntityManaBurst burst = this.getBurst(world, pos_, copyLens);
                            world.func_72838_d((Entity)burst);
                            return;
                        }
                        ++k;
                    }
                    k = 0;
                    --j;
                }
                j = 35;
                ++i;
            }
        }
    }

    private boolean inRange(BlockPos pos, BlockPos srcPos, int range, double heightscale, boolean pointy) {
        if (pos.func_177956_o() >= srcPos.func_177956_o()) {
            return vazkii.botania.common.core.helper.MathHelper.pointDistanceSpace(pos.func_177958_n(), 0.0, pos.func_177952_p(), srcPos.func_177958_n(), 0.0, srcPos.func_177952_p()) < (float)range;
        }
        if (!pointy) {
            return vazkii.botania.common.core.helper.MathHelper.pointDistanceSpace(pos.func_177958_n(), (double)pos.func_177956_o() / heightscale, pos.func_177952_p(), srcPos.func_177958_n(), (double)srcPos.func_177956_o() / heightscale, srcPos.func_177952_p()) < (float)range;
        }
        return (double)vazkii.botania.common.core.helper.MathHelper.pointDistanceSpace(pos.func_177958_n(), 0.0, pos.func_177952_p(), srcPos.func_177958_n(), 0.0, srcPos.func_177952_p()) < (double)range - (double)(srcPos.func_177956_o() - pos.func_177956_o()) / heightscale;
    }

    public EntityManaBurst getBurst(World world, BlockPos pos, ItemStack stack) {
        EntityManaBurst burst = new EntityManaBurst(world);
        burst.field_70165_t = (double)pos.func_177958_n() + 0.5;
        burst.field_70163_u = (double)pos.func_177956_o() + 0.5;
        burst.field_70161_v = (double)pos.func_177952_p() + 0.5;
        burst.setColor(60159);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(0);
        burst.setManaLossPerTick(0.0f);
        burst.setGravity(0.0f);
        burst.setMotion(0.0, 0.5, 0.0);
        burst.setSourceLens(stack);
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
    }

    @Override
    public boolean collideBurst(IManaBurst burst, MovingObjectPosition pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        return false;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        double speed = 0.35;
        int targetDistance = 42;
        EntityThrowable entity = (EntityThrowable)burst;
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70159_w = 0.0;
            entity.field_70181_x = speed;
            entity.field_70179_y = 0.0;
            int spawnTicks = 2;
            int placeTicks = MathHelper.func_76128_c((double)((double)targetDistance / speed));
            ItemStack lens = burst.getSourceLens();
            if (burst.getTicksExisted() == 2) {
                int x = ItemNBTHelper.getInt(lens, TAG_X, 0);
                int y = ItemNBTHelper.getInt(lens, TAG_Y, -1);
                int z = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                if (y != -1) {
                    this.spawnBurst(entity.field_70170_p, new BlockPos(x, y, z), lens);
                }
            } else if (burst.getTicksExisted() == placeTicks) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)entity.field_70165_t);
                BlockPos pos = new BlockPos(x, y = ItemNBTHelper.getInt(lens, TAG_Y_START, -1) + targetDistance, z = MathHelper.func_76128_c((double)entity.field_70161_v));
                if (entity.field_70170_p.func_175623_d(pos)) {
                    int id = ItemNBTHelper.getInt(lens, TAG_BLOCK, 0);
                    Block block = Block.func_149729_e((int)id);
                    int meta = ItemNBTHelper.getInt(lens, TAG_META, 0);
                    TileEntity tile = null;
                    NBTTagCompound tilecmp = ItemNBTHelper.getCompound(lens, TAG_TILE, false);
                    if (tilecmp.func_74764_b("id")) {
                        tile = TileEntity.func_145827_c((NBTTagCompound)tilecmp);
                    }
                    entity.field_70170_p.func_180501_a(pos, block.func_176203_a(meta), 3);
                    entity.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)block.func_176203_a(meta)));
                    if (tile != null) {
                        tile.func_174878_a(pos);
                        entity.field_70170_p.func_175690_a(pos, tile);
                    }
                }
                entity.func_70106_y();
            }
        }
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        ItemStack lens = burst.getSourceLens();
        int id = ItemNBTHelper.getInt(lens, TAG_BLOCK, 0);
        Block b = Block.func_149729_e((int)id);
        int meta = ItemNBTHelper.getInt(lens, TAG_META, 0);
        entity.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y, new int[]{Block.func_176210_f((IBlockState)b.func_176203_a(meta))});
        return true;
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return false;
    }
}

