/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemManaMirror
extends ItemMod
implements IManaItem,
ICoordBoundItem,
IManaTooltipDisplay {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";
    private static final String TAG_DIM = "dim";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror() {
        this.func_77625_d(1);
        this.func_77656_e(1000);
        this.func_77655_b("manaMirror");
        this.setNoRepair();
    }

    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        float mana = this.getMana(par1ItemStack);
        return par2 == 1 ? Color.HSBtoRGB(0.528f, mana / 1000000.0f, 1.0f) : 0xFFFFFF;
    }

    public int getDamage(ItemStack stack) {
        float mana = this.getMana(stack);
        return 1000 - (int)(mana / 1000000.0f * 1000.0f);
    }

    public boolean func_77662_d() {
        return true;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par2World.field_72995_K) {
            return;
        }
        IManaPool pool = this.getManaPool(par1ItemStack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                this.setMana(par1ItemStack, 0);
            } else {
                pool.recieveMana(this.getManaBacklog(par1ItemStack));
                this.setManaBacklog(par1ItemStack, 0);
                this.setMana(par1ItemStack, pool.getCurrentMana());
            }
        }
    }

    public boolean func_180614_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, BlockPos pos, EnumFacing side, float par8, float par9, float par10) {
        TileEntity tile;
        if (par2EntityPlayer.func_70093_af() && !par3World.field_72995_K && (tile = par3World.func_175625_s(pos)) != null && tile instanceof IManaPool) {
            this.bindPool(par1ItemStack, tile);
            par3World.func_72956_a((Entity)par2EntityPlayer, "botania:ding", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
    }

    public int getManaBacklog(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    public void setManaBacklog(ItemStack stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 1000000;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        this.setMana(stack, this.getMana(stack) + mana);
        this.setManaBacklog(stack, this.getManaBacklog(stack) + mana);
    }

    public void bindPool(ItemStack stack, TileEntity pool) {
        ItemNBTHelper.setInt(stack, TAG_POS_X, pool == null ? 0 : pool.func_174877_v().func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_POS_Y, pool == null ? -1 : pool.func_174877_v().func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_POS_Z, pool == null ? 0 : pool.func_174877_v().func_177952_p());
        ItemNBTHelper.setInt(stack, TAG_DIM, pool == null ? 0 : pool.func_145831_w().field_73011_w.func_177502_q());
    }

    public BlockPos getPoolCoords(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_POS_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_POS_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_POS_Z, 0);
        return new BlockPos(x, y, z);
    }

    public int getDimension(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_DIM, 0);
    }

    public IManaPool getManaPool(ItemStack stack) {
        TileEntity tile;
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return fallbackPool;
        }
        BlockPos coords = this.getPoolCoords(stack);
        if (coords.func_177956_o() == -1) {
            return null;
        }
        int dim = this.getDimension(stack);
        WorldServer world = null;
        for (WorldServer w : server.field_71305_c) {
            if (w.field_73011_w.func_177502_q() != dim) continue;
            world = w;
            break;
        }
        if (world != null && (tile = world.func_175625_s(coords)) != null && tile instanceof IManaPool) {
            return (IManaPool)tile;
        }
        return null;
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        IManaPool pool = this.getManaPool(stack);
        return pool == null || pool instanceof DummyPool ? null : this.getPoolCoords(stack);
    }

    @Override
    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getMaxMana(stack);
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void recieveMana(int mana) {
        }

        @Override
        public boolean canRecieveManaFromBursts() {
            return false;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }
    }
}

