/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemIcePendant
extends ItemBauble
implements IBaubleRender {
    public static Map<String, List<IceRemover>> playerIceBlocks = new HashMap<String, List<IceRemover>>();

    public ItemIcePendant() {
        super("icePendant");
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        super.onWornTick(stack, entity);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_70170_p.field_72995_K) {
                this.tickIceRemovers(player);
            }
            if (!(player.func_70093_af() || player.func_70055_a(Material.field_151586_h) || player.field_70170_p.field_72995_K)) {
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int y = MathHelper.func_76128_c((double)(player.field_70163_u - (double)(!player.func_70090_H() ? 1 : 0)));
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                int range = 3;
                for (int i = -range; i < range + 1; ++i) {
                    for (int j = -range; j < range + 1; ++j) {
                        int x1 = x + i;
                        int z1 = z + j;
                        this.addIceBlock(player, new BlockPos(x1, y, z1));
                    }
                }
            }
        }
    }

    private void addIceBlock(EntityPlayer player, BlockPos coords) {
        String user = player.func_70005_c_();
        if (!playerIceBlocks.containsKey(user)) {
            playerIceBlocks.put(user, new ArrayList());
        }
        List<IceRemover> ice = playerIceBlocks.get(user);
        if (player.field_70170_p.func_180495_p(coords).func_177230_c() == Blocks.field_150355_j && (Integer)player.field_70170_p.func_180495_p(coords).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            player.field_70170_p.func_175656_a(coords, Blocks.field_150432_aD.func_176223_P());
            if (!player.field_70170_p.field_72995_K) {
                ice.add(new IceRemover(coords));
            }
        }
    }

    private void tickIceRemovers(EntityPlayer player) {
        String user = player.func_70005_c_();
        if (!playerIceBlocks.containsKey(user)) {
            return;
        }
        List<IceRemover> removers = playerIceBlocks.get(user);
        for (IceRemover ice : new ArrayList<IceRemover>(removers)) {
            ice.tick(player.field_70170_p, removers);
        }
    }

    @Override
    public void onPlayerBaubleRender(ItemStack stack, RenderPlayerEvent event, IBaubleRender.RenderType type) {
    }

    class IceRemover {
        int time = 30;
        final BlockPos coords;

        public IceRemover(BlockPos coords) {
            this.coords = coords;
        }

        public void tick(World world, List<IceRemover> list) {
            if (world.func_180495_p(this.coords).func_177230_c() == Blocks.field_150432_aD) {
                if (this.time-- != 0) {
                    return;
                }
                world.func_180501_a(this.coords, Blocks.field_150355_j.func_176223_P(), 3);
                list.remove(this);
            }
        }
    }
}

