/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelPick
extends ItemPickaxe
implements IManaUsingItem,
ISortableTool {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelPick() {
        this(BotaniaAPI.manasteelToolMaterial, "manasteelPick");
    }

    public ItemManasteelPick(Item.ToolMaterial mat, String name) {
        super(mat);
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        this.func_77655_b(name);
    }

    public Item func_77655_b(String par1Str) {
        GameRegistry.registerItem((Item)this, (String)par1Str);
        return super.func_77655_b(par1Str);
    }

    public String func_77657_g(ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item.", "item.botania:");
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        ToolCommons.damageItem(par1ItemStack, 1, par3EntityLivingBase, this.getManaPerDmg());
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase entity) {
        if (block.func_176195_g(world, pos) != 0.0f) {
            ToolCommons.damageItem(stack, 1, entity, this.getManaPerDmg());
        }
        return true;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float sx, float sy, float sz) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt == null || !TORCH_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
            boolean did = stackAt.func_77973_b().func_180614_a(stackAt, player, world, pos, side, sx, sy, sz);
            if (stackAt.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(i, null);
            }
            ItemsRemainingRenderHandler.set(player, new ItemStack(Blocks.field_150478_aa), TORCH_PATTERN);
            return did;
        }
        return false;
    }

    public int getManaPerDmg() {
        return 60;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)player, 120, true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 0 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.PICK;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }
}

