/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;
import vazkii.botania.common.item.relic.ItemLokiRing;

public class ItemTerraAxe
extends ItemManasteelAxe
implements ISequentialBreaker {
    private static final int MANA_PER_DAMAGE = 100;
    private static Map<Integer, List<BlockSwapper>> blockSwappers = new HashMap<Integer, List<BlockSwapper>>();

    public ItemTerraAxe() {
        super(BotaniaAPI.terrasteelToolMaterial, "terraAxe");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean shouldBreak(EntityPlayer player) {
        return !player.func_70093_af() && !ItemTemperanceStone.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        MovingObjectPosition raycast = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
        if (raycast != null) {
            this.breakOtherBlock(player, stack, pos, pos, raycast.field_178784_b);
            ItemLokiRing.breakOnAllCursors(player, (Item)this, stack, pos, raycast.field_178784_b);
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(EntityPlayer player, ItemStack stack, BlockPos pos, BlockPos originPos, EnumFacing side) {
        if (this.shouldBreak(player)) {
            BlockPos coords = new BlockPos((Vec3i)pos);
            ItemTerraAxe.addBlockSwapper(player.field_70170_p, player, stack, coords, coords, 32, false, true, new ArrayList<String>());
        }
    }

    @Override
    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.field_73011_w.func_177502_q())) {
            List<BlockSwapper> swappers = blockSwappers.get(dim);
            ArrayList<BlockSwapper> swappersSafe = new ArrayList<BlockSwapper>(swappers);
            swappers.clear();
            for (BlockSwapper s : swappersSafe) {
                if (s == null) continue;
                s.tick();
            }
        }
    }

    private static BlockSwapper addBlockSwapper(World world, EntityPlayer player, ItemStack stack, BlockPos origCoords, BlockPos coords, int steps, boolean leaves, boolean force, List<String> posChecked) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, coords, steps, leaves, force, posChecked);
        int dim = world.field_73011_w.func_177502_q();
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new ArrayList());
        }
        blockSwappers.get(dim).add(swapper);
        return swapper;
    }

    private static class BlockSwapper {
        final World world;
        final EntityPlayer player;
        final ItemStack stack;
        final BlockPos origCoords;
        final int steps;
        final BlockPos coords;
        final boolean leaves;
        final boolean force;
        final List<String> posChecked;

        BlockSwapper(World world, EntityPlayer player, ItemStack stack, BlockPos origCoords, BlockPos coords, int steps, boolean leaves, boolean force, List<String> posChecked) {
            this.world = world;
            this.player = player;
            this.stack = stack;
            this.origCoords = origCoords;
            this.coords = coords;
            this.steps = steps;
            this.leaves = leaves;
            this.force = force;
            this.posChecked = posChecked;
        }

        void tick() {
            Block blockat = this.world.func_180495_p(this.coords).func_177230_c();
            if (!this.force && blockat.isAir((IBlockAccess)this.world, this.coords)) {
                return;
            }
            ToolCommons.removeBlockWithDrops(this.player, this.stack, this.world, this.coords, this.origCoords, null, ToolCommons.materialsAxe, EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)this.stack) > 0, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.stack), 0.0f, false, !this.leaves);
            if (this.steps == 0) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        BlockPos pos = this.coords.func_177982_a(i - 1, j - 1, k - 1);
                        String pstr = this.posStr(pos);
                        if (this.posChecked.contains(pstr)) continue;
                        Block block = this.world.func_180495_p(pos).func_177230_c();
                        boolean log = block.isWood((IBlockAccess)this.world, pos);
                        boolean leaf = block.isLeaves((IBlockAccess)this.world, pos);
                        if (!log && !leaf) continue;
                        int steps = this.steps - 1;
                        steps = leaf ? (this.leaves ? steps : 3) : steps;
                        ItemTerraAxe.addBlockSwapper(this.world, this.player, this.stack, this.origCoords, pos, steps, leaf, false, this.posChecked);
                        this.posChecked.add(pstr);
                    }
                }
            }
        }

        String posStr(BlockPos pos) {
            return pos.func_177958_n() + ":" + pos.func_177956_o() + ":" + pos.func_177952_p();
        }
    }
}

