/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import baubles.api.BaubleType;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSyncBauble;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IExtendedWireframeCoordinateListProvider;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;

public class ItemLokiRing
extends ItemRelicBauble
implements IExtendedWireframeCoordinateListProvider,
IManaUsingItem {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";

    public ItemLokiRing() {
        super("lokiRing");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        block16: {
            EntityPlayer player = event.entityPlayer;
            ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
            if (lokiRing == null || player.field_70170_p.field_72995_K) {
                return;
            }
            int slot = -1;
            InventoryBaubles inv = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack != lokiRing) continue;
                slot = i;
                break;
            }
            ItemStack heldItemStack = player.func_71045_bC();
            BlockPos originCoords = ItemLokiRing.getOriginPos(lokiRing);
            MovingObjectPosition lookPos = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
            List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
            int cursorCount = cursors.size();
            int cost = Math.min(cursorCount, (int)Math.pow(Math.E, (double)cursorCount * 0.25));
            if (heldItemStack == null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && player.func_70093_af()) {
                if (originCoords.func_177956_o() == -1 && lookPos != null) {
                    ItemLokiRing.setOriginPos(lokiRing, lookPos.func_178782_a());
                    ItemLokiRing.setCursorList(lokiRing, null);
                    if (player instanceof EntityPlayerMP) {
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncBauble(player, slot), (EntityPlayerMP)player);
                    }
                } else if (lookPos != null) {
                    if (originCoords.equals((Object)lookPos.func_178782_a())) {
                        ItemLokiRing.setOriginPos(lokiRing, new BlockPos(0, -1, 0));
                        if (player instanceof EntityPlayerMP) {
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncBauble(player, slot), (EntityPlayerMP)player);
                        }
                    } else {
                        BlockPos relPos = lookPos.func_178782_a().func_177971_a((Vec3i)new BlockPos(-originCoords.func_177958_n(), -originCoords.func_177956_o(), -originCoords.func_177952_p()));
                        for (BlockPos cursor : cursors) {
                            if (!cursor.equals((Object)relPos)) continue;
                            cursors.remove(cursor);
                            ItemLokiRing.setCursorList(lokiRing, cursors);
                            if (player instanceof EntityPlayerMP) {
                                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncBauble(player, slot), (EntityPlayerMP)player);
                            }
                            break block16;
                        }
                        ItemLokiRing.addCursor(lokiRing, relPos);
                        if (player instanceof EntityPlayerMP) {
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncBauble(player, slot), (EntityPlayerMP)player);
                        }
                    }
                }
            } else if (heldItemStack != null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && lookPos != null && player.func_70093_af()) {
                for (BlockPos cursor : cursors) {
                    BlockPos pos = lookPos.func_178782_a().func_177971_a((Vec3i)cursor);
                    Item item = heldItemStack.func_77973_b();
                    if (player.field_70170_p.func_175623_d(pos) || !ManaItemHandler.requestManaExact(lokiRing, player, cost, true)) continue;
                    item.func_180614_a(player.field_71075_bZ.field_75098_d ? heldItemStack.func_77946_l() : heldItemStack, player, player.field_70170_p, pos, lookPos.field_178784_b, (float)lookPos.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)lookPos.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)lookPos.field_72307_f.field_72449_c - (float)pos.func_177952_p());
                    if (heldItemStack.field_77994_a != 0) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    public static void breakOnAllCursors(EntityPlayer player, Item item, ItemStack stack, BlockPos pos, EnumFacing side) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing == null || player.field_70170_p.field_72995_K || !(item instanceof ISequentialBreaker)) {
            return;
        }
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        ISequentialBreaker breaker = (ISequentialBreaker)item;
        World world = player.field_70170_p;
        boolean silk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack);
        boolean dispose = breaker.disposeOfTrashBlocks(stack);
        for (int i = 0; i < cursors.size(); ++i) {
            BlockPos coords = cursors.get(i);
            Block block = world.func_180495_p(coords).func_177230_c();
            breaker.breakOtherBlock(player, stack, coords, coords, side);
            ToolCommons.removeBlockWithDrops(player, stack, player.field_70170_p, coords, pos, block, new Material[]{block.func_149688_o()}, silk, fortune, block.func_176195_g(world, coords), dispose);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        ItemLokiRing.setCursorList(stack, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BlockPos> getWireframesToDraw(EntityPlayer player, ItemStack stack) {
        if (ItemLokiRing.getLokiRing(player) != stack) {
            return null;
        }
        MovingObjectPosition lookPos = Minecraft.func_71410_x().field_71476_x;
        if (lookPos != null && !player.field_70170_p.func_175623_d(lookPos.func_178782_a()) && lookPos.field_72308_g == null) {
            List<BlockPos> list = ItemLokiRing.getCursorList(stack);
            BlockPos origin = ItemLokiRing.getOriginPos(stack);
            for (int i = 0; i < list.size(); ++i) {
                if (origin.func_177956_o() != -1) {
                    list.set(i, list.get(i).func_177971_a((Vec3i)origin));
                    continue;
                }
                list.set(i, list.get(i).func_177971_a((Vec3i)lookPos.func_178782_a()));
            }
            return list;
        }
        return null;
    }

    @Override
    public BlockPos getSourceWireframe(EntityPlayer player, ItemStack stack) {
        return ItemLokiRing.getLokiRing(player) == stack ? ItemLokiRing.getOriginPos(stack) : null;
    }

    private static ItemStack getLokiRing(EntityPlayer player) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        ItemStack stack1 = baubles.func_70301_a(1);
        ItemStack stack2 = baubles.func_70301_a(2);
        return ItemLokiRing.isLokiRing(stack1) ? stack1 : (ItemLokiRing.isLokiRing(stack2) ? stack2 : null);
    }

    private static boolean isLokiRing(ItemStack stack) {
        return stack != null && (stack.func_77973_b() == ModItems.lokiRing || stack.func_77973_b() == ModItems.aesirRing);
    }

    private static BlockPos getOriginPos(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new BlockPos(x, y, z);
    }

    private static void setOriginPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.func_177952_p());
    }

    private static List<BlockPos> getCursorList(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<BlockPos> cursors = new ArrayList<BlockPos>();
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            NBTTagCompound cursorCmp = cmp.func_74775_l(TAG_CURSOR_PREFIX + i);
            int x = cursorCmp.func_74762_e(TAG_X_OFFSET);
            int y = cursorCmp.func_74762_e(TAG_Y_OFFSET);
            int z = cursorCmp.func_74762_e(TAG_Z_OFFSET);
            cursors.add(new BlockPos(x, y, z));
        }
        return cursors;
    }

    private static void setCursorList(ItemStack stack, List<BlockPos> cursors) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (cursors != null) {
            int i = 0;
            for (BlockPos cursor : cursors) {
                NBTTagCompound cursorCmp = ItemLokiRing.cursorToCmp(cursor);
                cmp.func_74782_a(TAG_CURSOR_PREFIX + i, (NBTBase)cursorCmp);
                ++i;
            }
            cmp.func_74768_a(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static NBTTagCompound cursorToCmp(BlockPos pos) {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74768_a(TAG_X_OFFSET, pos.func_177958_n());
        cmp.func_74768_a(TAG_Y_OFFSET, pos.func_177956_o());
        cmp.func_74768_a(TAG_Z_OFFSET, pos.func_177952_p());
        return cmp;
    }

    private static void addCursor(ItemStack stack, BlockPos pos) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        cmp.func_74782_a(TAG_CURSOR_PREFIX + count, (NBTBase)ItemLokiRing.cursorToCmp(pos));
        cmp.func_74768_a(TAG_CURSOR_COUNT, count + 1);
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

