/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.ICraftAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.lib.LibMisc;

public class ItemTerraformRod
extends ItemMod
implements IManaUsingItem,
IBlockProvider,
ICraftAchievement {
    private static final int COST_PER = 55;
    static final List<String> validBlocks = Arrays.asList("stone", "dirt", "grass", "sand", "gravel", "hardenedClay", "snowLayer", "mycelium", "podzol", "sandstone", "blockDiorite", "stoneDiorite", "blockGranite", "stoneGranite", "blockAndesite", "stoneAndesite", "marble", "blockMarble", "limestone", "blockLimestone");

    public ItemTerraformRod() {
        this.func_77625_d(1);
        this.func_77655_b("terraformRod");
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count != this.func_77626_a(stack) && count % 10 == 0) {
            this.terraform(stack, player.field_70170_p, player);
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public void terraform(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int range = IManaProficiencyArmor.Helper.hasProficiency(par3EntityPlayer) ? 22 : 16;
        int xCenter = (int)par3EntityPlayer.field_70165_t;
        int yCenter = (int)par3EntityPlayer.field_70163_u;
        int zCenter = (int)par3EntityPlayer.field_70161_v;
        if (yCenter < 62) {
            return;
        }
        int yStart = yCenter + range;
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        for (int i = -range; i < range + 1; ++i) {
            for (int j = -range; j < range + 1; ++j) {
                int k = 0;
                while (yStart + k >= 0) {
                    int[] ids;
                    BlockPos pos = new BlockPos(xCenter + i, yStart + k, zCenter + j);
                    IBlockState state = par2World.func_180495_p(pos);
                    for (int id : ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)))) {
                        if (!validBlocks.contains(OreDictionary.getOreName((int)id))) continue;
                        boolean hasAir = false;
                        ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
                        for (EnumFacing dir : LibMisc.CARDINAL_DIRECTIONS) {
                            BlockPos pos_ = pos.func_177972_a(dir);
                            Block block_ = par2World.func_180495_p(pos_).func_177230_c();
                            if (!block_.isAir((IBlockAccess)par2World, pos_) && !block_.func_176200_f(par2World, pos_) && (!(block_ instanceof BlockFlower) || block_ instanceof ISpecialFlower) && block_ != Blocks.field_150398_cm) continue;
                            airBlocks.add(pos_);
                            hasAir = true;
                        }
                        if (!hasAir) break;
                        if (pos.func_177956_o() > yCenter) {
                            blocks.add(new CoordsWithBlock(pos, Blocks.field_150350_a));
                            break;
                        }
                        for (BlockPos coords : airBlocks) {
                            if (par2World.func_180495_p(coords.func_177977_b()).func_177230_c() == Blocks.field_150350_a) continue;
                            blocks.add(new CoordsWithBlock(coords, Blocks.field_150346_d));
                        }
                        break;
                    }
                    --k;
                }
            }
        }
        int cost = 55 * blocks.size();
        if (par2World.field_72995_K || ManaItemHandler.requestManaExactForTool(par1ItemStack, par3EntityPlayer, cost, true)) {
            if (!par2World.field_72995_K) {
                for (CoordsWithBlock block : blocks) {
                    par2World.func_175656_a((BlockPos)block, block.block.func_176223_P());
                }
            }
            if (!blocks.isEmpty()) {
                int i;
                for (i = 0; i < 10; ++i) {
                    par2World.func_72956_a((Entity)par3EntityPlayer, "step.sand", 1.0f, 0.4f);
                }
                for (i = 0; i < 120; ++i) {
                    Botania.proxy.sparkleFX(par2World, (double)(xCenter - range) + (double)(range * 2) * Math.random(), (double)(yCenter + 2) + (Math.random() - 0.5) * 2.0, (double)(zCenter - range) + (double)(range * 2) * Math.random(), 0.35f, 0.2f, 0.05f, 2.0f, 5);
                }
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doit) {
        if (block == Blocks.field_150346_d && meta == 0) {
            return !doit || ManaItemHandler.requestManaExactForTool(requestor, player, 75, true);
        }
        return false;
    }

    @Override
    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        if (block == Blocks.field_150346_d && meta == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        return ModAchievements.terraformRodCraft;
    }

    class CoordsWithBlock
    extends BlockPos {
        final Block block;

        public CoordsWithBlock(BlockPos pos, Block block) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.block = block;
        }
    }
}

