/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.client.core.handler.RenderEventHandler;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class PageElvenRecipe
extends PageRecipe {
    private static final ResourceLocation elvenTradeOverlay = new ResourceLocation("botania:textures/gui/elvenTradeOverlay.png");
    List<RecipeElvenTrade> recipes;
    int ticksElapsed = 0;
    int recipeAt = 0;

    public PageElvenRecipe(String unlocalizedName, List<RecipeElvenTrade> recipes) {
        super(unlocalizedName);
        this.recipes = recipes;
    }

    public PageElvenRecipe(String unlocalizedName, RecipeElvenTrade recipe) {
        this(unlocalizedName, Arrays.asList(recipe));
    }

    @Override
    public void onPageAdded(LexiconEntry entry, int index) {
        for (RecipeElvenTrade recipe : this.recipes) {
            LexiconRecipeMappings.map(recipe.getOutput(), entry, index);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        RecipeElvenTrade recipe = this.recipes.get(this.recipeAt);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(elvenTradeOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GlStateManager.func_179084_k();
        this.renderItemAtGridPos(gui, 3, 1, recipe.getOutput(), false);
        List<Object> inputs = recipe.getInputs();
        int i = 0;
        for (Object obj : inputs) {
            Object input = obj;
            if (input instanceof String) {
                input = OreDictionary.getOres((String)((String)input)).get(0);
            }
            this.renderItemAtInputPos(gui, i, (ItemStack)input);
            ++i;
        }
        TextureAtlasSprite portalIcon = RenderEventHandler.INSTANCE.alfPortalTex;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ((GuiScreen)gui).func_175175_a(gui.getLeft() + 22, gui.getTop() + 36, portalIcon, 48, 48);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtInputPos(IGuiLexiconEntry gui, int x, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if ((stack = stack.func_77946_l()).func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        int xPos = gui.getLeft() + x * 20 + 45;
        int yPos = gui.getTop() + 14;
        ItemStack stack1 = stack.func_77946_l();
        if (stack1.func_77952_i() == -1) {
            stack1.func_77964_b(0);
        }
        this.renderItem(gui, xPos, yPos, stack1, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (GuiScreen.func_146272_n()) {
            return;
        }
        if (this.ticksElapsed % 20 == 0) {
            ++this.recipeAt;
            if (this.recipeAt == this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
        ++this.ticksElapsed;
    }

    @Override
    public List<ItemStack> getDisplayedRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (RecipeElvenTrade r : this.recipes) {
            list.add(r.getOutput());
        }
        return list;
    }
}

