/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.data.MCDataIO;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.EncoderException;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.EnumMap;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkHandshakeEstablished;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PacketCustom
extends PacketBuffer
implements MCDataInput,
MCDataOutput {
    public static AttributeKey<CustomInboundHandler> cclHandler = new AttributeKey("ccl:handler");
    private String channel;
    private int type;

    public static String channelName(Object channelKey) {
        if (channelKey instanceof String) {
            return (String)channelKey;
        }
        if (channelKey instanceof ModContainer) {
            String s = ((ModContainer)channelKey).getModId();
            if (s.length() > 20) {
                throw new IllegalArgumentException("Mod ID (" + s + ") too long for use as channel (20 chars). Use a string identifier");
            }
            return s;
        }
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(channelKey);
        if (mc != null) {
            return mc.getModId();
        }
        throw new IllegalArgumentException("Invalid channel: " + channelKey);
    }

    public static FMLEmbeddedChannel getOrCreateChannel(String channelName, Side side) {
        if (!NetworkRegistry.INSTANCE.hasChannel(channelName, side)) {
            NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{new CustomInboundHandler()});
        }
        return NetworkRegistry.INSTANCE.getChannel(channelName, side);
    }

    public static void assignHandler(Object channelKey, ICustomPacketHandler handler) {
        String channelName = PacketCustom.channelName(channelKey);
        Side side = handler instanceof IServerPacketHandler ? Side.SERVER : Side.CLIENT;
        FMLEmbeddedChannel channel = PacketCustom.getOrCreateChannel(channelName, side);
        ((CustomInboundHandler)((Object)channel.attr(PacketCustom.cclHandler).get())).handlers.put(side, side == Side.SERVER ? new ServerInboundHandler(handler) : new ClientInboundHandler(handler));
    }

    public static void assignHandshakeHandler(Object channelKey, IHandshakeHandler handler) {
        FMLEmbeddedChannel channel = PacketCustom.getOrCreateChannel(PacketCustom.channelName(channelKey), Side.SERVER);
        channel.pipeline().addLast(new ChannelHandler[]{new HandshakeInboundHandler(handler)});
    }

    public PacketCustom(ByteBuf payload) {
        super(payload);
        this.type = this.readUnsignedByte();
        if (this.type > 128) {
            this.decompress();
        }
        this.type &= 0x7F;
    }

    public PacketCustom(Object channelKey, int type) {
        super(Unpooled.buffer());
        if (type <= 0 || type >= 128) {
            throw new IllegalArgumentException("Packet type: " + type + " is not within required 0 < t < 0x80");
        }
        this.channel = PacketCustom.channelName(channelKey);
        this.type = type;
        this.writeByte(type);
    }

    private void decompress() {
        Inflater inflater = new Inflater();
        try {
            int len = this.readInt();
            byte[] out = new byte[len];
            inflater.setInput(this.array(), this.readerIndex(), this.readableBytes());
            inflater.inflate(out);
            this.clear();
            this.func_179250_a(out);
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            inflater.end();
        }
    }

    private void do_compress() {
        Deflater deflater = new Deflater();
        try {
            this.readerIndex(1);
            int len = this.readableBytes();
            deflater.setInput(this.array(), this.readerIndex(), len);
            deflater.finish();
            byte[] out = new byte[len];
            int clen = deflater.deflate(out);
            if (clen >= len - 5 || !deflater.finished()) {
                return;
            }
            this.clear();
            this.writeByte(this.type | 0x80);
            this.writeVarInt(len);
            this.func_179250_a(out);
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.readerIndex(0);
            deflater.end();
        }
    }

    public boolean incoming() {
        return this.channel == null;
    }

    public int getType() {
        return this.type & 0x7F;
    }

    public PacketCustom compress() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to compress an incoming packet");
        }
        if ((this.type & 0x80) != 0) {
            throw new IllegalStateException("Packet already compressed");
        }
        this.type |= 0x80;
        return this;
    }

    @Override
    public PacketCustom writeBoolean(boolean b) {
        super.writeBoolean(b);
        return this;
    }

    @Override
    public PacketCustom writeByte(int b) {
        super.writeByte(b);
        return this;
    }

    @Override
    public PacketCustom writeShort(int s) {
        super.writeShort(s);
        return this;
    }

    @Override
    public PacketCustom writeInt(int i) {
        super.writeInt(i);
        return this;
    }

    @Override
    public PacketCustom writeFloat(float f) {
        super.writeFloat(f);
        return this;
    }

    @Override
    public PacketCustom writeDouble(double d) {
        super.writeDouble(d);
        return this;
    }

    @Override
    public PacketCustom writeLong(long l) {
        super.writeLong(l);
        return this;
    }

    @Override
    public PacketCustom writeChar(char c) {
        super.writeChar((int)c);
        return this;
    }

    @Override
    public PacketCustom writeVarInt(int i) {
        this.func_150787_b(i);
        return this;
    }

    @Override
    public PacketCustom writeVarShort(int s) {
        MCDataIO.writeVarShort(this, s);
        return this;
    }

    @Override
    public PacketCustom writeArray(byte[] barray) {
        this.writeBytes(barray);
        return this;
    }

    @Override
    public PacketCustom writeString(String s) {
        super.func_180714_a(s);
        return this;
    }

    @Override
    public PacketCustom writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    public PacketCustom writeCoord(BlockPos pos) {
        this.writeInt(pos.func_177958_n());
        this.writeInt(pos.func_177956_o());
        this.writeInt(pos.func_177952_p());
        return this;
    }

    @Override
    public PacketCustom writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public PacketCustom writeItemStack(ItemStack stack) {
        MCDataIO.writeItemStack(this, stack);
        return this;
    }

    @Override
    public PacketCustom writeNBTTagCompound(NBTTagCompound tag) {
        this.func_150786_a(tag);
        return this;
    }

    @Override
    public PacketCustom writeFluidStack(FluidStack fluid) {
        MCDataIO.writeFluidStack(this, fluid);
        return this;
    }

    @Override
    public short readUByte() {
        return this.readUnsignedByte();
    }

    @Override
    public int readUShort() {
        return this.readUnsignedShort();
    }

    @Override
    public int readVarShort() {
        return MCDataIO.readVarShort(this);
    }

    @Override
    public int readVarInt() {
        return this.func_150792_a();
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public byte[] readArray(int length) {
        return this.readBytes(length).array();
    }

    @Override
    public String readString() {
        return this.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public ItemStack readItemStack() {
        return MCDataIO.readItemStack(this);
    }

    @Override
    public NBTTagCompound readNBTTagCompound() {
        try {
            return this.func_150793_b();
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    @Override
    public FluidStack readFluidStack() {
        return MCDataIO.readFluidStack(this);
    }

    public FMLProxyPacket toPacket() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to write an incoming packet");
        }
        if (this.readableBytes() > 32000 || (this.type & 0x80) != 0) {
            this.do_compress();
        }
        return new FMLProxyPacket(new PacketBuffer(this.copy()), this.channel);
    }

    public void sendToPlayer(EntityPlayer player) {
        PacketCustom.sendToPlayer((Packet)this.toPacket(), player);
    }

    public static void sendToPlayer(Packet packet, EntityPlayer player) {
        if (player == null) {
            PacketCustom.sendToClients(packet);
        } else {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }

    public void sendToClients() {
        PacketCustom.sendToClients((Packet)this.toPacket());
    }

    public static void sendToClients(Packet packet) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a(packet);
    }

    public void sendPacketToAllAround(double x, double y, double z, double range, int dim) {
        PacketCustom.sendToAllAround((Packet)this.toPacket(), x, y, z, range, dim);
    }

    public static void sendToAllAround(Packet packet, double x, double y, double z, double range, int dim) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148543_a(null, x, y, z, range, dim, packet);
    }

    public void sendToDimension(int dim) {
        PacketCustom.sendToDimension((Packet)this.toPacket(), dim);
    }

    public static void sendToDimension(Packet packet, int dim) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148537_a(packet, dim);
    }

    public void sendToChunk(World world, int chunkX, int chunkZ) {
        PacketCustom.sendToChunk((Packet)this.toPacket(), world, chunkX, chunkZ);
    }

    public static void sendToChunk(Packet packet, World world, int chunkX, int chunkZ) {
        PlayerManager.PlayerInstance playerInstance = ((WorldServer)world).field_73063_M.func_187301_b(chunkX, chunkZ);
        if (playerInstance != null) {
            playerInstance.func_187267_a(packet);
        }
    }

    public void sendToOps() {
        PacketCustom.sendToOps((Packet)this.toPacket());
    }

    public static void sendToOps(Packet packet) {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH())) continue;
            PacketCustom.sendToPlayer(packet, (EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        PacketCustom.sendToServer((Packet)this.toPacket());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(Packet packet) {
        Minecraft.func_71410_x().func_147114_u().func_147297_a(packet);
    }

    public static class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        public IHandshakeHandler handler;

        public HandshakeInboundHandler(IHandshakeHandler handler) {
            this.handler = handler;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof NetworkHandshakeEstablished) {
                INetHandler netHandler = ((NetworkDispatcher)ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).get()).getNetHandler();
                if (netHandler instanceof NetHandlerPlayServer) {
                    this.handler.handshakeReceived((NetHandlerPlayServer)netHandler);
                }
            } else {
                ctx.fireUserEventTriggered(evt);
            }
        }
    }

    public static interface IHandshakeHandler {
        public void handshakeReceived(NetHandlerPlayServer var1);
    }

    public static class ServerInboundHandler
    implements CustomHandler {
        private IServerPacketHandler handler;

        public ServerInboundHandler(ICustomPacketHandler handler) {
            this.handler = (IServerPacketHandler)handler;
        }

        @Override
        public void handle(final INetHandler netHandler, final String channel, final PacketCustom packet) {
            if (netHandler instanceof NetHandlerPlayServer) {
                MinecraftServer mc = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (!mc.func_152345_ab()) {
                    mc.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            ServerInboundHandler.this.handle(netHandler, channel, packet);
                        }
                    });
                } else {
                    this.handler.handlePacket(packet, ((NetHandlerPlayServer)netHandler).field_147369_b, (INetHandlerPlayServer)netHandler);
                }
            } else {
                System.err.println("Invalid INetHandler for PacketCustom on channel: " + channel);
            }
        }
    }

    public static class ClientInboundHandler
    implements CustomHandler {
        private IClientPacketHandler handler;

        public ClientInboundHandler(ICustomPacketHandler handler) {
            this.handler = (IClientPacketHandler)handler;
        }

        @Override
        public void handle(final INetHandler netHandler, final String channel, final PacketCustom packet) {
            if (netHandler instanceof INetHandlerPlayClient) {
                Minecraft mc = Minecraft.func_71410_x();
                if (!mc.func_152345_ab()) {
                    mc.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            ClientInboundHandler.this.handle(netHandler, channel, packet);
                        }
                    });
                } else {
                    this.handler.handlePacket(packet, mc, (INetHandlerPlayClient)netHandler);
                }
            } else {
                System.err.println("Invalid INetHandler for PacketCustom on channel: " + channel);
            }
        }
    }

    private static interface CustomHandler {
        public void handle(INetHandler var1, String var2, PacketCustom var3);
    }

    @ChannelHandler.Sharable
    public static class CustomInboundHandler
    extends SimpleChannelInboundHandler<FMLProxyPacket> {
        public EnumMap<Side, CustomHandler> handlers = Maps.newEnumMap(Side.class);

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            ctx.channel().attr(cclHandler).set((Object)this);
        }

        protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
            this.handlers.get(ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get()).handle((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get(), new PacketCustom(msg.payload()));
        }
    }

    public static interface IServerPacketHandler
    extends ICustomPacketHandler {
        public void handlePacket(PacketCustom var1, EntityPlayerMP var2, INetHandlerPlayServer var3);
    }

    public static interface IClientPacketHandler
    extends ICustomPacketHandler {
        public void handlePacket(PacketCustom var1, Minecraft var2, INetHandlerPlayClient var3);
    }

    public static interface ICustomPacketHandler {
    }
}

