/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LC;
import codechicken.lib.lighting.LightMatrix;
import codechicken.lib.render.CCDynamicModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderPipeline;
import codechicken.lib.render.Vertex5;
import codechicken.lib.util.Copyable;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CCRenderState {
    private static int nextOperationIndex;
    private static ArrayList<VertexAttribute<?>> vertexAttributes;
    public static VertexAttribute<Vector3[]> normalAttrib;
    public static VertexAttribute<int[]> colourAttrib;
    public static VertexAttribute<int[]> lightingAttrib;
    public static VertexAttribute<int[]> sideAttrib;
    public static VertexAttribute<LC[]> lightCoordAttrib;
    public static IVertexSource model;
    public static int firstVertexIndex;
    public static int lastVertexIndex;
    public static int vertexIndex;
    public static CCRenderPipeline pipeline;
    public static VertexBuffer r;
    public static VertexFormat fmt;
    public static int baseColour;
    public static int alphaOverride;
    public static boolean computeLighting;
    public static LightMatrix lightMatrix;
    public static final Vertex5 vert;
    public static final Vector3 normal;
    public static int colour;
    public static int brightness;
    public static int side;
    public static LC lc;
    public static VertexFormat POSITION_TEX_LMAP;
    public static VertexFormat POSITION_TEX_LMAP_NORMAL;
    public static VertexFormat POSITION_TEX_LMAP_COLOR_NORMAL;

    public static int registerOperation() {
        return nextOperationIndex++;
    }

    public static int operationCount() {
        return nextOperationIndex;
    }

    private static int registerVertexAttribute(VertexAttribute<?> attr) {
        vertexAttributes.add(attr);
        return vertexAttributes.size() - 1;
    }

    public static VertexAttribute<?> getAttribute(int index) {
        return vertexAttributes.get(index);
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])dst;
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> T copyOf(VertexAttribute<T> attr, T src, int length) {
        T dst = attr.newArray(length);
        CCRenderState.arrayCopy(src, 0, dst, 0, ((Object[])src).length);
        return dst;
    }

    public static void reset() {
        model = null;
        pipeline.reset();
        computeLighting = true;
        alphaOverride = -1;
        baseColour = -1;
    }

    public static void setPipeline(IVertexOperation ... ops) {
        pipeline.setPipeline(ops);
    }

    public static void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        pipeline.reset();
        CCRenderState.setModel(model, start, end);
        pipeline.setPipeline(ops);
    }

    public static void bindModel(IVertexSource model) {
        if (CCRenderState.model != model) {
            CCRenderState.model = model;
            pipeline.rebuild();
        }
    }

    public static void setModel(IVertexSource source) {
        CCRenderState.setModel(source, 0, source.getVertices().length);
    }

    public static void setModel(IVertexSource source, int start, int end) {
        CCRenderState.bindModel(source);
        CCRenderState.setVertexRange(start, end);
    }

    public static void setVertexRange(int start, int end) {
        firstVertexIndex = start;
        lastVertexIndex = end;
    }

    public static CCDynamicModel dynamicModel(VertexAttribute ... attrs) {
        CCDynamicModel m = new CCDynamicModel(attrs);
        CCRenderState.bindModel(m);
        return m;
    }

    public static void render(IVertexOperation ... ops) {
        CCRenderState.setPipeline(ops);
        CCRenderState.render();
    }

    public static void render() {
        Vertex5[] verts = model.getVertices();
        for (vertexIndex = firstVertexIndex; vertexIndex < lastVertexIndex; ++vertexIndex) {
            model.prepareVertex();
            vert.set(verts[vertexIndex]);
            CCRenderState.runPipeline();
            CCRenderState.writeVert();
        }
    }

    public static void runPipeline() {
        pipeline.operate();
    }

    public static void writeVert() {
        block7: for (int e = 0; e < fmt.func_177345_h(); ++e) {
            VertexFormatElement fmte = fmt.func_177348_c(e);
            switch (fmte.func_177375_c()) {
                case POSITION: {
                    r.func_181662_b(CCRenderState.vert.vec.x, CCRenderState.vert.vec.y, CCRenderState.vert.vec.z);
                    continue block7;
                }
                case UV: {
                    if (fmte.func_177369_e() == 0) {
                        r.func_187315_a(CCRenderState.vert.uv.u, CCRenderState.vert.uv.v);
                        continue block7;
                    }
                    r.func_187314_a(brightness >> 16 & 0xFFFF, brightness & 0xFFFF);
                    continue block7;
                }
                case COLOR: {
                    r.func_181669_b(colour >>> 24, colour >> 16 & 0xFF, colour >> 8 & 0xFF, alphaOverride >= 0 ? alphaOverride : colour & 0xFF);
                    continue block7;
                }
                case NORMAL: {
                    r.func_181663_c((float)CCRenderState.normal.x, (float)CCRenderState.normal.y, (float)CCRenderState.normal.z);
                    continue block7;
                }
                case PADDING: {
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Generic vertex format element");
                }
            }
        }
        r.func_181675_d();
    }

    public static void pushColour() {
        GlStateManager.func_179131_c((float)((float)(colour >>> 24) / 255.0f), (float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(alphaOverride >= 0 ? alphaOverride : colour & 0xFF) / 255.0f));
    }

    public static void setBrightness(IBlockAccess world, BlockPos pos) {
        brightness = world.func_180495_p(pos).func_177230_c().func_185484_c(world.func_180495_p(pos), world, pos);
    }

    public static void pullLightmap() {
        brightness = (int)OpenGlHelper.lastBrightnessY << 16 | (int)OpenGlHelper.lastBrightnessX;
    }

    public static void pushLightmap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(brightness & 0xFFFF), (float)(brightness >>> 16));
    }

    public static void changeTexture(String texture) {
        CCRenderState.changeTexture(new ResourceLocation(texture));
    }

    public static void changeTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static VertexBuffer startDrawing(int mode, VertexFormat format) {
        VertexBuffer r = Tessellator.func_178181_a().func_178180_c();
        r.func_181668_a(mode, format);
        return r;
    }

    public static void bind(VertexBuffer r) {
        CCRenderState.r = r;
        fmt = r.func_178973_g();
    }

    public static void draw() {
        Tessellator.func_178181_a().func_78381_a();
    }

    static /* synthetic */ int access$000(VertexAttribute x0) {
        return CCRenderState.registerVertexAttribute(x0);
    }

    static {
        vertexAttributes = new ArrayList();
        normalAttrib = new VertexAttribute<Vector3[]>(){
            private Vector3[] normalRef;

            @Override
            public Vector3[] newArray(int length) {
                return new Vector3[length];
            }

            @Override
            public boolean load() {
                this.normalRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.normalRef != null;
                }
                if (model.hasAttribute(sideAttrib)) {
                    pipeline.addDependency(sideAttrib);
                    return true;
                }
                throw new IllegalStateException("Normals requested but neither normal or side attrutes are provided by the model");
            }

            @Override
            public void operate() {
                if (this.normalRef != null) {
                    normal.set(this.normalRef[vertexIndex]);
                } else {
                    normal.set(Rotation.axes[side]);
                }
            }
        };
        colourAttrib = new VertexAttribute<int[]>(){
            private int[] colourRef;

            @Override
            public int[] newArray(int length) {
                return new int[length];
            }

            @Override
            public boolean load() {
                this.colourRef = model.getAttributes(this);
                return this.colourRef != null || !model.hasAttribute(this);
            }

            @Override
            public void operate() {
                colour = this.colourRef != null ? ColourRGBA.multiply(baseColour, this.colourRef[vertexIndex]) : baseColour;
            }
        };
        lightingAttrib = new VertexAttribute<int[]>(){
            private int[] colourRef;

            @Override
            public int[] newArray(int length) {
                return new int[length];
            }

            @Override
            public boolean load() {
                if (!(computeLighting && fmt.func_177346_d() && model.hasAttribute(this))) {
                    return false;
                }
                this.colourRef = model.getAttributes(this);
                if (this.colourRef != null) {
                    pipeline.addDependency(colourAttrib);
                    return true;
                }
                return false;
            }

            @Override
            public void operate() {
                colour = ColourRGBA.multiply(colour, this.colourRef[vertexIndex]);
            }
        };
        sideAttrib = new VertexAttribute<int[]>(){
            private int[] sideRef;

            @Override
            public int[] newArray(int length) {
                return new int[length];
            }

            @Override
            public boolean load() {
                this.sideRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.sideRef != null;
                }
                pipeline.addDependency(normalAttrib);
                return true;
            }

            @Override
            public void operate() {
                side = this.sideRef != null ? this.sideRef[vertexIndex] : CCModel.findSide(normal);
            }
        };
        lightCoordAttrib = new VertexAttribute<LC[]>(){
            private LC[] lcRef;
            private Vector3 vec = new Vector3();
            private Vector3 pos = new Vector3();

            @Override
            public LC[] newArray(int length) {
                return new LC[length];
            }

            @Override
            public boolean load() {
                this.lcRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.lcRef != null;
                }
                this.pos.set(CCRenderState.lightMatrix.pos.x, CCRenderState.lightMatrix.pos.y, CCRenderState.lightMatrix.pos.z);
                pipeline.addDependency(sideAttrib);
                pipeline.addRequirement(Transformation.operationIndex);
                return true;
            }

            @Override
            public void operate() {
                if (this.lcRef != null) {
                    lc.set(this.lcRef[vertexIndex]);
                } else {
                    lc.compute(this.vec.set(CCRenderState.vert.vec).sub(this.pos), side);
                }
            }
        };
        pipeline = new CCRenderPipeline();
        lightMatrix = new LightMatrix();
        vert = new Vertex5();
        normal = new Vector3();
        lc = new LC();
        POSITION_TEX_LMAP = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p);
        POSITION_TEX_LMAP_NORMAL = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
        POSITION_TEX_LMAP_COLOR_NORMAL = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181714_n).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    }

    public static interface IVertexSource {
        public Vertex5[] getVertices();

        public <T> T getAttributes(VertexAttribute<T> var1);

        public boolean hasAttribute(VertexAttribute<?> var1);

        public void prepareVertex();
    }

    public static abstract class VertexAttribute<T>
    implements IVertexOperation {
        public final int attributeIndex = CCRenderState.access$000(this);
        private final int operationIndex = CCRenderState.registerOperation();
        public boolean active = false;

        public abstract T newArray(int var1);

        @Override
        public int operationID() {
            return this.operationIndex;
        }
    }

    public static interface IVertexOperation {
        public boolean load();

        public void operate();

        public int operationID();
    }
}

