/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.lexicon.multiblock;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;

public class Multiblock {
    public List<MultiblockComponent> components = new ArrayList<MultiblockComponent>();
    public List<ItemStack> materials = new ArrayList<ItemStack>();
    public BlockPos minPos = BlockPos.field_177992_a;
    public BlockPos maxPos = BlockPos.field_177992_a;
    public BlockPos offPos = BlockPos.field_177992_a;
    public HashMap<BlockPos, MultiblockComponent> locationCache = new HashMap();

    public void addComponent(MultiblockComponent component) {
        if (this.getComponentForLocation(component.getRelativePosition()) != null) {
            throw new IllegalArgumentException("Location in multiblock already occupied");
        }
        this.components.add(component);
        this.changeAxisForNewComponent(component.getRelativePosition());
        this.calculateCostForNewComponent(component);
        this.addComponentToLocationCache(component);
    }

    public void addComponent(BlockPos pos, IBlockState state) {
        this.addComponent(new MultiblockComponent(pos, state));
    }

    private void changeAxisForNewComponent(BlockPos pos) {
        if (pos.func_177958_n() < this.minPos.func_177958_n()) {
            this.minPos = new BlockPos(pos.func_177958_n(), this.minPos.func_177956_o(), this.minPos.func_177952_p());
        } else if (pos.func_177958_n() > this.maxPos.func_177958_n()) {
            this.maxPos = new BlockPos(pos.func_177958_n(), this.maxPos.func_177956_o(), this.maxPos.func_177952_p());
        }
        if (pos.func_177956_o() < this.minPos.func_177956_o()) {
            this.minPos = new BlockPos(this.minPos.func_177958_n(), pos.func_177956_o(), this.minPos.func_177952_p());
        } else if (pos.func_177956_o() > this.maxPos.func_177956_o()) {
            this.maxPos = new BlockPos(this.maxPos.func_177958_n(), pos.func_177956_o(), this.maxPos.func_177952_p());
        }
        if (pos.func_177952_p() < this.minPos.func_177952_p()) {
            this.minPos = new BlockPos(this.minPos.func_177958_n(), this.minPos.func_177956_o(), pos.func_177952_p());
        } else if (pos.func_177952_p() > this.maxPos.func_177952_p()) {
            this.maxPos = new BlockPos(this.maxPos.func_177958_n(), this.maxPos.func_177956_o(), pos.func_177952_p());
        }
    }

    private void calculateCostForNewComponent(MultiblockComponent comp) {
        ItemStack[] materials = comp.getMaterials();
        if (materials != null) {
            for (ItemStack stack : materials) {
                this.addStack(stack);
            }
        }
    }

    private void addStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        for (ItemStack oStack : this.materials) {
            if (!oStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)oStack, (ItemStack)stack)) continue;
            oStack.field_77994_a += stack.field_77994_a;
            return;
        }
        this.materials.add(stack);
    }

    public void setRenderOffset(BlockPos pos) {
        this.offPos = pos;
    }

    public List<MultiblockComponent> getComponents() {
        return this.components;
    }

    public void rotate(double angle) {
        for (MultiblockComponent comp : this.getComponents()) {
            comp.rotate(angle);
        }
        this.updateLocationCache();
    }

    public Multiblock copy() {
        Multiblock mb = new Multiblock();
        for (MultiblockComponent comp : this.getComponents()) {
            mb.addComponent(comp.copy());
        }
        return mb;
    }

    public Map<EnumFacing, Multiblock> createRotations() {
        EnumMap<EnumFacing, Multiblock> ret = new EnumMap<EnumFacing, Multiblock>(EnumFacing.class);
        ret.put(EnumFacing.SOUTH, this);
        ret.put(EnumFacing.WEST, ((Multiblock)ret.get(EnumFacing.SOUTH)).copy());
        ((Multiblock)ret.get(EnumFacing.WEST)).rotate(1.5707963267948966);
        ret.put(EnumFacing.NORTH, ((Multiblock)ret.get(EnumFacing.WEST)).copy());
        ((Multiblock)ret.get(EnumFacing.NORTH)).rotate(1.5707963267948966);
        ret.put(EnumFacing.EAST, ((Multiblock)ret.get(EnumFacing.NORTH)).copy());
        ((Multiblock)ret.get(EnumFacing.EAST)).rotate(1.5707963267948966);
        return ret;
    }

    public MultiblockSet makeSet() {
        return new MultiblockSet(this);
    }

    public int getXSize() {
        return Math.abs(this.minPos.func_177958_n()) + Math.abs(this.maxPos.func_177958_n()) + 1;
    }

    public int getYSize() {
        return Math.abs(this.minPos.func_177956_o()) + Math.abs(this.maxPos.func_177956_o()) + 1;
    }

    public int getZSize() {
        return Math.abs(this.minPos.func_177952_p()) + Math.abs(this.maxPos.func_177952_p()) + 1;
    }

    public void updateLocationCache() {
        this.locationCache.clear();
        for (MultiblockComponent comp : this.components) {
            this.addComponentToLocationCache(comp);
        }
    }

    private void addComponentToLocationCache(MultiblockComponent comp) {
        BlockPos pos = comp.getRelativePosition();
        this.locationCache.put(pos, comp);
    }

    public MultiblockComponent getComponentForLocation(BlockPos pos) {
        return this.locationCache.get(pos);
    }
}

