/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.state;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.PropertyObject;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.api.state.enums.BiomeBrickVariant;
import vazkii.botania.api.state.enums.BiomeStoneVariant;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.api.state.enums.CrateVariant;
import vazkii.botania.api.state.enums.CustomBrickVariant;
import vazkii.botania.api.state.enums.DrumVariant;
import vazkii.botania.api.state.enums.EndBrickVariant;
import vazkii.botania.api.state.enums.FutureStoneVariant;
import vazkii.botania.api.state.enums.LivingRockVariant;
import vazkii.botania.api.state.enums.LivingWoodVariant;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.state.enums.PlatformVariant;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.state.enums.PrismarineVariant;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.api.state.enums.QuartzVariant;
import vazkii.botania.api.state.enums.SpreaderVariant;
import vazkii.botania.api.state.enums.StorageVariant;

public final class BotaniaStateProps {
    public static final PropertyObject<String> SUBTILE_ID = new PropertyObject<String>("subtile_id", String.class);
    public static final PropertyObject<IFloatingFlower.IslandType> ISLAND_TYPE = new PropertyObject<IFloatingFlower.IslandType>("islandtype", IFloatingFlower.IslandType.class);
    public static final PropertyObject<IBlockState> HELD_STATE = new PropertyObject<IBlockState>("held_state", IBlockState.class);
    public static final PropertyObject<IBlockAccess> HELD_WORLD = new PropertyObject<IBlockAccess>("held_world", IBlockAccess.class);
    public static final PropertyObject<BlockPos> HELD_POS = new PropertyObject<BlockPos>("held_pos", BlockPos.class);
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    public static final PropertyEnum<EnumFacing> CARDINALS = PropertyEnum.func_177708_a((String)"facing", EnumFacing.class, (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<EnumFacing.Axis> AXIS_FACING = BlockRotatedPillar.field_176298_M;
    public static final PropertyEnum<QuartzVariant> QUARTZ_VARIANT = PropertyEnum.func_177709_a((String)"variant", QuartzVariant.class);
    public static final PropertyEnum<FutureStoneVariant> FUTURESTONE_VARIANT = PropertyEnum.func_177709_a((String)"variant", FutureStoneVariant.class);
    public static final PropertyEnum<FutureStoneVariant> FUTURESTONEWALL_VARIANT = PropertyEnum.func_177708_a((String)"fswall_variant", FutureStoneVariant.class, (Predicate)new Predicate<FutureStoneVariant>(){

        public boolean apply(FutureStoneVariant variant) {
            return variant.ordinal() >= 0 && variant.ordinal() <= 3;
        }
    });
    public static final PropertyEnum<AlfPortalState> ALFPORTAL_STATE = PropertyEnum.func_177709_a((String)"state", AlfPortalState.class);
    public static final PropertyEnum<AltarVariant> ALTAR_VARIANT = PropertyEnum.func_177709_a((String)"variant", AltarVariant.class);
    public static final PropertyEnum<AltGrassVariant> ALTGRASS_VARIANT = PropertyEnum.func_177709_a((String)"variant", AltGrassVariant.class);
    public static final PropertyEnum<BiomeStoneVariant> BIOMESTONE_VARIANT = PropertyEnum.func_177709_a((String)"variant", BiomeStoneVariant.class);
    public static final PropertyEnum<BiomeBrickVariant> BIOMEBRICK_VARIANT = PropertyEnum.func_177709_a((String)"variant", BiomeBrickVariant.class);
    public static final PropertyEnum<BiomeStoneVariant> BIOMESTONEWALL_VARIANT = PropertyEnum.func_177708_a((String)"bswall_variant", BiomeStoneVariant.class, (Predicate)new Predicate<BiomeStoneVariant>(){

        public boolean apply(BiomeStoneVariant input) {
            return input.func_176610_l().contains("cobble");
        }
    });
    public static final PropertyEnum<CustomBrickVariant> CUSTOMBRICK_VARIANT = PropertyEnum.func_177709_a((String)"variant", CustomBrickVariant.class);
    public static final PropertyEnum<LivingWoodVariant> LIVINGWOOD_VARIANT = PropertyEnum.func_177709_a((String)"variant", LivingWoodVariant.class);
    public static final PropertyEnum<EnumFacing.Axis> ENCHANTER_DIRECTION = PropertyEnum.func_177708_a((String)"facing", EnumFacing.Axis.class, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)EnumFacing.Axis.Y)));
    public static final PropertyEnum<EndBrickVariant> ENDBRICK_VARIANT = PropertyEnum.func_177709_a((String)"variant", EndBrickVariant.class);
    public static final PropertyEnum<DrumVariant> DRUM_VARIANT = PropertyEnum.func_177709_a((String)"variant", DrumVariant.class);
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> RAIL_DIRECTION = BlockRailPowered.field_176568_b;
    public static final PropertyEnum<LuminizerVariant> LUMINIZER_VARIANT = PropertyEnum.func_177709_a((String)"variant", LuminizerVariant.class);
    public static final PropertyEnum<LivingRockVariant> LIVINGROCK_VARIANT = PropertyEnum.func_177709_a((String)"variant", LivingRockVariant.class);
    public static final PropertyEnum<EnumDyeColor> DOUBLEFLOWER_VARIANT_1 = PropertyEnum.func_177708_a((String)"df_variant", EnumDyeColor.class, (Predicate)new Predicate<EnumDyeColor>(){

        public boolean apply(EnumDyeColor input) {
            return input.ordinal() >= 0 && input.ordinal() <= 7;
        }
    });
    public static final PropertyEnum<EnumDyeColor> DOUBLEFLOWER_VARIANT_2 = PropertyEnum.func_177708_a((String)"df_variant", EnumDyeColor.class, (Predicate)new Predicate<EnumDyeColor>(){

        public boolean apply(EnumDyeColor input) {
            return input.ordinal() >= 8 && input.ordinal() <= 15;
        }
    });
    public static final PropertyEnum<CrateVariant> CRATE_VARIANT = PropertyEnum.func_177709_a((String)"variant", CrateVariant.class);
    public static final PropertyEnum<CratePattern> CRATE_PATTERN = PropertyEnum.func_177709_a((String)"pattern", CratePattern.class);
    public static final PropertyEnum<EnumDyeColor> PAVEMENT_COLOR = PropertyEnum.func_177708_a((String)"color", EnumDyeColor.class, (Predicate)new Predicate<EnumDyeColor>(){

        public boolean apply(EnumDyeColor color) {
            return color == EnumDyeColor.WHITE || color == EnumDyeColor.BLACK || color == EnumDyeColor.BLUE || color == EnumDyeColor.RED || color == EnumDyeColor.YELLOW || color == EnumDyeColor.GREEN;
        }
    });
    public static final PropertyEnum<PlatformVariant> PLATFORM_VARIANT = PropertyEnum.func_177709_a((String)"variant", PlatformVariant.class);
    public static final PropertyEnum<PoolVariant> POOL_VARIANT = PropertyEnum.func_177709_a((String)"variant", PoolVariant.class);
    public static final PropertyBool HAS_LENS = PropertyBool.func_177716_a((String)"has_lens");
    public static final PropertyEnum<PrismarineVariant> PRISMARINE_VARIANT = PropertyEnum.func_177709_a((String)"variant", PrismarineVariant.class);
    public static final PropertyEnum<PylonVariant> PYLON_VARIANT = PropertyEnum.func_177709_a((String)"variant", PylonVariant.class);
    public static final PropertyEnum<SpreaderVariant> SPREADER_VARIANT = PropertyEnum.func_177709_a((String)"variant", SpreaderVariant.class);
    public static final PropertyEnum<StorageVariant> STORAGE_VARIANT = PropertyEnum.func_177709_a((String)"variant", StorageVariant.class);

    private BotaniaStateProps() {
    }
}

