/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.ISubTileSlowableContainer;
import vazkii.botania.api.subtile.RadiusDescriptor;

public class SubTileEntity {
    protected TileEntity supertile;
    public int ticksExisted = 0;
    public boolean overgrowth = false;
    public boolean overgrowthBoost = false;
    public static final String TAG_TYPE = "type";
    public static final String TAG_TICKS_EXISTED = "ticksExisted";

    public void setSupertile(TileEntity tile) {
        this.supertile = tile;
    }

    public void onUpdate() {
        ++this.ticksExisted;
    }

    public final void writeToPacketNBTInternal(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_TICKS_EXISTED, this.ticksExisted);
        this.writeToPacketNBT(cmp);
    }

    public final void readFromPacketNBTInternal(NBTTagCompound cmp) {
        if (cmp.func_74764_b(TAG_TICKS_EXISTED)) {
            this.ticksExisted = cmp.func_74762_e(TAG_TICKS_EXISTED);
        }
        this.readFromPacketNBT(cmp);
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.supertile);
    }

    public String getUnlocalizedName() {
        return BotaniaAPI.getSubTileStringMapping(this.getClass());
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBlockModel() {
        return BotaniaAPI.internalHandler.getSubTileBlockModelForName(this.getUnlocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getItemModel() {
        return BotaniaAPI.internalHandler.getSubTileItemModelForName(this.getUnlocalizedName());
    }

    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        return false;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
    }

    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public List<ItemStack> getDrops(List<ItemStack> list) {
        return list;
    }

    public LexiconEntry getEntry() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getBinding() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public RadiusDescriptor getRadius() {
        return null;
    }

    public BlockPos toBlockPos() {
        return this.supertile.func_174877_v();
    }

    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
    }

    public int getLightValue() {
        return -1;
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public int getPowerLevel(EnumFacing side) {
        return 0;
    }

    public boolean isOvergrowthAffected() {
        return true;
    }

    public int getSlowdownFactor() {
        if (this.supertile instanceof ISubTileSlowableContainer) {
            ISubTileSlowableContainer slowable = (ISubTileSlowableContainer)this.supertile;
            return slowable.getSlowdownFactor();
        }
        return 0;
    }
}

