/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.botania.api.boss.IBotaniaBoss;
import vazkii.botania.api.boss.IBotaniaBossWithShader;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;

public final class BossBarHandler {
    public static final Set<IBotaniaBoss> bosses = new HashSet<IBotaniaBoss>();
    public static final ResourceLocation defaultBossBar = new ResourceLocation("botania:textures/gui/bossBar.png");
    private static final BarCallback barUniformCallback = new BarCallback();

    @SubscribeEvent
    public void onBarRender(RenderGameOverlayEvent.BossInfo evt) {
        UUID infoUuid = evt.getBossInfo().func_186737_d();
        for (IBotaniaBoss currentBoss : bosses) {
            if (!currentBoss.getBossInfoUuid().equals(infoUuid)) continue;
            evt.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            Rectangle bgRect = currentBoss.getBossBarTextureRect();
            Rectangle fgRect = currentBoss.getBossBarHPTextureRect();
            String name = evt.getBossInfo().func_186744_e().func_150254_d();
            int c = evt.getResolution().func_78326_a() / 2;
            int x = evt.getX();
            int y = evt.getY();
            int xf = x + (bgRect.width - fgRect.width) / 2;
            int yf = y + (bgRect.height - fgRect.height) / 2;
            int fw = (int)((double)fgRect.width * (double)evt.getBossInfo().func_186738_f());
            int tx = c - mc.field_71466_p.func_78256_a(name) / 2;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int auxHeight = currentBoss.bossBarRenderCallback(evt.getResolution(), x, y);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            mc.field_71446_o.func_110577_a(currentBoss.getBossBarTexture());
            BossBarHandler.drawBar(currentBoss, x, y, bgRect.x, bgRect.y, bgRect.width, bgRect.height, true);
            BossBarHandler.drawBar(currentBoss, xf, yf, fgRect.x, fgRect.y, fw, fgRect.height, false);
            mc.field_71466_p.func_175063_a(name, (float)tx, (float)(y - 10), 10617228);
            GlStateManager.func_179147_l();
            evt.setIncrement(Math.max(bgRect.height, fgRect.height) + auxHeight + mc.field_71466_p.field_78288_b);
        }
    }

    private static void drawBar(IBotaniaBoss currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
        boolean useShader = currentBoss instanceof IBotaniaBossWithShader;
        if (useShader) {
            IBotaniaBossWithShader shader = (IBotaniaBossWithShader)currentBoss;
            int program = shader.getBossBarShaderProgram(bg);
            ShaderCallback callback = program == 0 ? null : shader.getBossBarShaderCallback(bg, program);
            barUniformCallback.set(u, v, callback);
            ShaderHelper.useShader(program, barUniformCallback);
        }
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, u, v, w, h);
        if (useShader) {
            ShaderHelper.releaseShader();
        }
    }

    private static class BarCallback
    implements ShaderCallback {
        int x;
        int y;
        ShaderCallback callback;

        private BarCallback() {
        }

        @Override
        public void call(int shader) {
            int startXUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"startX");
            int startYUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"startY");
            ARBShaderObjects.glUniform1iARB((int)startXUniform, (int)this.x);
            ARBShaderObjects.glUniform1iARB((int)startYUniform, (int)this.y);
            if (this.callback != null) {
                this.callback.call(shader);
            }
        }

        void set(int x, int y, ShaderCallback callback) {
            this.x = x;
            this.y = y;
            this.callback = callback;
        }
    }
}

