/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.state.enums.SpreaderVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.BlockCamo;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCamo;
import vazkii.botania.common.item.IColorable;
import vazkii.botania.common.item.ModItems;

public final class ColorHandler {
    public static void init() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        Map map = (Map)ReflectionHelper.getPrivateValue(BlockColors.class, (Object)blocks, (String[])new String[]{"blockColorMap"});
        blocks.func_186722_a((IBlockColor)map.get(Blocks.field_150395_bd.delegate), new Block[]{ModBlocks.solidVines});
        blocks.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
                return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176768_e().field_76291_p;
            }
        }, new Block[]{ModBlocks.specialFlower, ModBlocks.manaBeacon, ModBlocks.petalBlock, ModBlocks.unstableBlock});
        blocks.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
                if (state.func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.FABULOUS) {
                    float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
                    return Color.getHSBColor(time * 0.005f, 0.6f, 1.0f).hashCode();
                }
                return 0xFFFFFF;
            }
        }, new Block[]{ModBlocks.pool});
        blocks.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
                if (state.func_177229_b(BotaniaStateProps.SPREADER_VARIANT) != SpreaderVariant.GAIA) {
                    return 0xFFFFFF;
                }
                float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
                return Color.getHSBColor(time * 5.0f % 360.0f / 360.0f, 0.4f, 0.9f).hashCode();
            }
        }, new Block[]{ModBlocks.spreader});
        blocks.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileCamo) {
                    TileCamo camo = (TileCamo)tile;
                    IBlockState camoState = camo.camoState;
                    if (camoState != null) {
                        return camoState.func_177230_c() instanceof BlockCamo ? 0xFFFFFF : Minecraft.func_71410_x().func_184125_al().func_186724_a(camoState, world, pos, tintIndex);
                    }
                }
                return 0xFFFFFF;
            }
        }, new Block[]{ModBlocks.platform});
        ItemColors items = Minecraft.func_71410_x().getItemColors();
        items.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                Item item = stack.func_77973_b();
                if (item instanceof IColorable) {
                    return ((IColorable)item).getColorFromItemStack(stack, tintIndex);
                }
                return 0xFFFFFF;
            }
        }, new Item[]{ModItems.manaResource, ModItems.twigWand, ModItems.dye, ModItems.petal, ModItems.manaGun, ModItems.manaMirror, ModItems.manaTablet, ModItems.signalFlare, ModItems.spellCloth, ModItems.brewFlask, ModItems.brewVial, ModItems.incenseStick, ModItems.bloodPendant, ModItems.enderDagger, ModItems.terraPick, ModItems.lens, Item.func_150898_a((Block)ModBlocks.manaBeacon), Item.func_150898_a((Block)ModBlocks.petalBlock), Item.func_150898_a((Block)ModBlocks.unstableBlock), Item.func_150898_a((Block)ModBlocks.pool), Item.func_150898_a((Block)ModBlocks.spreader)});
    }

    private ColorHandler() {
    }
}

