/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemsRemainingRenderHandler {
    private static int maxTicks = 30;
    private static int leaveTicks = 20;
    private static ItemStack stack;
    private static int ticks;
    private static int count;

    @SideOnly(value=Side.CLIENT)
    public static void render(ScaledResolution resolution, float partTicks) {
        if (ticks > 0 && stack != null) {
            int pos = maxTicks - ticks;
            Minecraft mc = Minecraft.func_71410_x();
            int x = resolution.func_78326_a() / 2 + 10 + Math.max(0, pos - leaveTicks);
            int y = resolution.func_78328_b() / 2;
            int start = maxTicks - leaveTicks;
            float alpha = (float)ticks + partTicks > (float)start ? 1.0f : ((float)ticks + partTicks) / (float)start;
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179091_B();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            RenderHelper.func_74520_c();
            int xp = x + (int)(16.0f * (1.0f - alpha));
            GlStateManager.func_179109_b((float)xp, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)alpha, (float)1.0f, (float)1.0f);
            mc.func_175599_af().func_180450_b(stack, 0, 0);
            GlStateManager.func_179152_a((float)(1.0f / alpha), (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-xp), (float)(-y), (float)0.0f);
            RenderHelper.func_74518_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            String text = TextFormatting.GREEN + stack.func_82833_r();
            if (count >= 0) {
                int max = stack.func_77976_d();
                int stacks = count / max;
                int rem = count % max;
                text = stacks == 0 ? "" + count : count + " (" + TextFormatting.AQUA + stacks + TextFormatting.RESET + "*" + TextFormatting.GRAY + max + TextFormatting.RESET + "+" + TextFormatting.YELLOW + rem + TextFormatting.RESET + ")";
            } else if (count == -1) {
                text = "\u221e";
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            mc.field_71466_p.func_175063_a(text, (float)(x + 20), (float)(y + 6), color);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void tick() {
        if (ticks > 0) {
            --ticks;
        }
    }

    public static void set(ItemStack stack, int count) {
        ItemsRemainingRenderHandler.stack = stack;
        ItemsRemainingRenderHandler.count = count;
        ticks = stack == null ? 0 : maxTicks;
    }

    public static void set(EntityPlayer player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !pattern.matcher(stack.func_77977_a()).find()) continue;
            count += stack.field_77994_a;
        }
        ItemsRemainingRenderHandler.set(displayStack, count);
    }
}

