/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.model.FloatingFlowerModel;
import vazkii.botania.client.model.LexiconModel;
import vazkii.botania.client.model.PlatformModel;
import vazkii.botania.common.integration.buildcraft.TriggerManaLevel;

public class MiscellaneousIcons {
    public static final MiscellaneousIcons INSTANCE = new MiscellaneousIcons();
    public TextureAtlasSprite alfPortalTex;
    public TextureAtlasSprite lightRelayWorldIcon;
    public TextureAtlasSprite lightRelayWorldIconRed;
    public TextureAtlasSprite alchemyCatalystOverlay;
    public TextureAtlasSprite conjurationCatalystOverlay;
    public TextureAtlasSprite enchanterOverlay;
    public TextureAtlasSprite manaVoidOverlay;
    public TextureAtlasSprite manaWater;
    public TextureAtlasSprite terraPlateOverlay;
    public TextureAtlasSprite corporeaWorldIcon;
    public TextureAtlasSprite corporeaWorldIconMaster;
    public TextureAtlasSprite corporeaIconStar;
    public TextureAtlasSprite sparkWorldIcon;
    public TextureAtlasSprite manaDetectorIcon;
    public TextureAtlasSprite runeAltarTriggerIcon;
    public TextureAtlasSprite terrasteelHelmWillIcon;
    public TextureAtlasSprite[] sparkUpgradeIcons;
    public TextureAtlasSprite[] kingKeyWeaponIcons;
    public Map<TriggerManaLevel.State, TextureAtlasSprite> manaLevelTriggerIcons = Maps.newEnumMap(TriggerManaLevel.State.class);
    public TextureAtlasSprite[] tiaraWingIcons;
    public TextureAtlasSprite tailIcon = null;
    public TextureAtlasSprite phiFlowerIcon = null;
    public TextureAtlasSprite goldfishIcon = null;
    public TextureAtlasSprite nerfBatIcon = null;
    public TextureAtlasSprite bloodPendantChain;
    public TextureAtlasSprite bloodPendantGem;
    public TextureAtlasSprite snowflakePendantGem;
    public TextureAtlasSprite itemFinderGem;
    public TextureAtlasSprite pyroclastGem;
    public TextureAtlasSprite crimsonGem;

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        evt.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("botania:miniIsland", "normal"), (Object)FloatingFlowerModel.INSTANCE);
        evt.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("botania:miniIsland", "inventory"), (Object)FloatingFlowerModel.INSTANCE);
        evt.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("botania:floatingSpecialFlower", "normal"), (Object)FloatingFlowerModel.INSTANCE);
        evt.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("botania:floatingSpecialFlower", "inventory"), (Object)FloatingFlowerModel.INSTANCE);
        evt.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("botania:platform", "normal"), (Object)new PlatformModel());
        evt.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("botania:lexicon", "inventory"), (Object)new LexiconModel());
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        int i;
        this.alfPortalTex = IconHelper.forName(evt.getMap(), "alfheimPortalInside", "blocks");
        this.lightRelayWorldIcon = IconHelper.forName(evt.getMap(), "lightRelay1", "blocks");
        this.lightRelayWorldIconRed = IconHelper.forName(evt.getMap(), "lightRelay3", "blocks");
        this.alchemyCatalystOverlay = IconHelper.forName(evt.getMap(), "alchemyCatalyst3", "blocks");
        this.conjurationCatalystOverlay = IconHelper.forName(evt.getMap(), "conjurationCatalyst3", "blocks");
        this.enchanterOverlay = IconHelper.forName(evt.getMap(), "enchanterOverlay", "blocks");
        this.manaVoidOverlay = IconHelper.forName(evt.getMap(), "manaVoid1", "blocks");
        this.manaWater = IconHelper.forName(evt.getMap(), "manaWater", "blocks");
        this.terraPlateOverlay = IconHelper.forName(evt.getMap(), "terraPlateOverlay", "blocks");
        this.corporeaWorldIcon = IconHelper.forName(evt.getMap(), "corporeaSpark1", "items");
        this.corporeaWorldIconMaster = IconHelper.forName(evt.getMap(), "corporeaSpark3", "items");
        this.corporeaIconStar = IconHelper.forName(evt.getMap(), "corporeaSparkStar", "items");
        this.sparkWorldIcon = IconHelper.forName(evt.getMap(), "spark1", "items");
        this.sparkUpgradeIcons = new TextureAtlasSprite[4];
        for (i = 0; i < 4; ++i) {
            this.sparkUpgradeIcons[i] = IconHelper.forName(evt.getMap(), "sparkUpgradeL" + i, "items");
        }
        this.tailIcon = IconHelper.forName(evt.getMap(), "tail", "items");
        this.phiFlowerIcon = IconHelper.forName(evt.getMap(), "phiFlower", "items");
        this.goldfishIcon = IconHelper.forName(evt.getMap(), "goldfish", "items");
        this.nerfBatIcon = IconHelper.forName(evt.getMap(), "nerfBat", "items");
        this.kingKeyWeaponIcons = new TextureAtlasSprite[12];
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponIcons[i] = IconHelper.forName(evt.getMap(), "gateWeapon" + i, "items");
        }
        this.manaDetectorIcon = IconHelper.forName(evt.getMap(), "triggers/manaDetector", "items");
        this.runeAltarTriggerIcon = IconHelper.forName(evt.getMap(), "triggers/runeAltarCanCraft", "items");
        for (TriggerManaLevel.State s : TriggerManaLevel.State.values()) {
            this.manaLevelTriggerIcons.put(s, IconHelper.forName(evt.getMap(), "triggers/mana" + WordUtils.capitalizeFully((String)s.name()), "items"));
        }
        this.tiaraWingIcons = new TextureAtlasSprite[9];
        for (int i2 = 0; i2 < this.tiaraWingIcons.length; ++i2) {
            this.tiaraWingIcons[i2] = IconHelper.forName(evt.getMap(), "flightTiara" + (i2 + 1), "items");
        }
        this.terrasteelHelmWillIcon = IconHelper.forName(evt.getMap(), "willFlame", "items");
        this.bloodPendantChain = IconHelper.forName(evt.getMap(), "bloodPendant2", "items");
        this.bloodPendantGem = IconHelper.forName(evt.getMap(), "bloodPendant3", "items");
        this.snowflakePendantGem = IconHelper.forName(evt.getMap(), "icePendantGem", "items");
        this.itemFinderGem = IconHelper.forName(evt.getMap(), "itemFinderGem", "items");
        this.pyroclastGem = IconHelper.forName(evt.getMap(), "lavaPendantGem", "items");
        this.crimsonGem = IconHelper.forName(evt.getMap(), "superLavaPendantGem", "items");
    }

    @SubscribeEvent
    public void dumpAtlas(ArrowLooseEvent evt) {
        if (!(evt.getEntityPlayer().field_70170_p.field_72995_K && ((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue() && evt.getEntityPlayer().func_70093_af())) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        FMLLog.info((String)"[Botania]: Dumped atlas %d wide by %d tall%n", (Object[])new Object[]{width, height});
        int pixels = width * height;
        IntBuffer buffer = BufferUtils.createIntBuffer((int)pixels);
        int[] pixelValues = new int[pixels];
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        buffer.get(pixelValues);
        BufferedImage bufferedimage = new BufferedImage(width, height, 2);
        for (int k = 0; k < height; ++k) {
            for (int l = 0; l < width; ++l) {
                bufferedimage.setRGB(l, k, pixelValues[k * width + l]);
            }
        }
        File mcFolder = Minecraft.func_71410_x().field_71412_D;
        File result = new File(mcFolder, "atlas.png");
        try {
            ImageIO.write((RenderedImage)bufferedimage, "png", result);
        }
        catch (IOException e) {
            FMLLog.warning((String)"[Botania]: Failed to dump debug atlas", (Object[])new Object[0]);
        }
    }

    private MiscellaneousIcons() {
    }
}

