/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.api.state.enums.BiomeBrickVariant;
import vazkii.botania.api.state.enums.BiomeStoneVariant;
import vazkii.botania.api.state.enums.CrateVariant;
import vazkii.botania.api.state.enums.CustomBrickVariant;
import vazkii.botania.api.state.enums.DrumVariant;
import vazkii.botania.api.state.enums.EndBrickVariant;
import vazkii.botania.api.state.enums.FutureStoneVariant;
import vazkii.botania.api.state.enums.LivingRockVariant;
import vazkii.botania.api.state.enums.LivingWoodVariant;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.state.enums.PlatformVariant;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.state.enums.PrismarineVariant;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.api.state.enums.SpreaderVariant;
import vazkii.botania.api.state.enums.StorageVariant;
import vazkii.botania.client.model.FloatingFlowerModel;
import vazkii.botania.client.model.SpecialFlowerModel;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.slabs.BlockModSlab;
import vazkii.botania.common.block.subtile.SubTileDecor;
import vazkii.botania.common.block.subtile.SubTileManastar;
import vazkii.botania.common.block.subtile.SubTilePureDaisy;
import vazkii.botania.common.block.subtile.functional.SubTileAgricarnation;
import vazkii.botania.common.block.subtile.functional.SubTileBellethorn;
import vazkii.botania.common.block.subtile.functional.SubTileBubbell;
import vazkii.botania.common.block.subtile.functional.SubTileClayconia;
import vazkii.botania.common.block.subtile.functional.SubTileDaffomill;
import vazkii.botania.common.block.subtile.functional.SubTileDreadthorn;
import vazkii.botania.common.block.subtile.functional.SubTileExoflame;
import vazkii.botania.common.block.subtile.functional.SubTileFallenKanade;
import vazkii.botania.common.block.subtile.functional.SubTileHeiseiDream;
import vazkii.botania.common.block.subtile.functional.SubTileHopperhock;
import vazkii.botania.common.block.subtile.functional.SubTileHyacidus;
import vazkii.botania.common.block.subtile.functional.SubTileJadedAmaranthus;
import vazkii.botania.common.block.subtile.functional.SubTileJiyuulia;
import vazkii.botania.common.block.subtile.functional.SubTileLoonuim;
import vazkii.botania.common.block.subtile.functional.SubTileMarimorphosis;
import vazkii.botania.common.block.subtile.functional.SubTileMedumone;
import vazkii.botania.common.block.subtile.functional.SubTileOrechid;
import vazkii.botania.common.block.subtile.functional.SubTileOrechidIgnem;
import vazkii.botania.common.block.subtile.functional.SubTilePollidisiac;
import vazkii.botania.common.block.subtile.functional.SubTileRannuncarpus;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.block.subtile.functional.SubTileTangleberrie;
import vazkii.botania.common.block.subtile.functional.SubTileTigerseye;
import vazkii.botania.common.block.subtile.functional.SubTileVinculotus;
import vazkii.botania.common.block.subtile.generating.SubTileArcaneRose;
import vazkii.botania.common.block.subtile.generating.SubTileDandelifeon;
import vazkii.botania.common.block.subtile.generating.SubTileDaybloom;
import vazkii.botania.common.block.subtile.generating.SubTileEndoflame;
import vazkii.botania.common.block.subtile.generating.SubTileEntropinnyum;
import vazkii.botania.common.block.subtile.generating.SubTileGourmaryllis;
import vazkii.botania.common.block.subtile.generating.SubTileHydroangeas;
import vazkii.botania.common.block.subtile.generating.SubTileKekimurus;
import vazkii.botania.common.block.subtile.generating.SubTileMunchdew;
import vazkii.botania.common.block.subtile.generating.SubTileNarslimmus;
import vazkii.botania.common.block.subtile.generating.SubTileNightshade;
import vazkii.botania.common.block.subtile.generating.SubTileRafflowsia;
import vazkii.botania.common.block.subtile.generating.SubTileSpectrolus;
import vazkii.botania.common.block.subtile.generating.SubTileThermalily;
import vazkii.botania.common.block.tile.TileAvatar;
import vazkii.botania.common.block.tile.TileBrewery;
import vazkii.botania.common.block.tile.TileGaiaHead;
import vazkii.botania.common.block.tile.TileHourglass;
import vazkii.botania.common.block.tile.TileTeruTeruBozu;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TileBellows;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.relic.ItemInfiniteFruit;
import vazkii.botania.common.lib.LibItemNames;

public final class ModelHandler {
    public static void registerModels() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)SpecialFlowerModel.Loader.INSTANCE);
        OBJLoader.INSTANCE.addDomain("Botania".toLowerCase(Locale.ROOT));
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)FloatingFlowerModel.INSTANCE);
        ModelHandler.registerSubtiles();
        ModelHandler.registerStateMappers();
        ModelHandler.registerStandardBlocks();
        ModelHandler.registerMushrooms();
        ModelHandler.registerFlowers();
        ModelHandler.registerPavement();
        ModelHandler.registerStairs();
        ModelHandler.registerSlabs();
        ModelHandler.registerWalls();
        ModelHandler.registerPanes();
        ModelHandler.registerAltars();
        ModelHandler.registerQuartzBlocks();
        ModelHandler.registerLuminizers();
        ModelHandler.registerStandardItems();
        ModelHandler.registerTESRItems();
        ModelHandler.registerManaResources();
        ModelHandler.registerRunes();
        ModelHandler.registerLens();
        ModelHandler.registerBrews();
        ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)ModBlocks.pool), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:pool", "variant=default"), new ModelResourceLocation("botania:pool", "variant=diluted"), new ModelResourceLocation("botania:pool", "variant=creative"), new ModelResourceLocation("botania:pool", "variant=fabulous"), new ModelResourceLocation("botania:pool", "default_full"), new ModelResourceLocation("botania:pool", "diluted_full"), new ModelResourceLocation("botania:pool", "creative_full"), new ModelResourceLocation("botania:pool", "fabulous_full")});
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)ModBlocks.pool), (ItemMeshDefinition)MesherWrapper.of(stack -> {
            PoolVariant v;
            int meta = stack.func_77960_j();
            if (meta < 0 || meta > 3) {
                meta = 0;
            }
            boolean renderFull = (v = PoolVariant.values()[meta]) == PoolVariant.CREATIVE || stack.func_77942_o() && stack.func_77978_p().func_74767_n("RenderFull");
            return new ModelResourceLocation("botania:pool", renderFull ? v.func_176610_l() + "_full" : "variant=" + v.func_176610_l());
        }));
        ModelLoader.registerItemVariants((Item)ModItems.elementiumShears, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:elementiumShears", "inventory"), new ModelResourceLocation("botania:dammitReddit", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.elementiumShears, (ItemMeshDefinition)MesherWrapper.of(stack -> stack.func_82833_r().equalsIgnoreCase("dammit reddit") ? new ModelResourceLocation("botania:dammitReddit", "inventory") : new ModelResourceLocation("botania:elementiumShears", "inventory")));
        ModelLoader.registerItemVariants((Item)ModItems.grassHorn, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:grassHorn0", "inventory"), new ModelResourceLocation("botania:grassHorn1", "inventory"), new ModelResourceLocation("botania:grassHorn2", "inventory"), new ModelResourceLocation("botania:vuvuzela", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.grassHorn, (ItemMeshDefinition)MesherWrapper.of(stack -> stack.func_82833_r().toLowerCase().contains("vuvuzela") ? new ModelResourceLocation("botania:vuvuzela", "inventory") : new ModelResourceLocation("botania:grassHorn" + stack.func_77960_j(), "inventory")));
        ModelLoader.registerItemVariants((Item)ModItems.infiniteFruit, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:infiniteFruit", "inventory"), new ModelResourceLocation("botania:infiniteFruitBoot", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infiniteFruit, (ItemMeshDefinition)MesherWrapper.of(stack -> ItemInfiniteFruit.isBoot(stack) ? new ModelResourceLocation("botania:infiniteFruitBoot", "inventory") : new ModelResourceLocation("botania:infiniteFruit", "inventory")));
        ModelLoader.registerItemVariants((Item)ModItems.manaCookie, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:manaCookie", "inventory"), new ModelResourceLocation("botania:totalBiscuit", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manaCookie, (ItemMeshDefinition)MesherWrapper.of(stack -> stack.func_82833_r().toLowerCase().equals("totalbiscuit") ? new ModelResourceLocation("botania:totalBiscuit", "inventory") : new ModelResourceLocation("botania:manaCookie", "inventory")));
    }

    private static void registerSubtiles() {
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.GRASS, new ModelResourceLocation("botania:miniIsland", "variant=grass"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.PODZOL, new ModelResourceLocation("botania:miniIsland", "variant=podzol"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.MYCEL, new ModelResourceLocation("botania:miniIsland", "variant=mycel"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.SNOW, new ModelResourceLocation("botania:miniIsland", "variant=snow"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.DRY, new ModelResourceLocation("botania:miniIsland", "variant=dry"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.GOLDEN, new ModelResourceLocation("botania:miniIsland", "variant=golden"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.VIVID, new ModelResourceLocation("botania:miniIsland", "variant=vivid"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.SCORCHED, new ModelResourceLocation("botania:miniIsland", "variant=scorched"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.INFUSED, new ModelResourceLocation("botania:miniIsland", "variant=infused"));
        BotaniaAPIClient.registerIslandTypeModel(IFloatingFlower.IslandType.MUTATED, new ModelResourceLocation("botania:miniIsland", "variant=mutated"));
        BotaniaAPIClient.registerSubtileModel(SubTileManastar.class, new ModelResourceLocation("botania:manastar"));
        BotaniaAPIClient.registerSubtileModel(SubTilePureDaisy.class, new ModelResourceLocation("botania:puredaisy"));
        BotaniaAPIClient.registerSubtileModel(SubTileDaybloom.class, new ModelResourceLocation("botania:daybloom"));
        BotaniaAPIClient.registerSubtileModel(SubTileDecor.Daybloom.class, new ModelResourceLocation("botania:daybloomDecor"));
        BotaniaAPIClient.registerSubtileModel(SubTileDaybloom.Prime.class, new ModelResourceLocation("botania:daybloomPrime"));
        BotaniaAPIClient.registerSubtileModel(SubTileEndoflame.class, new ModelResourceLocation("botania:endoflame"));
        BotaniaAPIClient.registerSubtileModel(SubTileHydroangeas.class, new ModelResourceLocation("botania:hydroangeas"));
        BotaniaAPIClient.registerSubtileModel(SubTileDecor.Hydroangeas.class, new ModelResourceLocation("botania:hydroangeasDecor"));
        BotaniaAPIClient.registerSubtileModel(SubTileThermalily.class, new ModelResourceLocation("botania:thermalily"));
        BotaniaAPIClient.registerSubtileModel(SubTileNightshade.class, new ModelResourceLocation("botania:nightshade"));
        BotaniaAPIClient.registerSubtileModel(SubTileDecor.Nightshade.class, new ModelResourceLocation("botania:nightshadeDecor"));
        BotaniaAPIClient.registerSubtileModel(SubTileNightshade.Prime.class, new ModelResourceLocation("botania:nightshadePrime"));
        BotaniaAPIClient.registerSubtileModel(SubTileArcaneRose.class, new ModelResourceLocation("botania:arcanerose"));
        BotaniaAPIClient.registerSubtileModel(SubTileMunchdew.class, new ModelResourceLocation("botania:munchdew"));
        BotaniaAPIClient.registerSubtileModel(SubTileEntropinnyum.class, new ModelResourceLocation("botania:entropinnyum"));
        BotaniaAPIClient.registerSubtileModel(SubTileKekimurus.class, new ModelResourceLocation("botania:kekimurus"));
        BotaniaAPIClient.registerSubtileModel(SubTileGourmaryllis.class, new ModelResourceLocation("botania:gourmaryllis"));
        BotaniaAPIClient.registerSubtileModel(SubTileNarslimmus.class, new ModelResourceLocation("botania:narslimmus"));
        BotaniaAPIClient.registerSubtileModel(SubTileSpectrolus.class, new ModelResourceLocation("botania:spectrolus"));
        BotaniaAPIClient.registerSubtileModel(SubTileDandelifeon.class, new ModelResourceLocation("botania:dandelifeon"));
        BotaniaAPIClient.registerSubtileModel(SubTileRafflowsia.class, new ModelResourceLocation("botania:rafflowsia"));
        BotaniaAPIClient.registerSubtileModel(SubTileBellethorn.class, new ModelResourceLocation("botania:bellethorn"));
        BotaniaAPIClient.registerSubtileModel(SubTileBellethorn.Mini.class, new ModelResourceLocation("botania:bellethornChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileDreadthorn.class, new ModelResourceLocation("botania:dreadthorn"));
        BotaniaAPIClient.registerSubtileModel(SubTileHeiseiDream.class, new ModelResourceLocation("botania:heiseiDream"));
        BotaniaAPIClient.registerSubtileModel(SubTileTigerseye.class, new ModelResourceLocation("botania:tigerseye"));
        BotaniaAPIClient.registerSubtileModel(SubTileJadedAmaranthus.class, new ModelResourceLocation("botania:jadedAmaranthus"));
        BotaniaAPIClient.registerSubtileModel(SubTileOrechid.class, new ModelResourceLocation("botania:orechid"));
        BotaniaAPIClient.registerSubtileModel(SubTileOrechidIgnem.class, new ModelResourceLocation("botania:orechidIgnem"));
        BotaniaAPIClient.registerSubtileModel(SubTileFallenKanade.class, new ModelResourceLocation("botania:fallenKanade"));
        BotaniaAPIClient.registerSubtileModel(SubTileExoflame.class, new ModelResourceLocation("botania:exoflame"));
        BotaniaAPIClient.registerSubtileModel(SubTileAgricarnation.class, new ModelResourceLocation("botania:agricarnation"));
        BotaniaAPIClient.registerSubtileModel(SubTileAgricarnation.Mini.class, new ModelResourceLocation("botania:agricarnationChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileHopperhock.class, new ModelResourceLocation("botania:hopperhock"));
        BotaniaAPIClient.registerSubtileModel(SubTileHopperhock.Mini.class, new ModelResourceLocation("botania:hopperhockChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileTangleberrie.class, new ModelResourceLocation("botania:tangleberrie"));
        BotaniaAPIClient.registerSubtileModel(SubTileJiyuulia.class, new ModelResourceLocation("botania:jiyuulia"));
        BotaniaAPIClient.registerSubtileModel(SubTileRannuncarpus.class, new ModelResourceLocation("botania:rannuncarpus"));
        BotaniaAPIClient.registerSubtileModel(SubTileRannuncarpus.Mini.class, new ModelResourceLocation("botania:rannuncarpusChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileHyacidus.class, new ModelResourceLocation("botania:hyacidus"));
        BotaniaAPIClient.registerSubtileModel(SubTilePollidisiac.class, new ModelResourceLocation("botania:pollidisiac"));
        BotaniaAPIClient.registerSubtileModel(SubTileClayconia.class, new ModelResourceLocation("botania:clayconia"));
        BotaniaAPIClient.registerSubtileModel(SubTileClayconia.Mini.class, new ModelResourceLocation("botania:clayconiaChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileLoonuim.class, new ModelResourceLocation("botania:loonium"));
        BotaniaAPIClient.registerSubtileModel(SubTileDaffomill.class, new ModelResourceLocation("botania:daffomill"));
        BotaniaAPIClient.registerSubtileModel(SubTileVinculotus.class, new ModelResourceLocation("botania:vinculotus"));
        BotaniaAPIClient.registerSubtileModel(SubTileSpectranthemum.class, new ModelResourceLocation("botania:spectranthemum"));
        BotaniaAPIClient.registerSubtileModel(SubTileMedumone.class, new ModelResourceLocation("botania:medumone"));
        BotaniaAPIClient.registerSubtileModel(SubTileMarimorphosis.class, new ModelResourceLocation("botania:marimorphosis"));
        BotaniaAPIClient.registerSubtileModel(SubTileMarimorphosis.Mini.class, new ModelResourceLocation("botania:marimorphosisChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileBubbell.class, new ModelResourceLocation("botania:bubbell"));
        BotaniaAPIClient.registerSubtileModel(SubTileBubbell.Mini.class, new ModelResourceLocation("botania:bubbellChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileSolegnolia.class, new ModelResourceLocation("botania:solegnolia"));
        BotaniaAPIClient.registerSubtileModel(SubTileSolegnolia.Mini.class, new ModelResourceLocation("botania:solegnoliaChibi"));
    }

    private static void registerStandardBlocks() {
        ModelHandler.registerItemModel(ModBlocks.alchemyCatalyst);
        ModelHandler.registerItemModel(ModBlocks.alfPortal);
        ModelHandler.registerItemModel(ModBlocks.bifrost);
        ModelHandler.registerItemModel(ModBlocks.bifrostPerm);
        ModelHandler.registerItemModel(ModBlocks.blazeBlock);
        ModelHandler.registerItemModel(ModBlocks.cacophonium);
        ModelHandler.registerItemModel(ModBlocks.cellBlock);
        ModelHandler.registerItemModel(ModBlocks.conjurationCatalyst);
        ModelHandler.registerItemModel(ModBlocks.cocoon);
        ModelHandler.registerItemModel(ModBlocks.corporeaFunnel);
        ModelHandler.registerItemModel(ModBlocks.corporeaInterceptor);
        ModelHandler.registerItemModel(ModBlocks.corporeaRetainer);
        ModelHandler.registerItemModel(ModBlocks.dirtPath);
        ModelHandler.registerItemModel(ModBlocks.distributor);
        ModelHandler.registerItemModel(ModBlocks.elfGlass);
        ModelHandler.registerItemModel(ModBlocks.enchantedSoil);
        ModelHandler.registerItemModel(ModBlocks.enchanter);
        ModelHandler.registerItemModel(ModBlocks.enderEye);
        ModelHandler.registerItemModel(ModBlocks.felPumpkin);
        ModelHandler.registerItemModel(ModBlocks.floatingSpecialFlower);
        ModelHandler.registerItemModel(ModBlocks.forestEye);
        ModelHandler.registerItemModel(ModBlocks.ghostRail);
        ModelHandler.registerItemModel(ModBlocks.incensePlate);
        ModelHandler.registerItemModel(ModBlocks.lightLauncher);
        ModelHandler.registerItemModel(ModBlocks.manaBomb);
        ModelHandler.registerItemModel(ModBlocks.manaDetector);
        ModelHandler.registerItemModel(ModBlocks.manaFlame);
        ModelHandler.registerItemModel(ModBlocks.manaGlass);
        ModelHandler.registerItemModel(ModBlocks.manaVoid);
        ModelHandler.registerItemModel(ModBlocks.prism);
        ModelHandler.registerItemModel(ModBlocks.pistonRelay);
        ModelHandler.registerItemModel(ModBlocks.pump);
        ModelHandler.registerItemModel(ModBlocks.redStringComparator);
        ModelHandler.registerItemModel(ModBlocks.redStringContainer);
        ModelHandler.registerItemModel(ModBlocks.redStringDispenser);
        ModelHandler.registerItemModel(ModBlocks.redStringFertilizer);
        ModelHandler.registerItemModel(ModBlocks.redStringInterceptor);
        ModelHandler.registerItemModel(ModBlocks.redStringRelay);
        ModelHandler.registerItemModel(ModBlocks.reedBlock);
        ModelHandler.registerItemModel(ModBlocks.rfGenerator);
        ModelHandler.registerItemModel(ModBlocks.root);
        ModelHandler.registerItemModel(ModBlocks.runeAltar);
        ModelHandler.registerItemModel(ModBlocks.seaLamp);
        ModelHandler.registerItemModel(ModBlocks.shimmerrock);
        ModelHandler.registerItemModel(ModBlocks.shimmerwoodPlanks);
        ModelHandler.registerItemModel(ModBlocks.sparkChanger);
        ModelHandler.registerItemModel(ModBlocks.spawnerClaw);
        ModelHandler.registerItemModel(ModBlocks.specialFlower);
        ModelHandler.registerItemModel(ModBlocks.starfield);
        ModelHandler.registerItemModel(ModBlocks.thatch);
        ModelHandler.registerItemModel(ModBlocks.terraPlate);
        ModelHandler.registerItemModel(ModBlocks.tinyPlanet);
        ModelHandler.registerItemModel(ModBlocks.tinyPotato);
        ModelHandler.registerItemModel(ModBlocks.turntable);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.floatingFlower), EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.manaBeacon), EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.petalBlock), EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.unstableBlock), EnumDyeColor.values().length);
        ModelHandler.registerVariantsDefaulted(ModBlocks.pylon, PylonVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.altGrass, AltGrassVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModFluffBlocks.biomeStoneA, BiomeStoneVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModFluffBlocks.biomeStoneB, BiomeBrickVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.customBrick, CustomBrickVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.endStoneBrick, EndBrickVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.dreamwood, LivingWoodVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.forestDrum, DrumVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.livingrock, LivingRockVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.livingwood, LivingWoodVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.openCrate, CrateVariant.class, "pattern=none,variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.platform, PlatformVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.prismarine, PrismarineVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.spreader, SpreaderVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModFluffBlocks.stone, FutureStoneVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.storage, StorageVariant.class, "variant");
    }

    private static void registerStandardItems() {
        ModelHandler.registerItemModel(ModItems.manasteelSword);
        ModelHandler.registerItemModel(ModItems.spawnerMover);
        ModelHandler.registerItemModel(ModItems.terraPick);
        ModelHandler.registerItemModel(ModItems.magnetRing);
        ModelHandler.registerItemModel(ModItems.magnetRingGreater);
        ModelHandler.registerItemModel(ModItems.manaGun);
        ModelHandler.registerItemModel(ModItems.tornadoRod);
        ModelHandler.registerItemModel(ModItems.twigWand);
        ModelHandler.registerItemModel(ModItems.pestleAndMortar);
        ModelHandler.registerItemModel(ModItems.blackLotus);
        ModelHandler.registerItemModel(ModItems.blackLotus, 1);
        ModelLoader.registerItemVariants((Item)ModItems.lexicon, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:lexicon_default", "inventory")});
        ModelHandler.registerItemModel(ModItems.lexicon);
        ModelHandler.registerItemModel(ModItems.manasteelHelm);
        ModelHandler.registerItemModel(ModItems.manasteelHelmRevealing);
        ModelHandler.registerItemModel(ModItems.manasteelChest);
        ModelHandler.registerItemModel(ModItems.manasteelLegs);
        ModelHandler.registerItemModel(ModItems.manasteelBoots);
        ModelHandler.registerItemModel(ModItems.manasteelPick);
        ModelHandler.registerItemModel(ModItems.manasteelShovel);
        ModelHandler.registerItemModel(ModItems.manasteelAxe);
        ModelHandler.registerItemModel(ModItems.manasteelShears);
        ModelHandler.registerItemModel(ModItems.manaweaveHelm);
        ModelHandler.registerItemModel(ModItems.manaweaveChest);
        ModelHandler.registerItemModel(ModItems.manaweaveLegs);
        ModelHandler.registerItemModel(ModItems.manaweaveBoots);
        ModelHandler.registerItemModel(ModItems.elementiumHelm);
        ModelHandler.registerItemModel(ModItems.elementiumHelmRevealing);
        ModelHandler.registerItemModel(ModItems.elementiumChest);
        ModelHandler.registerItemModel(ModItems.elementiumLegs);
        ModelHandler.registerItemModel(ModItems.elementiumBoots);
        ModelHandler.registerItemModel(ModItems.elementiumPick);
        ModelHandler.registerItemModel(ModItems.elementiumShovel);
        ModelHandler.registerItemModel(ModItems.elementiumAxe);
        ModelHandler.registerItemModel(ModItems.elementiumSword);
        ModelHandler.registerItemModel(ModItems.terrasteelHelm);
        ModelHandler.registerItemModel(ModItems.terrasteelHelmRevealing);
        ModelHandler.registerItemModel(ModItems.terrasteelChest);
        ModelHandler.registerItemModel(ModItems.terrasteelLegs);
        ModelHandler.registerItemModel(ModItems.terrasteelBoots);
        ModelHandler.registerItemModel(ModItems.terraSword);
        ModelHandler.registerItemModelMetas(ModItems.terraAxe, "terraAxe", 2);
        ModelHandler.registerItemModel(ModItems.starSword);
        ModelHandler.registerItemModel(ModItems.thunderSword);
        ModelHandler.registerItemModel(ModItems.crystalBow);
        ModelHandler.registerItemModel(ModItems.livingwoodBow);
        ModelHandler.registerItemModel(ModItems.glassPick);
        ModelHandler.registerItemModel(ModItems.flowerBag);
        ModelHandler.registerItemModel(ModItems.fertilizer);
        ModelHandler.registerItemModel(ModItems.obedienceStick);
        ModelHandler.registerItemModel(ModItems.dirtRod);
        ModelHandler.registerItemModel(ModItems.waterRod);
        ModelHandler.registerItemModel(ModItems.cobbleRod);
        ModelHandler.registerItemModel(ModItems.fireRod);
        ModelHandler.registerItemModel(ModItems.rainbowRod);
        ModelHandler.registerItemModel(ModItems.skyDirtRod);
        ModelHandler.registerItemModel(ModItems.terraformRod);
        ModelHandler.registerItemModel(ModItems.diviningRod);
        ModelHandler.registerItemModel(ModItems.gravityRod);
        ModelHandler.registerItemModel(ModItems.missileRod);
        ModelHandler.registerItemModel(ModItems.smeltRod);
        ModelHandler.registerItemModel(ModItems.exchangeRod);
        ModelHandler.registerItemModel(ModItems.openBucket);
        ModelHandler.registerItemModel(ModItems.bloodPendant);
        ModelHandler.registerItemModel(ModItems.manaTablet);
        ModelHandler.registerItemModel(ModItems.enderDagger);
        ModelHandler.registerItemModel(ModItems.slingshot);
        ModelHandler.registerItemModel(ModItems.vineBall);
        ModelHandler.registerItemModel(ModItems.regenIvy);
        ModelHandler.registerItemModel(ModItems.keepIvy);
        ModelHandler.registerItemModel(ModItems.recordGaia1);
        ModelHandler.registerItemModel(ModItems.recordGaia2);
        ModelHandler.registerItemModel(ModItems.overgrowthSeed);
        ModelHandler.registerItemModel(ModItems.worldSeed);
        ModelHandler.registerItemModel(ModItems.incenseStick);
        ModelHandler.registerItemModel(ModItems.enderHand);
        ModelHandler.registerItemModel(ModItems.craftingHalo);
        ModelHandler.registerItemModel(ModItems.spellCloth);
        ModelHandler.registerItemModel(ModItems.autocraftingHalo);
        ModelHandler.registerItemModel(ModItems.sextant);
        ModelHandler.registerItemModel(ModItems.cacophonium);
        ModelHandler.registerItemModel(ModItems.clip);
        ModelHandler.registerItemModel(ModItems.phantomInk);
        ModelHandler.registerItemModel(ModItems.poolMinecart);
        ModelHandler.registerItemModel(ModItems.pinkinator);
        ModelHandler.registerItemModel(ModItems.dice);
        ModelHandler.registerItemModel(ModItems.kingKey);
        ModelHandler.registerItemModel(ModItems.flugelEye);
        ModelHandler.registerItemModel(ModItems.thorRing);
        ModelHandler.registerItemModel(ModItems.lokiRing);
        ModelHandler.registerItemModel(ModItems.odinRing);
        ModelHandler.registerItemModel(ModItems.aesirRing);
        ModelHandler.registerItemModel(ModItems.baubleBox);
        ModelHandler.registerItemModel(ModItems.tinyPlanet);
        ModelHandler.registerItemModel(ModItems.manaRing);
        ModelHandler.registerItemModel(ModItems.manaRingGreater);
        ModelHandler.registerItemModel(ModItems.auraRing);
        ModelHandler.registerItemModel(ModItems.auraRingGreater);
        ModelHandler.registerItemModel(ModItems.spark);
        ModelHandler.registerItemModel(ModItems.waterRing);
        ModelHandler.registerItemModel(ModItems.miningRing);
        ModelHandler.registerItemModel(ModItems.reachRing);
        ModelHandler.registerItemModel(ModItems.swapRing);
        ModelHandler.registerItemModel(ModItems.pixieRing);
        ModelHandler.registerItemModel(ModItems.travelBelt);
        ModelHandler.registerItemModel(ModItems.superTravelBelt);
        ModelHandler.registerItemModel(ModItems.speedUpBelt);
        ModelHandler.registerItemModel(ModItems.knockbackBelt);
        ModelHandler.registerItemModel(ModItems.itemFinder);
        ModelHandler.registerItemModel(ModItems.monocle);
        ModelHandler.registerItemModel(ModItems.icePendant);
        ModelHandler.registerItemModel(ModItems.lavaPendant);
        ModelHandler.registerItemModel(ModItems.superLavaPendant);
        ModelHandler.registerItemModel(ModItems.holyCloak);
        ModelHandler.registerItemModel(ModItems.unholyCloak);
        ModelHandler.registerItemModel(ModItems.goldLaurel);
        ModelHandler.registerItemModel(ModItems.flightTiara);
        ModelHandler.registerItemModel(ModItems.divaCharm);
        ModelHandler.registerItemModel(ModItems.manaMirror);
        ModelHandler.registerItemModel(ModItems.manaInkwell);
        ModelHandler.registerItemModel(ModItems.waterBowl);
        ModelHandler.registerItemModelAllMeta(ModItems.flightTiara, 9);
        ModelHandler.registerItemModelAllMeta(ModItems.laputaShard, 20);
        ModelHandler.registerItemModelAllMeta(ModItems.signalFlare, EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(ModItems.dye, EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(ModItems.petal, EnumDyeColor.values().length);
        ModelHandler.registerItemModelMetas(ModItems.sparkUpgrade, "sparkUpgrade", 4);
        ModelHandler.registerItemModelMetas(ModItems.corporeaSpark, "corporeaSpark", 2);
        ModelHandler.registerItemModelMetas(ModItems.manaBottle, "manaBottle", 6);
        ModelHandler.registerItemModelMetas(ModItems.ancientWill, "ancientWill", 6);
        ModelHandler.registerItemModelMetas(ModItems.temperanceStone, "temperanceStone", 2);
        ModelHandler.registerItemModelMetas(ModItems.thornChakram, "thornChakram", 2);
        ModelHandler.registerItemModelMetas(ModItems.blackHoleTalisman, "blackHoleTalisman", 2);
        ModelHandler.registerItemModelMetas(ModItems.slimeBottle, "slimeBottle", 2);
        ModelHandler.registerItemModelMetas(ModItems.grassSeeds, "grassSeeds", 9);
        ModelHandler.registerItemModelMetas(ModItems.quartz, "quartz", 7);
        ModelHandler.registerItemModelMetas(ModItems.cosmetic, "cosmetic", 32);
        ModelHandler.registerItemModelMetas(ModItems.craftPattern, "craftPattern", 9);
        ModelHandler.registerItemModelMetas(ModItems.virus, "virus", 2);
    }

    private static void registerTESRItems() {
        ModelHandler.registerItemModel(ModBlocks.avatar);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.avatar), (int)0, TileAvatar.class);
        ModelHandler.registerItemModel(ModBlocks.bellows);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.bellows), (int)0, TileBellows.class);
        ModelHandler.registerItemModel(ModBlocks.brewery);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.brewery), (int)0, TileBrewery.class);
        ModelHandler.registerItemModel(ModBlocks.corporeaCrystalCube);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.corporeaCrystalCube), (int)0, TileCorporeaCrystalCube.class);
        ModelHandler.registerItemModel(ModBlocks.corporeaIndex);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.corporeaIndex), (int)0, TileCorporeaIndex.class);
        ModelHandler.registerItemModel(ModItems.gaiaHead);
        ForgeHooksClient.registerTESRItemStack((Item)ModItems.gaiaHead, (int)0, TileGaiaHead.class);
        ModelHandler.registerItemModel(ModBlocks.hourglass);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.hourglass), (int)0, TileHourglass.class);
        ModelHandler.registerItemModel(ModBlocks.teruTeruBozu);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.teruTeruBozu), (int)0, TileTeruTeruBozu.class);
    }

    private static void registerManaResources() {
        Item item = ModItems.manaResource;
        for (int i = 0; i < LibItemNames.MANA_RESOURCE_NAMES.length; ++i) {
            String name = "botania:" + LibItemNames.MANA_RESOURCE_NAMES[i];
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    private static void registerRunes() {
        ImmutableList variantNames = ImmutableList.of((Object)"water", (Object)"fire", (Object)"earth", (Object)"air", (Object)"spring", (Object)"summer", (Object)"autumn", (Object)"winter", (Object)"mana", (Object)"lust", (Object)"gluttony", (Object)"greed", (Object[])new String[]{"sloth", "wrath", "envy", "pride"});
        for (int i = 0; i < variantNames.size(); ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.rune, (int)i, (ModelResourceLocation)new ModelResourceLocation("botania:rune_" + (String)variantNames.get(i), "inventory"));
        }
    }

    private static void registerLens() {
        int counter = 0;
        for (String s : LibItemNames.LENS_NAMES) {
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.lens, (int)counter++, (ModelResourceLocation)new ModelResourceLocation("botania:" + s, "inventory"));
        }
    }

    private static void registerBrews() {
        int i;
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.vial, (int)0, (ModelResourceLocation)new ModelResourceLocation("botania:vial", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.vial, (int)1, (ModelResourceLocation)new ModelResourceLocation("botania:flask", "inventory"));
        for (i = 0; i < 6; ++i) {
            ModelLoader.registerItemVariants((Item)ModItems.brewFlask, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:flask1_" + i, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)ModItems.brewFlask, (ItemMeshDefinition)MesherWrapper.of(stack -> {
            int swigsTaken = 6 - ((ItemBrewBase)ModItems.brewFlask).getSwigsLeft(stack);
            return new ModelResourceLocation("botania:flask1_" + swigsTaken, "inventory");
        }));
        for (i = 0; i < 4; ++i) {
            ModelLoader.registerItemVariants((Item)ModItems.brewVial, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:vial1_" + i, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)ModItems.brewVial, (ItemMeshDefinition)MesherWrapper.of(stack -> {
            int swigsTaken = 4 - ((ItemBrewBase)ModItems.brewVial).getSwigsLeft(stack);
            return new ModelResourceLocation("botania:vial1_" + swigsTaken, "inventory");
        }));
    }

    private static void registerStateMappers() {
        ModelLoader.setCustomStateMapper((Block)ModBlocks.specialFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.specialFlower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.floatingSpecialFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.floatingFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.platform, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.PLATFORM_VARIANT}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.doubleFlower1, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoublePlant.field_176493_a, BlockDoublePlant.field_181084_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.doubleFlower2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoublePlant.field_176493_a, BlockDoublePlant.field_181084_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.unstableBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.manaBeacon, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.petalBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.specialFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR, ((BlockFlower)ModBlocks.specialFlower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.flower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.flower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.shinyFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.shinyFlower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.buriedPetals, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.buriedPetals).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.biomeStoneWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.dreamwoodWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.livingrockWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.livingwoodWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.prismarineWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.reedWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.stoneWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        for (Block b : ModFluffBlocks.biomeStoneSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.pavementSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.stoneSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        ArrayList otherSlabs = Lists.newArrayList((Object[])new Block[]{ModFluffBlocks.livingwoodSlab, ModFluffBlocks.livingwoodPlankSlab, ModFluffBlocks.livingrockSlab, ModFluffBlocks.dreamwoodSlab, ModFluffBlocks.livingrockBrickSlab, ModFluffBlocks.dreamwoodPlankSlab, ModFluffBlocks.prismarineSlab, ModFluffBlocks.prismarineBrickSlab, ModFluffBlocks.darkPrismarineSlab, ModFluffBlocks.reedSlab, ModFluffBlocks.thatchSlab, ModFluffBlocks.netherBrickSlab, ModFluffBlocks.soulBrickSlab, ModFluffBlocks.snowBrickSlab, ModFluffBlocks.tileSlab, ModFluffBlocks.manaQuartzSlab, ModFluffBlocks.blazeQuartzSlab, ModFluffBlocks.darkQuartzSlab, ModFluffBlocks.lavenderQuartzSlab, ModFluffBlocks.redQuartzSlab, ModFluffBlocks.elfQuartzSlab, ModFluffBlocks.sunnyQuartzSlab, ModFluffBlocks.dirtPathSlab, ModFluffBlocks.shimmerrockSlab, ModFluffBlocks.shimmerwoodPlankSlab, ModFluffBlocks.endStoneSlab, ModFluffBlocks.enderBrickSlab});
        for (Block b : otherSlabs) {
            if (b == null) continue;
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.biomeStoneFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.pavementFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.stoneFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        ArrayList otherFullSlabs = Lists.newArrayList((Object[])new Block[]{ModFluffBlocks.livingwoodSlabFull, ModFluffBlocks.livingwoodPlankSlabFull, ModFluffBlocks.livingrockSlabFull, ModFluffBlocks.dreamwoodSlabFull, ModFluffBlocks.livingrockBrickSlabFull, ModFluffBlocks.dreamwoodPlankSlabFull, ModFluffBlocks.prismarineSlabFull, ModFluffBlocks.prismarineBrickSlabFull, ModFluffBlocks.darkPrismarineSlabFull, ModFluffBlocks.reedSlabFull, ModFluffBlocks.thatchSlabFull, ModFluffBlocks.netherBrickSlabFull, ModFluffBlocks.soulBrickSlabFull, ModFluffBlocks.snowBrickSlabFull, ModFluffBlocks.tileSlabFull, ModFluffBlocks.darkQuartzSlabFull, ModFluffBlocks.manaQuartzSlabFull, ModFluffBlocks.blazeQuartzSlabFull, ModFluffBlocks.lavenderQuartzSlabFull, ModFluffBlocks.redQuartzSlabFull, ModFluffBlocks.elfQuartzSlabFull, ModFluffBlocks.sunnyQuartzSlabFull, ModFluffBlocks.dirtPathSlabFull, ModFluffBlocks.shimmerrockSlabFull, ModFluffBlocks.shimmerwoodPlankSlabFull, ModFluffBlocks.endStoneSlabFull, ModFluffBlocks.enderBrickSlabFull});
        for (Block b : otherFullSlabs) {
            if (b == null) continue;
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        ModelLoader.setCustomStateMapper((Block)ModBlocks.avatar, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.CARDINALS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.bellows, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.CARDINALS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.brewery, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.POWERED}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.gaiaHead, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSkull.field_176418_a, BlockSkull.field_176417_b}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.hourglass, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.POWERED}).func_178441_a());
    }

    private static void registerMushrooms() {
        Item item = Item.func_150898_a((Block)ModBlocks.mushroom);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.mushroom)).toString();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory_" + color.func_176610_l()));
        }
    }

    private static void registerFlowers() {
        String variant;
        String name;
        Item item = Item.func_150898_a((Block)ModBlocks.flower);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.flower)).toString();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory_" + color.func_176610_l()));
        }
        item = Item.func_150898_a((Block)ModBlocks.shinyFlower);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.shinyFlower)).toString();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory_" + color.func_176610_l()));
        }
        item = Item.func_150898_a((Block)ModBlocks.doubleFlower1);
        for (EnumDyeColor color : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1.func_177700_c()) {
            String name2 = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.doubleFlower1)).toString();
            variant = "inventory_" + color.func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name2, variant));
        }
        item = Item.func_150898_a((Block)ModBlocks.doubleFlower2);
        for (EnumDyeColor color : BotaniaStateProps.DOUBLEFLOWER_VARIANT_2.func_177700_c()) {
            String name3 = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.doubleFlower2)).toString();
            variant = "inventory_" + color.func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)(color.func_176765_a() - 8), (ModelResourceLocation)new ModelResourceLocation(name3, variant));
        }
    }

    private static void registerPavement() {
        Item item = Item.func_150898_a((Block)ModFluffBlocks.pavement);
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModFluffBlocks.pavement)).toString();
        block7: for (EnumDyeColor e : BotaniaStateProps.PAVEMENT_COLOR.func_177700_c()) {
            String variant = "color=" + e.func_176610_l();
            switch (e) {
                case BLACK: {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case BLUE: {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case RED: {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)3, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case YELLOW: {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)4, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case GREEN: {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)5, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, variant));
        }
    }

    private static void registerStairs() {
        for (Block b : ModFluffBlocks.stoneStairs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.pavementStairs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.biomeStoneStairs) {
            ModelHandler.registerItemModel(b);
        }
        ModelHandler.registerItemModel(ModFluffBlocks.blazeQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.darkPrismarineStairs);
        if (ConfigHandler.darkQuartzEnabled) {
            ModelHandler.registerItemModel(ModFluffBlocks.darkQuartzStairs);
        }
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodPlankStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.elfQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.enderBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.endStoneStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.lavenderQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodPlankStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.manaQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.netherBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.redQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.reedStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerrockStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerwoodPlankStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.snowBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.soulBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.sunnyQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.thatchStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.tileStairs);
    }

    private static void registerSlabs() {
        for (Block b : ModFluffBlocks.biomeStoneSlabs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.pavementSlabs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.stoneSlabs) {
            ModelHandler.registerItemModel(b);
        }
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodPlankSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.blazeQuartzSlab);
        if (ConfigHandler.darkQuartzEnabled) {
            ModelHandler.registerItemModel(ModFluffBlocks.darkQuartzSlab);
        }
        ModelHandler.registerItemModel(ModFluffBlocks.elfQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.lavenderQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.manaQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.redQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.sunnyQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodPlankSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.darkPrismarineSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.dirtPathSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerrockSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerwoodPlankSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.endStoneSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.enderBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.netherBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.soulBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.snowBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.tileSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.reedSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.thatchSlab);
    }

    private static void registerWalls() {
        String variantName;
        Item item = Item.func_150898_a((Block)ModFluffBlocks.biomeStoneWall);
        for (Enum variant : BotaniaStateProps.BIOMESTONEWALL_VARIANT.func_177700_c()) {
            variantName = "inventory_" + ((BiomeStoneVariant)variant).func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)(variant.ordinal() - 8), (ModelResourceLocation)new ModelResourceLocation("botania:biomeStoneA0Wall", variantName));
        }
        item = Item.func_150898_a((Block)ModFluffBlocks.stoneWall);
        for (Enum variant : BotaniaStateProps.FUTURESTONEWALL_VARIANT.func_177700_c()) {
            variantName = "inventory_" + ((FutureStoneVariant)variant).func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.ordinal(), (ModelResourceLocation)new ModelResourceLocation("botania:stone0Wall", variantName));
        }
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockWall);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodWall);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodWall);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineWall);
        ModelHandler.registerItemModel(ModFluffBlocks.reedWall);
    }

    private static void registerPanes() {
        ModelHandler.registerItemModel(ModFluffBlocks.alfglassPane);
        ModelHandler.registerItemModel(ModFluffBlocks.bifrostPane);
        ModelHandler.registerItemModel(ModFluffBlocks.managlassPane);
    }

    private static void registerAltars() {
        Item item = Item.func_150898_a((Block)ModBlocks.altar);
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.altar)).toString();
        for (int i = 0; i < AltarVariant.values().length - 1; ++i) {
            String variantName = "variant=" + AltarVariant.values()[i].func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, variantName));
        }
    }

    private static void registerQuartzBlocks() {
        for (Block b : Lists.newArrayList((Object[])new Block[]{ModFluffBlocks.blazeQuartz, ModFluffBlocks.darkQuartz, ModFluffBlocks.elfQuartz, ModFluffBlocks.lavenderQuartz, ModFluffBlocks.manaQuartz, ModFluffBlocks.redQuartz, ModFluffBlocks.sunnyQuartz})) {
            if (b == null) continue;
            Item item = Item.func_150898_a((Block)b);
            String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "variant=normal"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(name, "variant=chiseled"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(name, "variant=pillar_y"));
        }
    }

    private static void registerLuminizers() {
        Item item = Item.func_150898_a((Block)ModBlocks.lightRelay);
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModBlocks.lightRelay)).toString();
        for (LuminizerVariant v : LuminizerVariant.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)v.ordinal(), (ModelResourceLocation)new ModelResourceLocation(name, "powered=false,variant=" + v.func_176610_l()));
        }
    }

    private static <T extends Enum<T>> void registerVariantsDefaulted(Block b, Class<T> enumclazz, String variantHeader) {
        Item item = Item.func_150898_a((Block)b);
        for (Enum e : (Enum[])enumclazz.getEnumConstants()) {
            String baseName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString();
            String variantName = variantHeader + "=" + ((IStringSerializable)e).func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(baseName, variantName));
        }
    }

    private static void registerItemModelAllMeta(Item item, int range) {
        String loc = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
        for (int i = 0; i < range; ++i) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(loc, "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
    }

    private static void registerItemModelMetas(Item item, String loc, int range) {
        for (int i = 0; i < range; ++i) {
            String name = "botania:" + loc + i;
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(name, "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    private static void registerItemModel(Block b) {
        ModelHandler.registerItemModel(Item.func_150898_a((Block)b));
    }

    private static void registerItemModel(Item i, int meta) {
        ResourceLocation loc = i.getRegistryName();
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
    }

    private static void registerItemModel(Item i) {
        ModelHandler.registerItemModel(i, 0);
    }

    private ModelHandler() {
    }

    private static interface MesherWrapper
    extends ItemMeshDefinition {
        public static MesherWrapper of(MesherWrapper w) {
            return w;
        }

        public ModelResourceLocation getLocation(ItemStack var1);

        default public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.getLocation(stack);
        }
    }
}

