/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.multiblock.IMultiblockRenderHook;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.client.core.handler.ClientMethodHandles;
import vazkii.botania.client.core.handler.MultiblockBlockAccess;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.block.ModBlocks;

public final class MultiblockRenderHandler {
    private static MultiblockBlockAccess blockAccess = new MultiblockBlockAccess();
    private static int dimension;
    public static boolean rendering;
    public static MultiblockSet currentMultiblock;
    public static BlockPos anchor;
    public static EnumFacing angle;

    public static void setMultiblock(MultiblockSet set) {
        currentMultiblock = set;
        anchor = null;
        angle = EnumFacing.SOUTH;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.getDimension();
        }
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71439_g == null || mc.field_71476_x == null || mc.field_71476_x.func_178782_a() == null || mc.field_71439_g.func_70093_af() && anchor == null)) {
            this.renderPlayerLook((EntityPlayer)mc.field_71439_g, mc.field_71476_x);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (currentMultiblock != null && anchor == null && event.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            anchor = event.getPos();
            angle = event.getEntityPlayer().func_174811_aO();
            event.setCanceled(true);
        }
    }

    private void renderPlayerLook(EntityPlayer player, RayTraceResult src) {
        if (currentMultiblock != null && dimension == player.field_70170_p.field_73011_w.getDimension()) {
            BlockPos anchorPos = anchor != null ? anchor : src.func_178782_a();
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)2896);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            rendering = true;
            Multiblock mb = anchor != null ? currentMultiblock.getForFacing(angle) : currentMultiblock.getForEntity((Entity)player);
            boolean didAny = false;
            blockAccess.update((IBlockAccess)player.field_70170_p, mb, anchorPos);
            ShaderHelper.useShader(ShaderHelper.alpha, shader -> {
                int alpha = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"alpha");
                ARBShaderObjects.glUniform1fARB((int)alpha, (float)0.4f);
            });
            for (MultiblockComponent comp : mb.getComponents()) {
                if (!this.renderComponentInWorld(player.field_70170_p, mb, comp, anchorPos)) continue;
                didAny = true;
            }
            ShaderHelper.releaseShader();
            rendering = false;
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
            if (!didAny) {
                MultiblockRenderHandler.setMultiblock(null);
                player.func_146105_b(new TextComponentTranslation("botaniamisc.structureComplete", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
        }
    }

    private boolean renderComponentInWorld(World world, Multiblock mb, MultiblockComponent comp, BlockPos anchorPos) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        try {
            renderPosX = ClientMethodHandles.renderPosX_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosY = ClientMethodHandles.renderPosY_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosZ = ClientMethodHandles.renderPosZ_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
        }
        catch (Throwable t) {
            return true;
        }
        BlockPos pos = comp.getRelativePosition();
        BlockPos pos_ = pos.func_177971_a((Vec3i)anchorPos);
        if (anchor != null && comp.matches(world, pos_)) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        GlStateManager.func_179097_i();
        MultiblockRenderHandler.doRenderComponent(mb, comp, pos_);
        GlStateManager.func_179121_F();
        return true;
    }

    public static void renderMultiblockOnPage(Multiblock mb) {
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        blockAccess.update(null, mb, mb.offPos);
        for (MultiblockComponent comp : mb.getComponents()) {
            BlockPos pos = comp.getRelativePosition();
            MultiblockRenderHandler.doRenderComponent(mb, comp, pos.func_177971_a((Vec3i)mb.offPos));
        }
    }

    private static void doRenderComponent(Multiblock mb, MultiblockComponent comp, BlockPos pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IBlockState state = comp.getBlockState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (state == null) {
            return;
        }
        if (IMultiblockRenderHook.renderHooks.containsKey(state.func_177230_c())) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IMultiblockRenderHook renderHook = IMultiblockRenderHook.renderHooks.get(state.func_177230_c());
            if (renderHook.needsTranslate(state)) {
                GlStateManager.func_179137_b((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5));
            }
            renderHook.renderBlockForMultiblock(blockAccess, mb, state, comp);
        } else {
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            brd.func_175016_a(state, 1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    static {
        rendering = false;
        IMultiblockRenderHook.renderHooks.put(ModBlocks.pylon, new IMultiblockRenderHook(){

            @Override
            public void renderBlockForMultiblock(IBlockAccess world, Multiblock mb, IBlockState state, MultiblockComponent comp) {
                ItemStack stack = new ItemStack(ModBlocks.pylon, 1, state.func_177230_c().func_176201_c(state));
                IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
                GlStateManager.func_179139_a((double)0.65f, (double)0.65, (double)0.65f);
                GlStateManager.func_179109_b((float)0.5f, (float)-0.75f, (float)0.5f);
                Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178266_a(model, state, 1.0f, false);
            }

            @Override
            public boolean needsTranslate(IBlockState state) {
                return true;
            }
        });
        IMultiblockRenderHook.renderHooks.put(ModBlocks.pool, new IMultiblockRenderHook(){

            @Override
            public void renderBlockForMultiblock(IBlockAccess world, Multiblock mb, IBlockState state, MultiblockComponent comp) {
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(ModBlocks.pool.func_176223_P());
                Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178266_a(model, ModBlocks.pool.func_176223_P(), 1.0f, false);
            }

            @Override
            public boolean needsTranslate(IBlockState state) {
                return true;
            }
        });
    }
}

